# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_kb import AdvisoryKb
from vulncheck_sdk.models.advisory_kb_threat_description import AdvisoryKbThreatDescription
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMicrosoftKb(BaseModel):
    """
    AdvisoryMicrosoftKb
    """ # noqa: E501
    cve: Optional[StrictStr] = None
    date_added: Optional[StrictStr] = None
    kbs: Optional[List[AdvisoryKb]] = None
    threat: Optional[AdvisoryKbThreatDescription] = None
    title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cve", "date_added", "kbs", "threat", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMicrosoftKb from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in kbs (list)
        _items = []
        if self.kbs:
            for _item_kbs in self.kbs:
                if _item_kbs:
                    _items.append(_item_kbs.to_dict())
            _dict['kbs'] = _items
        # override the default output from pydantic by calling `to_dict()` of threat
        if self.threat:
            _dict['threat'] = self.threat.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMicrosoftKb from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "kbs": [AdvisoryKb.from_dict(_item) for _item in obj["kbs"]] if obj.get("kbs") is not None else None,
            "threat": AdvisoryKbThreatDescription.from_dict(obj["threat"]) if obj.get("threat") is not None else None,
            "title": obj.get("title")
        })
        return _obj


