# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_itw import AdvisoryITW
from vulncheck_sdk.models.advisory_mscvrf import AdvisoryMSCVRF
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMicrosoftCVRF(BaseModel):
    """
    AdvisoryMicrosoftCVRF
    """ # noqa: E501
    cve: Optional[List[StrictStr]] = None
    cvrf: Optional[AdvisoryMSCVRF] = None
    date_added: Optional[StrictStr] = None
    exploited_list: Optional[List[AdvisoryITW]] = None
    title: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cve", "cvrf", "date_added", "exploited_list", "title", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMicrosoftCVRF from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cvrf
        if self.cvrf:
            _dict['cvrf'] = self.cvrf.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in exploited_list (list)
        _items = []
        if self.exploited_list:
            for _item_exploited_list in self.exploited_list:
                if _item_exploited_list:
                    _items.append(_item_exploited_list.to_dict())
            _dict['exploited_list'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMicrosoftCVRF from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "cvrf": AdvisoryMSCVRF.from_dict(obj["cvrf"]) if obj.get("cvrf") is not None else None,
            "date_added": obj.get("date_added"),
            "exploited_list": [AdvisoryITW.from_dict(_item) for _item in obj["exploited_list"]] if obj.get("exploited_list") is not None else None,
            "title": obj.get("title"),
            "url": obj.get("url")
        })
        return _obj


