# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_cve_details_link import AdvisoryCVEDetailsLink
from vulncheck_sdk.models.advisory_me_product import AdvisoryMEProduct
from vulncheck_sdk.models.advisory_product_specific_detail import AdvisoryProductSpecificDetail
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryManageEngine(BaseModel):
    """
    AdvisoryManageEngine
    """ # noqa: E501
    advisory: Optional[StrictStr] = Field(default=None, alias="ADVISORY")
    added_time: Optional[StrictStr] = Field(default=None, alias="Added_Time")
    cve_details_link: Optional[AdvisoryCVEDetailsLink] = Field(default=None, alias="CVE_Details_Link")
    cve_id: Optional[StrictStr] = Field(default=None, alias="CVE_ID")
    cvss_severity_rating: Optional[StrictStr] = Field(default=None, alias="CVSS_Severity_Rating")
    fixed: Optional[StrictStr] = Field(default=None, alias="Fixed")
    for_product_search: Optional[StrictStr] = Field(default=None, alias="For_product_search")
    id: Optional[StrictStr] = Field(default=None, alias="ID")
    product: Optional[AdvisoryMEProduct] = Field(default=None, alias="Product")
    product_list: Optional[List[AdvisoryMEProduct]] = Field(default=None, alias="Product_list")
    product_specific_details: Optional[List[AdvisoryProductSpecificDetail]] = Field(default=None, alias="Product_specific_details")
    summary: Optional[StrictStr] = Field(default=None, alias="Summary")
    version: Optional[StrictStr] = Field(default=None, alias="Version")
    index_field: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["ADVISORY", "Added_Time", "CVE_Details_Link", "CVE_ID", "CVSS_Severity_Rating", "Fixed", "For_product_search", "ID", "Product", "Product_list", "Product_specific_details", "Summary", "Version", "index_field"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryManageEngine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cve_details_link
        if self.cve_details_link:
            _dict['CVE_Details_Link'] = self.cve_details_link.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product
        if self.product:
            _dict['Product'] = self.product.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in product_list (list)
        _items = []
        if self.product_list:
            for _item_product_list in self.product_list:
                if _item_product_list:
                    _items.append(_item_product_list.to_dict())
            _dict['Product_list'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in product_specific_details (list)
        _items = []
        if self.product_specific_details:
            for _item_product_specific_details in self.product_specific_details:
                if _item_product_specific_details:
                    _items.append(_item_product_specific_details.to_dict())
            _dict['Product_specific_details'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryManageEngine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ADVISORY": obj.get("ADVISORY"),
            "Added_Time": obj.get("Added_Time"),
            "CVE_Details_Link": AdvisoryCVEDetailsLink.from_dict(obj["CVE_Details_Link"]) if obj.get("CVE_Details_Link") is not None else None,
            "CVE_ID": obj.get("CVE_ID"),
            "CVSS_Severity_Rating": obj.get("CVSS_Severity_Rating"),
            "Fixed": obj.get("Fixed"),
            "For_product_search": obj.get("For_product_search"),
            "ID": obj.get("ID"),
            "Product": AdvisoryMEProduct.from_dict(obj["Product"]) if obj.get("Product") is not None else None,
            "Product_list": [AdvisoryMEProduct.from_dict(_item) for _item in obj["Product_list"]] if obj.get("Product_list") is not None else None,
            "Product_specific_details": [AdvisoryProductSpecificDetail.from_dict(_item) for _item in obj["Product_specific_details"]] if obj.get("Product_specific_details") is not None else None,
            "Summary": obj.get("Summary"),
            "Version": obj.get("Version"),
            "index_field": obj.get("index_field")
        })
        return _obj


