# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_mcpe_match import AdvisoryMCPEMatch
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMNodes(BaseModel):
    """
    AdvisoryMNodes
    """ # noqa: E501
    cpe_match: Optional[List[AdvisoryMCPEMatch]] = Field(default=None, alias="cpeMatch")
    negate: Optional[StrictBool] = None
    operator: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cpeMatch", "negate", "operator"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMNodes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cpe_match (list)
        _items = []
        if self.cpe_match:
            for _item_cpe_match in self.cpe_match:
                if _item_cpe_match:
                    _items.append(_item_cpe_match.to_dict())
            _dict['cpeMatch'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMNodes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cpeMatch": [AdvisoryMCPEMatch.from_dict(_item) for _item in obj["cpeMatch"]] if obj.get("cpeMatch") is not None else None,
            "negate": obj.get("negate"),
            "operator": obj.get("operator")
        })
        return _obj


