# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_credit import AdvisoryCredit
from vulncheck_sdk.models.advisory_impact import AdvisoryImpact
from vulncheck_sdk.models.advisory_m_affected import AdvisoryMAffected
from vulncheck_sdk.models.advisory_m_descriptions import AdvisoryMDescriptions
from vulncheck_sdk.models.advisory_m_problem_types import AdvisoryMProblemTypes
from vulncheck_sdk.models.advisory_m_provider_metadata import AdvisoryMProviderMetadata
from vulncheck_sdk.models.advisory_m_reference import AdvisoryMReference
from vulncheck_sdk.models.advisory_mcpe_applicability import AdvisoryMCPEApplicability
from vulncheck_sdk.models.advisory_metric import AdvisoryMetric
from vulncheck_sdk.models.advisory_timeline import AdvisoryTimeline
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMCna(BaseModel):
    """
    AdvisoryMCna
    """ # noqa: E501
    affected: Optional[List[AdvisoryMAffected]] = None
    cpe_applicability: Optional[List[AdvisoryMCPEApplicability]] = Field(default=None, alias="cpeApplicability")
    credits: Optional[List[AdvisoryCredit]] = None
    descriptions: Optional[List[AdvisoryMDescriptions]] = None
    impacts: Optional[List[AdvisoryImpact]] = None
    metrics: Optional[List[AdvisoryMetric]] = None
    problem_types: Optional[List[AdvisoryMProblemTypes]] = Field(default=None, alias="problemTypes")
    provider_metadata: Optional[AdvisoryMProviderMetadata] = Field(default=None, alias="providerMetadata")
    references: Optional[List[AdvisoryMReference]] = None
    tags: Optional[List[StrictStr]] = None
    timeline: Optional[List[AdvisoryTimeline]] = None
    title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affected", "cpeApplicability", "credits", "descriptions", "impacts", "metrics", "problemTypes", "providerMetadata", "references", "tags", "timeline", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMCna from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected (list)
        _items = []
        if self.affected:
            for _item_affected in self.affected:
                if _item_affected:
                    _items.append(_item_affected.to_dict())
            _dict['affected'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cpe_applicability (list)
        _items = []
        if self.cpe_applicability:
            for _item_cpe_applicability in self.cpe_applicability:
                if _item_cpe_applicability:
                    _items.append(_item_cpe_applicability.to_dict())
            _dict['cpeApplicability'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credits (list)
        _items = []
        if self.credits:
            for _item_credits in self.credits:
                if _item_credits:
                    _items.append(_item_credits.to_dict())
            _dict['credits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in descriptions (list)
        _items = []
        if self.descriptions:
            for _item_descriptions in self.descriptions:
                if _item_descriptions:
                    _items.append(_item_descriptions.to_dict())
            _dict['descriptions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in impacts (list)
        _items = []
        if self.impacts:
            for _item_impacts in self.impacts:
                if _item_impacts:
                    _items.append(_item_impacts.to_dict())
            _dict['impacts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in metrics (list)
        _items = []
        if self.metrics:
            for _item_metrics in self.metrics:
                if _item_metrics:
                    _items.append(_item_metrics.to_dict())
            _dict['metrics'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in problem_types (list)
        _items = []
        if self.problem_types:
            for _item_problem_types in self.problem_types:
                if _item_problem_types:
                    _items.append(_item_problem_types.to_dict())
            _dict['problemTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of provider_metadata
        if self.provider_metadata:
            _dict['providerMetadata'] = self.provider_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in timeline (list)
        _items = []
        if self.timeline:
            for _item_timeline in self.timeline:
                if _item_timeline:
                    _items.append(_item_timeline.to_dict())
            _dict['timeline'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMCna from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affected": [AdvisoryMAffected.from_dict(_item) for _item in obj["affected"]] if obj.get("affected") is not None else None,
            "cpeApplicability": [AdvisoryMCPEApplicability.from_dict(_item) for _item in obj["cpeApplicability"]] if obj.get("cpeApplicability") is not None else None,
            "credits": [AdvisoryCredit.from_dict(_item) for _item in obj["credits"]] if obj.get("credits") is not None else None,
            "descriptions": [AdvisoryMDescriptions.from_dict(_item) for _item in obj["descriptions"]] if obj.get("descriptions") is not None else None,
            "impacts": [AdvisoryImpact.from_dict(_item) for _item in obj["impacts"]] if obj.get("impacts") is not None else None,
            "metrics": [AdvisoryMetric.from_dict(_item) for _item in obj["metrics"]] if obj.get("metrics") is not None else None,
            "problemTypes": [AdvisoryMProblemTypes.from_dict(_item) for _item in obj["problemTypes"]] if obj.get("problemTypes") is not None else None,
            "providerMetadata": AdvisoryMProviderMetadata.from_dict(obj["providerMetadata"]) if obj.get("providerMetadata") is not None else None,
            "references": [AdvisoryMReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "tags": obj.get("tags"),
            "timeline": [AdvisoryTimeline.from_dict(_item) for _item in obj["timeline"]] if obj.get("timeline") is not None else None,
            "title": obj.get("title")
        })
        return _obj


