# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_cvss import AdvisoryCVSS
from vulncheck_sdk.models.advisory_jvn_reference import AdvisoryJVNReference
from vulncheck_sdk.models.advisory_jvncpe import AdvisoryJVNCPE
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryJVNAdvisoryItem(BaseModel):
    """
    AdvisoryJVNAdvisoryItem
    """ # noqa: E501
    cpe: Optional[List[AdvisoryJVNCPE]] = None
    cve: Optional[List[StrictStr]] = None
    cvss: Optional[List[AdvisoryCVSS]] = None
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    description_en: Optional[StrictStr] = None
    identifier: Optional[StrictStr] = None
    issued: Optional[StrictStr] = None
    modified: Optional[StrictStr] = None
    references: Optional[List[AdvisoryJVNReference]] = None
    title: Optional[StrictStr] = None
    title_en: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    url_en: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cpe", "cve", "cvss", "date_added", "description", "description_en", "identifier", "issued", "modified", "references", "title", "title_en", "updated_at", "url", "url_en"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryJVNAdvisoryItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cpe (list)
        _items = []
        if self.cpe:
            for _item_cpe in self.cpe:
                if _item_cpe:
                    _items.append(_item_cpe.to_dict())
            _dict['cpe'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss (list)
        _items = []
        if self.cvss:
            for _item_cvss in self.cvss:
                if _item_cvss:
                    _items.append(_item_cvss.to_dict())
            _dict['cvss'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryJVNAdvisoryItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cpe": [AdvisoryJVNCPE.from_dict(_item) for _item in obj["cpe"]] if obj.get("cpe") is not None else None,
            "cve": obj.get("cve"),
            "cvss": [AdvisoryCVSS.from_dict(_item) for _item in obj["cvss"]] if obj.get("cvss") is not None else None,
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "description_en": obj.get("description_en"),
            "identifier": obj.get("identifier"),
            "issued": obj.get("issued"),
            "modified": obj.get("modified"),
            "references": [AdvisoryJVNReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "title": obj.get("title"),
            "title_en": obj.get("title_en"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url"),
            "url_en": obj.get("url_en")
        })
        return _obj


