# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_record_type import AdvisoryRecordType
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryIpIntelRecord(BaseModel):
    """
    AdvisoryIpIntelRecord
    """ # noqa: E501
    asn: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    country_code: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    feed_ids: Optional[List[StrictStr]] = None
    hostnames: Optional[List[StrictStr]] = None
    ip: Optional[StrictStr] = None
    last_seen: Optional[StrictStr] = Field(default=None, alias="lastSeen")
    matches: Optional[List[StrictStr]] = None
    port: Optional[StrictInt] = None
    ssl: Optional[StrictBool] = None
    type: Optional[AdvisoryRecordType] = None
    __properties: ClassVar[List[str]] = ["asn", "city", "country", "country_code", "cve", "feed_ids", "hostnames", "ip", "lastSeen", "matches", "port", "ssl", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryIpIntelRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryIpIntelRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asn": obj.get("asn"),
            "city": obj.get("city"),
            "country": obj.get("country"),
            "country_code": obj.get("country_code"),
            "cve": obj.get("cve"),
            "feed_ids": obj.get("feed_ids"),
            "hostnames": obj.get("hostnames"),
            "ip": obj.get("ip"),
            "lastSeen": obj.get("lastSeen"),
            "matches": obj.get("matches"),
            "port": obj.get("port"),
            "ssl": obj.get("ssl"),
            "type": AdvisoryRecordType.from_dict(obj["type"]) if obj.get("type") is not None else None
        })
        return _obj


