# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_go_vuln_database_specific import AdvisoryGoVulnDatabaseSpecific
from vulncheck_sdk.models.advisory_go_vuln_ecosystem_specific import AdvisoryGoVulnEcosystemSpecific
from vulncheck_sdk.models.advisory_go_vuln_package import AdvisoryGoVulnPackage
from vulncheck_sdk.models.advisory_go_vuln_ranges import AdvisoryGoVulnRanges
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryGoVulnAffected(BaseModel):
    """
    AdvisoryGoVulnAffected
    """ # noqa: E501
    database_specific: Optional[AdvisoryGoVulnDatabaseSpecific] = None
    ecosystem_specific: Optional[AdvisoryGoVulnEcosystemSpecific] = None
    package: Optional[AdvisoryGoVulnPackage] = None
    ranges: Optional[List[AdvisoryGoVulnRanges]] = None
    __properties: ClassVar[List[str]] = ["database_specific", "ecosystem_specific", "package", "ranges"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryGoVulnAffected from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of database_specific
        if self.database_specific:
            _dict['database_specific'] = self.database_specific.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ecosystem_specific
        if self.ecosystem_specific:
            _dict['ecosystem_specific'] = self.ecosystem_specific.to_dict()
        # override the default output from pydantic by calling `to_dict()` of package
        if self.package:
            _dict['package'] = self.package.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ranges (list)
        _items = []
        if self.ranges:
            for _item_ranges in self.ranges:
                if _item_ranges:
                    _items.append(_item_ranges.to_dict())
            _dict['ranges'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryGoVulnAffected from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "database_specific": AdvisoryGoVulnDatabaseSpecific.from_dict(obj["database_specific"]) if obj.get("database_specific") is not None else None,
            "ecosystem_specific": AdvisoryGoVulnEcosystemSpecific.from_dict(obj["ecosystem_specific"]) if obj.get("ecosystem_specific") is not None else None,
            "package": AdvisoryGoVulnPackage.from_dict(obj["package"]) if obj.get("package") is not None else None,
            "ranges": [AdvisoryGoVulnRanges.from_dict(_item) for _item in obj["ranges"]] if obj.get("ranges") is not None else None
        })
        return _obj


