# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_distro_version import AdvisoryDistroVersion
from vulncheck_sdk.models.advisory_sec_fix import AdvisorySecFix
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryDistroPackage(BaseModel):
    """
    AdvisoryDistroPackage
    """ # noqa: E501
    binary: Optional[StrictBool] = None
    cve: Optional[List[StrictStr]] = None
    license: Optional[List[StrictStr]] = None
    name: Optional[StrictStr] = None
    sec_fixes: Optional[List[AdvisorySecFix]] = Field(default=None, alias="secFixes")
    versions: Optional[List[AdvisoryDistroVersion]] = None
    __properties: ClassVar[List[str]] = ["binary", "cve", "license", "name", "secFixes", "versions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryDistroPackage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sec_fixes (list)
        _items = []
        if self.sec_fixes:
            for _item_sec_fixes in self.sec_fixes:
                if _item_sec_fixes:
                    _items.append(_item_sec_fixes.to_dict())
            _dict['secFixes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in versions (list)
        _items = []
        if self.versions:
            for _item_versions in self.versions:
                if _item_versions:
                    _items.append(_item_versions.to_dict())
            _dict['versions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryDistroPackage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "binary": obj.get("binary"),
            "cve": obj.get("cve"),
            "license": obj.get("license"),
            "name": obj.get("name"),
            "secFixes": [AdvisorySecFix.from_dict(_item) for _item in obj["secFixes"]] if obj.get("secFixes") is not None else None,
            "versions": [AdvisoryDistroVersion.from_dict(_item) for _item in obj["versions"]] if obj.get("versions") is not None else None
        })
        return _obj


