# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_alpine_linux_sec_db_package import AdvisoryAlpineLinuxSecDBPackage
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryAlpineLinuxSecDB(BaseModel):
    """
    AdvisoryAlpineLinuxSecDB
    """ # noqa: E501
    apkurl: Optional[StrictStr] = None
    archs: Optional[List[StrictStr]] = None
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    distroversion: Optional[StrictStr] = None
    packages: Optional[List[AdvisoryAlpineLinuxSecDBPackage]] = None
    reponame: Optional[StrictStr] = None
    urlprefix: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["apkurl", "archs", "cve", "date_added", "distroversion", "packages", "reponame", "urlprefix"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryAlpineLinuxSecDB from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in packages (list)
        _items = []
        if self.packages:
            for _item_packages in self.packages:
                if _item_packages:
                    _items.append(_item_packages.to_dict())
            _dict['packages'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryAlpineLinuxSecDB from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apkurl": obj.get("apkurl"),
            "archs": obj.get("archs"),
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "distroversion": obj.get("distroversion"),
            "packages": [AdvisoryAlpineLinuxSecDBPackage.from_dict(_item) for _item in obj["packages"]] if obj.get("packages") is not None else None,
            "reponame": obj.get("reponame"),
            "urlprefix": obj.get("urlprefix")
        })
        return _obj


