# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_adobe_affected import AdvisoryAdobeAffected
from vulncheck_sdk.models.advisory_adobe_cve import AdvisoryAdobeCVE
from vulncheck_sdk.models.advisory_adobe_solution import AdvisoryAdobeSolution
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryAdobeAdvisory(BaseModel):
    """
    AdvisoryAdobeAdvisory
    """ # noqa: E501
    adobe_cves: Optional[List[AdvisoryAdobeCVE]] = None
    affected: Optional[List[AdvisoryAdobeAffected]] = None
    bulletin_id: Optional[StrictStr] = Field(default=None, alias="bulletinId")
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    link: Optional[StrictStr] = None
    solutions: Optional[List[AdvisoryAdobeSolution]] = None
    updated_at: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["adobe_cves", "affected", "bulletinId", "cve", "date_added", "link", "solutions", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryAdobeAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in adobe_cves (list)
        _items = []
        if self.adobe_cves:
            for _item_adobe_cves in self.adobe_cves:
                if _item_adobe_cves:
                    _items.append(_item_adobe_cves.to_dict())
            _dict['adobe_cves'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in affected (list)
        _items = []
        if self.affected:
            for _item_affected in self.affected:
                if _item_affected:
                    _items.append(_item_affected.to_dict())
            _dict['affected'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in solutions (list)
        _items = []
        if self.solutions:
            for _item_solutions in self.solutions:
                if _item_solutions:
                    _items.append(_item_solutions.to_dict())
            _dict['solutions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryAdobeAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adobe_cves": [AdvisoryAdobeCVE.from_dict(_item) for _item in obj["adobe_cves"]] if obj.get("adobe_cves") is not None else None,
            "affected": [AdvisoryAdobeAffected.from_dict(_item) for _item in obj["affected"]] if obj.get("affected") is not None else None,
            "bulletinId": obj.get("bulletinId"),
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "link": obj.get("link"),
            "solutions": [AdvisoryAdobeSolution.from_dict(_item) for _item in obj["solutions"]] if obj.get("solutions") is not None else None,
            "updated_at": obj.get("updated_at")
        })
        return _obj


