# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client, EventHandlerFn, UnsubscribeFn
from .constants import *



class SettingsClient(Client):
    """
    Non-volatile key-value storage interface for storing settings.
    Implements a client for the `Settings <https://microsoft.github.io/jacdac-docs/services/settings>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_SETTINGS, JD_SETTINGS_PACK_FORMATS, role)


    def on_change(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Notifies that some setting have been modified.
        """
        return self.on_event(JD_SETTINGS_EV_CHANGE, handler)


    def get(self, key: str) -> None:
        """
        Get the value of given setting. If no such entry exists, the value returned is empty.
        """
        self.send_cmd_packed(JD_SETTINGS_CMD_GET, key)
    
