# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional


class MagneticFieldLevelClient(SensorClient):
    """
    A sensor that measures strength and polarity of magnetic field.
    Implements a client for the `Magnetic field level <https://microsoft.github.io/jacdac-docs/services/magneticfieldlevel>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_strength_value: Optional[float] = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_MAGNETIC_FIELD_LEVEL, JD_MAGNETIC_FIELD_LEVEL_PACK_FORMATS, role)
        self.missing_strength_value = missing_strength_value

    @property
    def strength(self) -> Optional[float]:
        """
        Indicates the strength of magnetic field between -1 and 1.
        When no magnet is present the value should be around 0.
        For analog sensors,
        when the north pole of the magnet is on top of the module
        and closer than south pole, then the value should be positive.
        For digital sensors,
        the value should either `0` or `1`, regardless of polarity., _: /
        """
        self.refresh_reading()
        return self.register(JD_MAGNETIC_FIELD_LEVEL_REG_STRENGTH).float_value(self.missing_strength_value, 100)

    @property
    def variant(self) -> Optional[MagneticFieldLevelVariant]:
        """
        (Optional) Determines which magnetic poles the sensor can detected,
        and whether or not it can measure their strength or just presence., 
        """
        return self.register(JD_MAGNETIC_FIELD_LEVEL_REG_VARIANT).value()

    def on_active(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when strong-enough magnetic field is detected.
        """
        return self.on_event(JD_MAGNETIC_FIELD_LEVEL_EV_ACTIVE, handler)

    def on_inactive(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when strong-enough magnetic field is no longer detected.
        """
        return self.on_event(JD_MAGNETIC_FIELD_LEVEL_EV_INACTIVE, handler)

    
