# Generated by Django 3.0 on 2025-08-12 08:14

import django.db.models.deletion
from django.db import migrations, models

import data_exchange_tool.models.import_job
import data_exchange_tool.storage


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='ImportJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creation_timestamp', models.DateTimeField(auto_now_add=True)),
                ('update_timestamp', models.DateTimeField(auto_now=True)),
                ('import_status', models.CharField(choices=[('CREATED', 'CREATED'), ('PREVIEW_IN_PROGRESS', 'PREVIEW_IN_PROGRESS'), ('PREVIEW_FAILED', 'PREVIEW_FAILED'), ('PREVIEW_SUCCEEDED', 'PREVIEW_SUCCEEDED'), ('IMPORT_IN_PROGRESS', 'IMPORT_IN_PROGRESS'), ('IMPORT_FAILED', 'IMPORT_FAILED'), ('IMPORT_SUCCEEDED', 'IMPORT_SUCCEEDED'), ('CANCELLED', 'CANCELLED')], default='CREATED', max_length=32)),
                ('uploaded_file', models.FileField(blank=True, null=True, storage=data_exchange_tool.storage.ModelDataExchangeS3Storage(base_dir='uploaded_files'), upload_to=data_exchange_tool.models.import_job.custom_file_name, verbose_name='Uploaded file')),
                ('file_hash', models.CharField(blank=True, max_length=255, null=True)),
                ('async_task_id', models.CharField(blank=True, max_length=255, null=True, verbose_name='Task ID')),
                ('initiated_by', models.CharField(blank=True, max_length=255, null=True, verbose_name='Initiated by')),
                ('changes_preview_file', models.FileField(blank=True, null=True, storage=data_exchange_tool.storage.ModelDataExchangeS3Storage(base_dir='preview_files'), upload_to=data_exchange_tool.models.import_job.custom_file_name, verbose_name='Preview changes file')),
                ('total_rows', models.PositiveIntegerField(blank=True, null=True, verbose_name='Total rows')),
                ('inserted_rows', models.PositiveIntegerField(blank=True, null=True, verbose_name='Inserted rows')),
                ('updated_rows', models.PositiveIntegerField(blank=True, null=True, verbose_name='Updated rows')),
                ('error_rows', models.PositiveIntegerField(blank=True, null=True, verbose_name='Error rows')),
                ('import_serializer_class_name', models.CharField(blank=True, editable=False, max_length=255, null=True, verbose_name='Import serializer class name')),
                ('status_message', models.TextField()),
                ('import_content_type', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType')),
            ],
            options={
                'ordering': ['-initiated_by'],
            },
        ),
        migrations.CreateModel(
            name='StockRecordImportJob',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('data_exchange_tool.importjob',),
        ),
    ]
