# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.i18n
from typing_extensions import Literal
"""
Const

Do NOT insert any new values! Locale data number format creation must match these values! Number formatter internals must match these values!

Number format indices to be passed as the index argument to XNumberFormatCode.getFormatCode() or com.sun.star.util.XNumberFormatTypes.getFormatIndex().

Each locale can support up to about 5000 arbitrary format codes. But for backward compatibility reasons, each locale MUST support some predefined format codes. These predefined format codes are accessed through indices as the following, and the locale data format code definitions in i18npool/source/localedata/data/*.xml MUST have matching entries in the form

<FormatElement formatindex=\"0\">

(see also FormatElement.formatIndex()).

The index values are also used to define the enum NfIndexTableOffset in file svtools/inc/zforlist.hxx

Note: This index has nothing to do with the index key used internally by the number formatter.

Date formats may have a comment of DIN/EN/ISO, meaning

Some names of date format constants indicate a special behavior of those formats in StarOffice 5.2 or older. Those are:

See Also:
    `API NumberFormatIndex <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1i18n_1_1NumberFormatIndex.html>`_
"""
NUMBER_START: Literal[0]
"""
Start of simple numerical formats (first format)
"""
NUMBER_STANDARD: Literal[0]
"""
The \"General\" standard format formatindex=\"0\".
"""
NUMBER_INT: Literal[1]
"""
0 Integer number formatindex=\"1\"
"""
NUMBER_DEC2: Literal[2]
"""
0.00 Decimal number with 2 decimals formatindex=\"2\"
"""
NUMBER_1000INT: Literal[3]
"""
#,##0 Integer number with group separator formatindex=\"3\"
"""
NUMBER_1000DEC2: Literal[4]
"""
#,##0.00 Decimal number with group separator formatindex=\"4\"
"""
NUMBER_SYSTEM: Literal[5]
"""
#,##0.00 In SO5/Win this format was retrieved from the Regional Settings formatindex=\"5\"
"""
NUMBER_END: Literal[5]
"""
End of simple numerical formats (last format)
"""
SCIENTIFIC_START: Literal[6]
"""
Start of Scientific formats (first format)
"""
SCIENTIFIC_000E000: Literal[6]
"""
0.00E+000 Number in scientific notation with exponent in 3 digit placeholders formatindex=\"6\"
"""
SCIENTIFIC_000E00: Literal[7]
"""
0.00E+00 Number in scientific notation with exponent in 2 digit placeholders formatindex=\"7\"
"""
SCIENTIFIC_END: Literal[7]
"""
End of Scientific formats (last format)
"""
PERCENT_START: Literal[8]
"""
Start of Percent formats (first format)
"""
PERCENT_INT: Literal[8]
"""
0% Percentage format, rounded to integer formatindex=\"8\"
"""
PERCENT_DEC2: Literal[9]
"""
0.00% Percentage format, rounded to 2 decimals formatindex=\"9\"
"""
PERCENT_END: Literal[9]
"""
End of Percent formats (last format)
"""
FRACTION_START: Literal[10]
"""
Start of Fraction formats (first format)
"""
FRACTION_1: Literal[10]
FRACTION_2: Literal[11]
FRACTION_END: Literal[11]
"""
End of Fraction formats (last format)
"""
CURRENCY_START: Literal[12]
"""
Start of Currency formats (first format)
"""
CURRENCY_1000INT: Literal[12]
"""
#,##0 DM Integer currency format with group separator formatindex=\"12\"
"""
CURRENCY_1000DEC2: Literal[13]
"""
#,##0.00 DM Decimal currency format with group separator formatindex=\"13\"
"""
CURRENCY_1000INT_RED: Literal[14]
"""
#,##0 DM Integer currency format with negative in red formatindex=\"14\"
"""
CURRENCY_1000DEC2_RED: Literal[15]
"""
#,##0.00 DM Decimal currency format with negative in red formatindex=\"15\"
"""
CURRENCY_1000DEC2_CCC: Literal[16]
"""
#,##0.00 DEM Currency in ISO-4217 abbreviation format formatindex=\"16\"
"""
CURRENCY_1000DEC2_DASHED: Literal[17]
"""
#,##0.– DM Currency format with dash representing 0 in decimals formatindex=\"17\"
"""
CURRENCY_END: Literal[17]
"""
End of Currency formats (last format)
"""
DATE_START: Literal[18]
"""
Start of Date formats (first format)
"""
DATE_SYSTEM_SHORT: Literal[18]
"""
08.10.97 see also DATE_SYSTEM_... explanation formatindex=\"18\"
"""
DATE_SYSTEM_LONG: Literal[19]
"""
Wednesday, 8.

October 1997 see also DATE_SYSTEM_... explanation formatindex=\"19\"
"""
DATE_SYS_DDMMYY: Literal[20]
"""
08.10.97 see also DATE_SYS_... explanation formatindex=\"20\"
"""
DATE_SYS_DDMMYYYY: Literal[21]
"""
08.10.1997 see also DATE_SYS_...

explanation Note: When editing already existing date data this format is forced in order to always edit the full century. formatindex=\"21\"
"""
DATE_SYS_DMMMYY: Literal[22]
DATE_SYS_DMMMYYYY: Literal[23]
DATE_DIN_DMMMYYYY: Literal[24]
DATE_SYS_DMMMMYYYY: Literal[25]
DATE_DIN_DMMMMYYYY: Literal[26]
DATE_SYS_NNDMMMYY: Literal[27]
"""
Wed, 8. Oct 97 see also DATE_SYS_... explanation formatindex=\"27\".
"""
DATE_DEF_NNDDMMMYY: Literal[28]
"""
Wed 08.Oct 97 see also DATE_DEF_... explanation formatindex=\"28\".
"""
DATE_SYS_NNDMMMMYYYY: Literal[29]
"""
Wed, 8. October 1997 see also DATE_SYS_... explanation formatindex=\"29\".
"""
DATE_SYS_NNNNDMMMMYYYY: Literal[30]
"""
Wednesday, 8. October 1997 formatindex=\"30\".
"""
DATE_DIN_MMDD: Literal[31]
"""
10-08 DIN/EN formatindex=\"31\"
"""
DATE_DIN_YYMMDD: Literal[32]
"""
97-10-08 DIN/EN formatindex=\"32\"
"""
DATE_DIN_YYYYMMDD: Literal[33]
"""
1997-10-08 DIN/EN/ISO formatindex=\"33\"
"""
DATE_SYS_MMYY: Literal[34]
"""
10.97 see also DATE_SYS_... explanation formatindex=\"34\"
"""
DATE_SYS_DDMMM: Literal[35]
"""
08.Oct see also DATE_SYS_... explanation formatindex=\"35\"
"""
DATE_MMMM: Literal[36]
"""
October formatindex=\"36\".
"""
DATE_QQJJ: Literal[37]
"""
4th quarter 97 formatindex=\"37\"
"""
DATE_WW: Literal[38]
"""
week of year formatindex=\"38\"
"""
DATE_END: Literal[38]
"""
End of Date formats (last format)
"""
TIME_START: Literal[39]
"""
Start of Time formats (first format)
"""
TIME_HHMM: Literal[39]
"""
HH:MM Time format with hour and minute formatindex=\"39\".
"""
TIME_HHMMSS: Literal[40]
"""
HH:MM:SS Time format with hour, minute and second formatindex=\"40\".
"""
TIME_HHMMAMPM: Literal[41]
"""
HH:MM AM/PM Time format with hour, minute and morning/afternoon notation formatindex=\"41\".
"""
TIME_HHMMSSAMPM: Literal[42]
"""
HH:MM:SS AM/PM Time format with hour, minute, second and morning/afternoon notation formatindex=\"42\".
"""
TIME_HH_MMSS: Literal[43]
"""
[HH]:MM:SS Time format with amount of hours formatindex=\"43\"
"""
TIME_MMSS00: Literal[44]
"""
MM:SS,00 Time format with second in fraction formatindex=\"44\".
"""
TIME_HH_MMSS00: Literal[45]
"""
[HH]:MM:SS,00 Time format with amount of hours and seconds with fraction formatindex=\"45\"
"""
TIME_END: Literal[45]
"""
End of Time formats (last format)
"""
DATETIME_START: Literal[46]
"""
Start of DateTime formats (first format)
"""
DATETIME_SYSTEM_SHORT_HHMM: Literal[46]
"""
08.10.97 01:23 Date/time format formatindex=\"46\"
"""
DATETIME_SYS_DDMMYYYY_HHMMSS: Literal[47]
"""
08.10.1997 01:23:45 Date/time format with second Note: When editing already existing date/time data this format is forced in order to always edit the full century.

formatindex=\"47\"
"""
DATETIME_END: Literal[47]
"""
End of DateTime formats (last format)
"""
BOOLEAN: Literal[48]
"""
BOOLEAN format.
"""
TEXT: Literal[49]
"""
Text format.
"""
INDEX_TABLE_ENTRIES: Literal[50]
"""
count of built-in format codes.
"""

