# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.drawing
import typing
from .shape import Shape as Shape_85cc09e5
if typing.TYPE_CHECKING:
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73

class AppletShape(Shape_85cc09e5):
    """
    Service Class

    This Shape encapsulates an applet.
    
    An applet is a small Java-based program that is executed and rendered embedded in a document.

    See Also:
        `API AppletShape <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1drawing_1_1AppletShape.html>`_
    """
    @property
    def AppletCommands(self) -> 'typing.Tuple[PropertyValue_c9610c73, ...]':
        """
        This sequence contains parameters that are passed to the applet when it is initialized.
        """
    @property
    def AppletCode(self) -> str:
        """
        This property specifies one of the following: The name of the class file that contains the compiled applet subclass.
        
        The path to the class, including the class file itself.
        """
    @property
    def AppletCodeBase(self) -> str:
        """
        This property specifies the base URI for the applet.
        
        If this property is empty, then it defaults the same base URI as for the current document.
        """
    @property
    def AppletIsScript(self) -> bool:
        """
        This property specifies whether or not the applet can be scripted.
        """
    @property
    def AppletName(self) -> str:
        """
        this is an optional name for the applet.
        """


