# coding: utf-8

"""
    ClickSend v3 API

     This is an official SDK for [ClickSend](https://clicksend.com)  Below you will find a current list of the available methods for clicksend.  *NOTE: You will need to create a free account to use the API. You can register [here](https://dashboard.clicksend.com/#/signup/step1/)..*   # noqa: E501

    OpenAPI spec version: 3.1
    Contact: support@clicksend.com
    Generated by: https://github.com/clicksend-api/clicksend-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from clicksend_client.configuration import Configuration


class PostLetter(object):
    """NOTE: This class is auto generated by the clicksend code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      clicksend_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    clicksend_types = {
        'file_url': 'str',
        'priority_post': 'int',
        'recipients': 'list[PostRecipient]',
        'template_used': 'int',
        'duplex': 'int',
        'colour': 'int',
        'source': 'str'
    }

    attribute_map = {
        'file_url': 'file_url',
        'priority_post': 'priority_post',
        'recipients': 'recipients',
        'template_used': 'template_used',
        'duplex': 'duplex',
        'colour': 'colour',
        'source': 'source'
    }

    discriminator_value_class_map = {
        
    }

    def __init__(self, file_url=None, priority_post=0, recipients=None, template_used=0, duplex=0, colour=0, source='sdk', _configuration=None):  # noqa: E501
        """PostLetter - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._file_url = None
        self._priority_post = None
        self._recipients = None
        self._template_used = None
        self._duplex = None
        self._colour = None
        self._source = None
        self.discriminator = 'classType'

        self.file_url = file_url
        if priority_post is not None:
            self.priority_post = priority_post
        self.recipients = recipients
        if template_used is not None:
            self.template_used = template_used
        if duplex is not None:
            self.duplex = duplex
        if colour is not None:
            self.colour = colour
        if source is not None:
            self.source = source

    @property
    def file_url(self):
        """Gets the file_url of this PostLetter.  # noqa: E501

        URL of file to send  # noqa: E501

        :return: The file_url of this PostLetter.  # noqa: E501
        :rtype: str
        """
        return self._file_url

    @file_url.setter
    def file_url(self, file_url):
        """Sets the file_url of this PostLetter.

        URL of file to send  # noqa: E501

        :param file_url: The file_url of this PostLetter.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and file_url is None:
            raise ValueError("Invalid value for `file_url`, must not be `None`")  # noqa: E501

        self._file_url = file_url

    @property
    def priority_post(self):
        """Gets the priority_post of this PostLetter.  # noqa: E501

        Whether letter is priority  # noqa: E501

        :return: The priority_post of this PostLetter.  # noqa: E501
        :rtype: int
        """
        return self._priority_post

    @priority_post.setter
    def priority_post(self, priority_post):
        """Sets the priority_post of this PostLetter.

        Whether letter is priority  # noqa: E501

        :param priority_post: The priority_post of this PostLetter.  # noqa: E501
        :type: int
        """

        self._priority_post = priority_post

    @property
    def recipients(self):
        """Gets the recipients of this PostLetter.  # noqa: E501

        Array of PostRecipient models  # noqa: E501

        :return: The recipients of this PostLetter.  # noqa: E501
        :rtype: list[PostRecipient]
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """Sets the recipients of this PostLetter.

        Array of PostRecipient models  # noqa: E501

        :param recipients: The recipients of this PostLetter.  # noqa: E501
        :type: list[PostRecipient]
        """
        if self._configuration.client_side_validation and recipients is None:
            raise ValueError("Invalid value for `recipients`, must not be `None`")  # noqa: E501

        self._recipients = recipients

    @property
    def template_used(self):
        """Gets the template_used of this PostLetter.  # noqa: E501

        Whether using our template  # noqa: E501

        :return: The template_used of this PostLetter.  # noqa: E501
        :rtype: int
        """
        return self._template_used

    @template_used.setter
    def template_used(self, template_used):
        """Sets the template_used of this PostLetter.

        Whether using our template  # noqa: E501

        :param template_used: The template_used of this PostLetter.  # noqa: E501
        :type: int
        """

        self._template_used = template_used

    @property
    def duplex(self):
        """Gets the duplex of this PostLetter.  # noqa: E501

        Whether letter is duplex  # noqa: E501

        :return: The duplex of this PostLetter.  # noqa: E501
        :rtype: int
        """
        return self._duplex

    @duplex.setter
    def duplex(self, duplex):
        """Sets the duplex of this PostLetter.

        Whether letter is duplex  # noqa: E501

        :param duplex: The duplex of this PostLetter.  # noqa: E501
        :type: int
        """

        self._duplex = duplex

    @property
    def colour(self):
        """Gets the colour of this PostLetter.  # noqa: E501

        Whether letter is in colour  # noqa: E501

        :return: The colour of this PostLetter.  # noqa: E501
        :rtype: int
        """
        return self._colour

    @colour.setter
    def colour(self, colour):
        """Sets the colour of this PostLetter.

        Whether letter is in colour  # noqa: E501

        :param colour: The colour of this PostLetter.  # noqa: E501
        :type: int
        """

        self._colour = colour

    @property
    def source(self):
        """Gets the source of this PostLetter.  # noqa: E501

        Source being sent from  # noqa: E501

        :return: The source of this PostLetter.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this PostLetter.

        Source being sent from  # noqa: E501

        :param source: The source of this PostLetter.  # noqa: E501
        :type: str
        """

        self._source = source

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.clicksend_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PostLetter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PostLetter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PostLetter):
            return True

        return self.to_dict() != other.to_dict()
