# coding: utf-8

"""
    ClickSend v3 API

     This is an official SDK for [ClickSend](https://clicksend.com)  Below you will find a current list of the available methods for clicksend.  *NOTE: You will need to create a free account to use the API. You can register [here](https://dashboard.clicksend.com/#/signup/step1/)..*   # noqa: E501

    OpenAPI spec version: 3.1
    Contact: support@clicksend.com
    Generated by: https://github.com/clicksend-api/clicksend-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from clicksend_client.configuration import Configuration


class Email(object):
    """NOTE: This class is auto generated by the clicksend code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      clicksend_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    clicksend_types = {
        'to': 'list[EmailRecipient]',
        'cc': 'list[EmailRecipient]',
        'bcc': 'list[EmailRecipient]',
        '_from': 'EmailFrom',
        'subject': 'str',
        'body': 'str',
        'attachments': 'list[Attachment]',
        'schedule': 'float'
    }

    attribute_map = {
        'to': 'to',
        'cc': 'cc',
        'bcc': 'bcc',
        '_from': 'from',
        'subject': 'subject',
        'body': 'body',
        'attachments': 'attachments',
        'schedule': 'schedule'
    }

    discriminator_value_class_map = {
        
    }

    def __init__(self, to=None, cc=None, bcc=None, _from=None, subject=None, body=None, attachments=None, schedule=None, _configuration=None):  # noqa: E501
        """Email - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._to = None
        self._cc = None
        self._bcc = None
        self.__from = None
        self._subject = None
        self._body = None
        self._attachments = None
        self._schedule = None
        self.discriminator = 'classType'

        self.to = to
        if cc is not None:
            self.cc = cc
        if bcc is not None:
            self.bcc = bcc
        self._from = _from
        if subject is not None:
            self.subject = subject
        self.body = body
        if attachments is not None:
            self.attachments = attachments
        if schedule is not None:
            self.schedule = schedule

    @property
    def to(self):
        """Gets the to of this Email.  # noqa: E501

        Array of To Recipient items.  # noqa: E501

        :return: The to of this Email.  # noqa: E501
        :rtype: list[EmailRecipient]
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this Email.

        Array of To Recipient items.  # noqa: E501

        :param to: The to of this Email.  # noqa: E501
        :type: list[EmailRecipient]
        """
        if self._configuration.client_side_validation and to is None:
            raise ValueError("Invalid value for `to`, must not be `None`")  # noqa: E501

        self._to = to

    @property
    def cc(self):
        """Gets the cc of this Email.  # noqa: E501

        Array of Cc Recipient items.  # noqa: E501

        :return: The cc of this Email.  # noqa: E501
        :rtype: list[EmailRecipient]
        """
        return self._cc

    @cc.setter
    def cc(self, cc):
        """Sets the cc of this Email.

        Array of Cc Recipient items.  # noqa: E501

        :param cc: The cc of this Email.  # noqa: E501
        :type: list[EmailRecipient]
        """

        self._cc = cc

    @property
    def bcc(self):
        """Gets the bcc of this Email.  # noqa: E501

        Array of Bcc Recipient items.  # noqa: E501

        :return: The bcc of this Email.  # noqa: E501
        :rtype: list[EmailRecipient]
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc):
        """Sets the bcc of this Email.

        Array of Bcc Recipient items.  # noqa: E501

        :param bcc: The bcc of this Email.  # noqa: E501
        :type: list[EmailRecipient]
        """

        self._bcc = bcc

    @property
    def _from(self):
        """Gets the _from of this Email.  # noqa: E501


        :return: The _from of this Email.  # noqa: E501
        :rtype: EmailFrom
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this Email.


        :param _from: The _from of this Email.  # noqa: E501
        :type: EmailFrom
        """
        if self._configuration.client_side_validation and _from is None:
            raise ValueError("Invalid value for `_from`, must not be `None`")  # noqa: E501

        self.__from = _from

    @property
    def subject(self):
        """Gets the subject of this Email.  # noqa: E501

        Subject of the email.  # noqa: E501

        :return: The subject of this Email.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this Email.

        Subject of the email.  # noqa: E501

        :param subject: The subject of this Email.  # noqa: E501
        :type: str
        """

        self._subject = subject

    @property
    def body(self):
        """Gets the body of this Email.  # noqa: E501

        Body of the email.  # noqa: E501

        :return: The body of this Email.  # noqa: E501
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """Sets the body of this Email.

        Body of the email.  # noqa: E501

        :param body: The body of this Email.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and body is None:
            raise ValueError("Invalid value for `body`, must not be `None`")  # noqa: E501

        self._body = body

    @property
    def attachments(self):
        """Gets the attachments of this Email.  # noqa: E501

        Array of Attachment items.  # noqa: E501

        :return: The attachments of this Email.  # noqa: E501
        :rtype: list[Attachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this Email.

        Array of Attachment items.  # noqa: E501

        :param attachments: The attachments of this Email.  # noqa: E501
        :type: list[Attachment]
        """

        self._attachments = attachments

    @property
    def schedule(self):
        """Gets the schedule of this Email.  # noqa: E501

        Schedule.  # noqa: E501

        :return: The schedule of this Email.  # noqa: E501
        :rtype: float
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this Email.

        Schedule.  # noqa: E501

        :param schedule: The schedule of this Email.  # noqa: E501
        :type: float
        """

        self._schedule = schedule

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.clicksend_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Email, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Email):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Email):
            return True

        return self.to_dict() != other.to_dict()
