# coding: utf-8

"""
    ClickSend v3 API

     This is an official SDK for [ClickSend](https://clicksend.com)  Below you will find a current list of the available methods for clicksend.  *NOTE: You will need to create a free account to use the API. You can register [here](https://dashboard.clicksend.com/#/signup/step1/)..*   # noqa: E501

    OpenAPI spec version: 3.1
    Contact: support@clicksend.com
    Generated by: https://github.com/clicksend-api/clicksend-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from clicksend_client.configuration import Configuration


class CreditCard(object):
    """NOTE: This class is auto generated by the clicksend code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      clicksend_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    clicksend_types = {
        'number': 'str',
        'expiry_month': 'int',
        'expiry_year': 'int',
        'cvc': 'int',
        'name': 'str',
        'bank_name': 'str'
    }

    attribute_map = {
        'number': 'number',
        'expiry_month': 'expiry_month',
        'expiry_year': 'expiry_year',
        'cvc': 'cvc',
        'name': 'name',
        'bank_name': 'bank_name'
    }

    discriminator_value_class_map = {
        
    }

    def __init__(self, number=None, expiry_month=None, expiry_year=None, cvc=None, name=None, bank_name=None, _configuration=None):  # noqa: E501
        """CreditCard - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._number = None
        self._expiry_month = None
        self._expiry_year = None
        self._cvc = None
        self._name = None
        self._bank_name = None
        self.discriminator = 'classType'

        self.number = number
        self.expiry_month = expiry_month
        self.expiry_year = expiry_year
        self.cvc = cvc
        self.name = name
        self.bank_name = bank_name

    @property
    def number(self):
        """Gets the number of this CreditCard.  # noqa: E501

        Credit card number  # noqa: E501

        :return: The number of this CreditCard.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this CreditCard.

        Credit card number  # noqa: E501

        :param number: The number of this CreditCard.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and number is None:
            raise ValueError("Invalid value for `number`, must not be `None`")  # noqa: E501

        self._number = number

    @property
    def expiry_month(self):
        """Gets the expiry_month of this CreditCard.  # noqa: E501

        Expiry month of credit card  # noqa: E501

        :return: The expiry_month of this CreditCard.  # noqa: E501
        :rtype: int
        """
        return self._expiry_month

    @expiry_month.setter
    def expiry_month(self, expiry_month):
        """Sets the expiry_month of this CreditCard.

        Expiry month of credit card  # noqa: E501

        :param expiry_month: The expiry_month of this CreditCard.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and expiry_month is None:
            raise ValueError("Invalid value for `expiry_month`, must not be `None`")  # noqa: E501

        self._expiry_month = expiry_month

    @property
    def expiry_year(self):
        """Gets the expiry_year of this CreditCard.  # noqa: E501

        Expiry year of credit card  # noqa: E501

        :return: The expiry_year of this CreditCard.  # noqa: E501
        :rtype: int
        """
        return self._expiry_year

    @expiry_year.setter
    def expiry_year(self, expiry_year):
        """Sets the expiry_year of this CreditCard.

        Expiry year of credit card  # noqa: E501

        :param expiry_year: The expiry_year of this CreditCard.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and expiry_year is None:
            raise ValueError("Invalid value for `expiry_year`, must not be `None`")  # noqa: E501

        self._expiry_year = expiry_year

    @property
    def cvc(self):
        """Gets the cvc of this CreditCard.  # noqa: E501

        CVC number of credit card  # noqa: E501

        :return: The cvc of this CreditCard.  # noqa: E501
        :rtype: int
        """
        return self._cvc

    @cvc.setter
    def cvc(self, cvc):
        """Sets the cvc of this CreditCard.

        CVC number of credit card  # noqa: E501

        :param cvc: The cvc of this CreditCard.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and cvc is None:
            raise ValueError("Invalid value for `cvc`, must not be `None`")  # noqa: E501

        self._cvc = cvc

    @property
    def name(self):
        """Gets the name of this CreditCard.  # noqa: E501

        Name printed on credit card  # noqa: E501

        :return: The name of this CreditCard.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreditCard.

        Name printed on credit card  # noqa: E501

        :param name: The name of this CreditCard.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def bank_name(self):
        """Gets the bank_name of this CreditCard.  # noqa: E501

        Name of bank that credit card belongs to  # noqa: E501

        :return: The bank_name of this CreditCard.  # noqa: E501
        :rtype: str
        """
        return self._bank_name

    @bank_name.setter
    def bank_name(self, bank_name):
        """Sets the bank_name of this CreditCard.

        Name of bank that credit card belongs to  # noqa: E501

        :param bank_name: The bank_name of this CreditCard.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and bank_name is None:
            raise ValueError("Invalid value for `bank_name`, must not be `None`")  # noqa: E501

        self._bank_name = bank_name

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.clicksend_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreditCard, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreditCard):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreditCard):
            return True

        return self.to_dict() != other.to_dict()
