# coding: utf-8

"""
    ClickSend v3 API

     This is an official SDK for [ClickSend](https://clicksend.com)  Below you will find a current list of the available methods for clicksend.  *NOTE: You will need to create a free account to use the API. You can register [here](https://dashboard.clicksend.com/#/signup/step1/)..*   # noqa: E501

    OpenAPI spec version: 3.1
    Contact: support@clicksend.com
    Generated by: https://github.com/clicksend-api/clicksend-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clicksend_client.api_client import ApiClient


class EmailMarketingApi(object):
    """NOTE: This class is auto generated by the clicksend code generator program.

    Do not edit the class manually.
    Ref: https://github.com/clicksend-api/clicksend-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def allowed_email_address_get(self, **kwargs):  # noqa: E501
        """Get all email addresses  # noqa: E501

        Get all email addresses  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.allowed_email_address_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.allowed_email_address_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.allowed_email_address_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def allowed_email_address_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all email addresses  # noqa: E501

        Get all email addresses  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.allowed_email_address_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method allowed_email_address_get" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('page' in params and params['page'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `allowed_email_address_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `allowed_email_address_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email/addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def allowed_email_address_post(self, **kwargs):  # noqa: E501
        """Create allowed Email Address  # noqa: E501

        Create allowed Email Address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.allowed_email_address_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailAddress email_address:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.allowed_email_address_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.allowed_email_address_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def allowed_email_address_post_with_http_info(self, **kwargs):  # noqa: E501
        """Create allowed Email Address  # noqa: E501

        Create allowed Email Address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.allowed_email_address_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailAddress email_address:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_address']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method allowed_email_address_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_address' in params:
            body_params = params['email_address']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email/addresses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_email_campaign_put(self, email_campaign_id, **kwargs):  # noqa: E501
        """Cancel email campaign  # noqa: E501

        Cancel email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_email_campaign_put(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_email_campaign_put_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_email_campaign_put_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
            return data

    def cancel_email_campaign_put_with_http_info(self, email_campaign_id, **kwargs):  # noqa: E501
        """Cancel email campaign  # noqa: E501

        Cancel email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_email_campaign_put_with_http_info(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_email_campaign_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_campaign_id' is set
        if self.api_client.client_side_validation and ('email_campaign_id' not in params or
                                                       params['email_campaign_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `cancel_email_campaign_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_campaign_id' in params:
            path_params['email_campaign_id'] = params['email_campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns/{email_campaign_id}/cancel', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_campaign_get(self, email_campaign_id, **kwargs):  # noqa: E501
        """Get specific email campaign  # noqa: E501

        Get specific email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_get(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.email_campaign_get_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.email_campaign_get_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
            return data

    def email_campaign_get_with_http_info(self, email_campaign_id, **kwargs):  # noqa: E501
        """Get specific email campaign  # noqa: E501

        Get specific email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_get_with_http_info(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_campaign_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_campaign_id' is set
        if self.api_client.client_side_validation and ('email_campaign_id' not in params or
                                                       params['email_campaign_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `email_campaign_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_campaign_id' in params:
            path_params['email_campaign_id'] = params['email_campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns/{email_campaign_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_campaign_history_export_get(self, email_campaign_id, **kwargs):  # noqa: E501
        """Export specific email campaign history  # noqa: E501

        Export specific email campaign history  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_history_export_get(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :param int date_from: Start date
        :param int date_to: End date
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.email_campaign_history_export_get_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.email_campaign_history_export_get_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
            return data

    def email_campaign_history_export_get_with_http_info(self, email_campaign_id, **kwargs):  # noqa: E501
        """Export specific email campaign history  # noqa: E501

        Export specific email campaign history  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_history_export_get_with_http_info(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :param int date_from: Start date
        :param int date_to: End date
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id', 'date_from', 'date_to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_campaign_history_export_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_campaign_id' is set
        if self.api_client.client_side_validation and ('email_campaign_id' not in params or
                                                       params['email_campaign_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `email_campaign_history_export_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_campaign_id' in params:
            path_params['email_campaign_id'] = params['email_campaign_id']  # noqa: E501

        query_params = []
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns/{email_campaign_id}/history/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_campaign_history_get(self, email_campaign_id, **kwargs):  # noqa: E501
        """Get specific email campaign history  # noqa: E501

        Get specific email campaign history  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_history_get(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :param int date_from: Start date
        :param int date_to: End date
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.email_campaign_history_get_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.email_campaign_history_get_with_http_info(email_campaign_id, **kwargs)  # noqa: E501
            return data

    def email_campaign_history_get_with_http_info(self, email_campaign_id, **kwargs):  # noqa: E501
        """Get specific email campaign history  # noqa: E501

        Get specific email campaign history  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_history_get_with_http_info(email_campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :param int date_from: Start date
        :param int date_to: End date
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id', 'date_from', 'date_to', 'page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_campaign_history_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_campaign_id' is set
        if self.api_client.client_side_validation and ('email_campaign_id' not in params or
                                                       params['email_campaign_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `email_campaign_history_get`")  # noqa: E501

        if self.api_client.client_side_validation and ('page' in params and params['page'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `email_campaign_history_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `email_campaign_history_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'email_campaign_id' in params:
            path_params['email_campaign_id'] = params['email_campaign_id']  # noqa: E501

        query_params = []
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns/{email_campaign_id}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_campaign_post(self, email_campaign, **kwargs):  # noqa: E501
        """Send email campaign  # noqa: E501

        Send email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_post(email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailCampaign email_campaign: Email model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.email_campaign_post_with_http_info(email_campaign, **kwargs)  # noqa: E501
        else:
            (data) = self.email_campaign_post_with_http_info(email_campaign, **kwargs)  # noqa: E501
            return data

    def email_campaign_post_with_http_info(self, email_campaign, **kwargs):  # noqa: E501
        """Send email campaign  # noqa: E501

        Send email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_post_with_http_info(email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailCampaign email_campaign: Email model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_campaign_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_campaign' is set
        if self.api_client.client_side_validation and ('email_campaign' not in params or
                                                       params['email_campaign'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign` when calling `email_campaign_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_campaign' in params:
            body_params = params['email_campaign']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_campaign_price_post(self, email_campaign, **kwargs):  # noqa: E501
        """Calculate email campaign price  # noqa: E501

        Calculate email campaign price  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_price_post(email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailCampaign email_campaign: Email model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.email_campaign_price_post_with_http_info(email_campaign, **kwargs)  # noqa: E501
        else:
            (data) = self.email_campaign_price_post_with_http_info(email_campaign, **kwargs)  # noqa: E501
            return data

    def email_campaign_price_post_with_http_info(self, email_campaign, **kwargs):  # noqa: E501
        """Calculate email campaign price  # noqa: E501

        Calculate email campaign price  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_price_post_with_http_info(email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailCampaign email_campaign: Email model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_campaign_price_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_campaign' is set
        if self.api_client.client_side_validation and ('email_campaign' not in params or
                                                       params['email_campaign'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign` when calling `email_campaign_price_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_campaign' in params:
            body_params = params['email_campaign']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns/price', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_campaign_put(self, email_campaign_id, email_campaign, **kwargs):  # noqa: E501
        """Edit email campaign  # noqa: E501

        Edit email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_put(email_campaign_id, email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :param EmailCampaign email_campaign: Email model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.email_campaign_put_with_http_info(email_campaign_id, email_campaign, **kwargs)  # noqa: E501
        else:
            (data) = self.email_campaign_put_with_http_info(email_campaign_id, email_campaign, **kwargs)  # noqa: E501
            return data

    def email_campaign_put_with_http_info(self, email_campaign_id, email_campaign, **kwargs):  # noqa: E501
        """Edit email campaign  # noqa: E501

        Edit email campaign  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaign_put_with_http_info(email_campaign_id, email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_campaign_id: Allowed email campaign id (required)
        :param EmailCampaign email_campaign: Email model (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id', 'email_campaign']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_campaign_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_campaign_id' is set
        if self.api_client.client_side_validation and ('email_campaign_id' not in params or
                                                       params['email_campaign_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `email_campaign_put`")  # noqa: E501
        # verify the required parameter 'email_campaign' is set
        if self.api_client.client_side_validation and ('email_campaign' not in params or
                                                       params['email_campaign'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_campaign` when calling `email_campaign_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_campaign_id' in params:
            path_params['email_campaign_id'] = params['email_campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_campaign' in params:
            body_params = params['email_campaign']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns/{email_campaign_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_campaigns_get(self, **kwargs):  # noqa: E501
        """Get all email campaigns  # noqa: E501

        Get all email campaigns  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaigns_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.email_campaigns_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.email_campaigns_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def email_campaigns_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all email campaigns  # noqa: E501

        Get all email campaigns  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_campaigns_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number
        :param int limit: Number of records per page
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_campaigns_get" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('page' in params and params['page'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `email_campaigns_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `email_campaigns_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-campaigns', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_verification_token_get(self, email_address_id, **kwargs):  # noqa: E501
        """Send verification token  # noqa: E501

        Send verification token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_verification_token_get(email_address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_verification_token_get_with_http_info(email_address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_verification_token_get_with_http_info(email_address_id, **kwargs)  # noqa: E501
            return data

    def send_verification_token_get_with_http_info(self, email_address_id, **kwargs):  # noqa: E501
        """Send verification token  # noqa: E501

        Send verification token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_verification_token_get_with_http_info(email_address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_verification_token_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_address_id' is set
        if self.api_client.client_side_validation and ('email_address_id' not in params or
                                                       params['email_address_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_address_id` when calling `send_verification_token_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_address_id' in params:
            path_params['email_address_id'] = params['email_address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email/address-verify/{email_address_id}/send', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def specific_allowed_email_address_delete(self, email_address_id, **kwargs):  # noqa: E501
        """Delete specific email address  # noqa: E501

        Delete specific email address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.specific_allowed_email_address_delete(email_address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.specific_allowed_email_address_delete_with_http_info(email_address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.specific_allowed_email_address_delete_with_http_info(email_address_id, **kwargs)  # noqa: E501
            return data

    def specific_allowed_email_address_delete_with_http_info(self, email_address_id, **kwargs):  # noqa: E501
        """Delete specific email address  # noqa: E501

        Delete specific email address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.specific_allowed_email_address_delete_with_http_info(email_address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method specific_allowed_email_address_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_address_id' is set
        if self.api_client.client_side_validation and ('email_address_id' not in params or
                                                       params['email_address_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_address_id` when calling `specific_allowed_email_address_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_address_id' in params:
            path_params['email_address_id'] = params['email_address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email/addresses/{email_address_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def specific_allowed_email_address_get(self, email_address_id, **kwargs):  # noqa: E501
        """Get specific email address  # noqa: E501

        Get specific email address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.specific_allowed_email_address_get(email_address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.specific_allowed_email_address_get_with_http_info(email_address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.specific_allowed_email_address_get_with_http_info(email_address_id, **kwargs)  # noqa: E501
            return data

    def specific_allowed_email_address_get_with_http_info(self, email_address_id, **kwargs):  # noqa: E501
        """Get specific email address  # noqa: E501

        Get specific email address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.specific_allowed_email_address_get_with_http_info(email_address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method specific_allowed_email_address_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_address_id' is set
        if self.api_client.client_side_validation and ('email_address_id' not in params or
                                                       params['email_address_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_address_id` when calling `specific_allowed_email_address_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_address_id' in params:
            path_params['email_address_id'] = params['email_address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email/addresses/{email_address_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_allowed_email_address_get(self, email_address_id, activation_token, **kwargs):  # noqa: E501
        """Verify email address using verification token  # noqa: E501

        Verify email address using verification token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_allowed_email_address_get(email_address_id, activation_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :param str activation_token: Your activation token. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_allowed_email_address_get_with_http_info(email_address_id, activation_token, **kwargs)  # noqa: E501
        else:
            (data) = self.verify_allowed_email_address_get_with_http_info(email_address_id, activation_token, **kwargs)  # noqa: E501
            return data

    def verify_allowed_email_address_get_with_http_info(self, email_address_id, activation_token, **kwargs):  # noqa: E501
        """Verify email address using verification token  # noqa: E501

        Verify email address using verification token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_allowed_email_address_get_with_http_info(email_address_id, activation_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int email_address_id: Allowed email address id (required)
        :param str activation_token: Your activation token. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_address_id', 'activation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_allowed_email_address_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_address_id' is set
        if self.api_client.client_side_validation and ('email_address_id' not in params or
                                                       params['email_address_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email_address_id` when calling `verify_allowed_email_address_get`")  # noqa: E501
        # verify the required parameter 'activation_token' is set
        if self.api_client.client_side_validation and ('activation_token' not in params or
                                                       params['activation_token'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `activation_token` when calling `verify_allowed_email_address_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email_address_id' in params:
            path_params['email_address_id'] = params['email_address_id']  # noqa: E501
        if 'activation_token' in params:
            path_params['activation_token'] = params['activation_token']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email/address-verify/{email_address_id}/verify/{activation_token}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
