import matplotlib
from matplotlib.colors import LinearSegmentedColormap
import numpy as np
import matplotlib.pyplot

custom_colormaps = {}
categories = {}

velocity_colors = (
    # (1.0 , 1.0 , 1.0),
    (0.0, 0.0, 0.3),  # end_val (0.0 , 0.0 , 0.3)
    (0.0274509803922, 0.0549019607843, 0.23137254902),
    (0.0392156862745, 0.0549019607843, 0.250980392157),
    (0.0509803921569, 0.0549019607843, 0.266666666667),
    (0.0627450980392, 0.0549019607843, 0.286274509804),
    (0.0705882352941, 0.0549019607843, 0.298039215686),
    (0.0823529411765, 0.0549019607843, 0.313725490196),
    (0.0901960784314, 0.0549019607843, 0.333333333333),
    (0.0980392156863, 0.0549019607843, 0.349019607843),
    (0.109803921569, 0.0549019607843, 0.364705882353),
    (0.121568627451, 0.0549019607843, 0.38431372549),
    (0.133333333333, 0.0549019607843, 0.4),
    (0.141176470588, 0.0549019607843, 0.41568627451),
    (0.152941176471, 0.0549019607843, 0.43137254902),
    (0.160784313725, 0.0549019607843, 0.447058823529),
    (0.172549019608, 0.0549019607843, 0.466666666667),
    (0.18431372549, 0.0549019607843, 0.482352941176),
    (0.192156862745, 0.0549019607843, 0.498039215686),
    (0.203921568627, 0.0549019607843, 0.513725490196),
    (0.211764705882, 0.0549019607843, 0.529411764706),
    (0.223529411765, 0.0549019607843, 0.549019607843),
    (0.23137254902, 0.0549019607843, 0.564705882353),
    (0.243137254902, 0.0549019607843, 0.580392156863),
    (0.254901960784, 0.0549019607843, 0.596078431373),
    (0.262745098039, 0.0549019607843, 0.611764705882),
    (0.274509803922, 0.0549019607843, 0.627450980392),
    (0.282352941176, 0.0549019607843, 0.647058823529),
    (0.294117647059, 0.0549019607843, 0.662745098039),
    (0.305882352941, 0.0549019607843, 0.682352941176),
    (0.317647058824, 0.0549019607843, 0.698039215686),
    (0.325490196078, 0.0588235294118, 0.713725490196),
    (0.333333333333, 0.0666666666667, 0.729411764706),
    (0.345098039216, 0.105882352941, 0.745098039216),
    (0.352941176471, 0.145098039216, 0.760784313725),
    (0.364705882353, 0.18431372549, 0.780392156863),
    (0.376470588235, 0.219607843137, 0.796078431373),
    (0.388235294118, 0.258823529412, 0.811764705882),
    (0.396078431373, 0.298039215686, 0.827450980392),
    (0.403921568627, 0.337254901961, 0.843137254902),
    (0.41568627451, 0.372549019608, 0.862745098039),
    (0.427450980392, 0.411764705882, 0.878431372549),
    (0.439215686275, 0.450980392157, 0.894117647059),
    (0.447058823529, 0.486274509804, 0.909803921569),
    (0.458823529412, 0.525490196078, 0.925490196078),
    (0.466666666667, 0.564705882353, 0.945098039216),
    (0.474509803922, 0.603921568627, 0.960784313725),
    (0.486274509804, 0.639215686275, 0.976470588235),
    (0.498039215686, 0.678431372549, 0.996078431373),
    (0.482352941176, 0.678431372549, 0.956862745098),
    (0.450980392157, 0.662745098039, 0.898039215686),
    (0.419607843137, 0.647058823529, 0.835294117647),
    (0.388235294118, 0.63137254902, 0.772549019608),
    (0.356862745098, 0.61568627451, 0.713725490196),
    (0.329411764706, 0.6, 0.650980392157),
    (0.298039215686, 0.58431372549, 0.592156862745),
    (0.266666666667, 0.564705882353, 0.529411764706),
    (0.235294117647, 0.549019607843, 0.470588235294),
    (0.207843137255, 0.533333333333, 0.407843137255),
    (0.176470588235, 0.517647058824, 0.345098039216),
    (0.145098039216, 0.501960784314, 0.286274509804),
    (0.113725490196, 0.486274509804, 0.223529411765),
    (0.0823529411765, 0.470588235294, 0.164705882353),
    (0.0549019607843, 0.458823529412, 0.101960784314),
    (0.0235294117647, 0.450980392157, 0.043137254902),
    (0.00392156862745, 0.447058823529, 0.0),
    (0.0, 0.454901960784, 0.0),
    (0.0, 0.462745098039, 0.0),
    (0.0, 0.470588235294, 0.0),
    (0.0, 0.478431372549, 0.0),
    (0.0, 0.486274509804, 0.0),
    (0.0, 0.494117647059, 0.0),
    (0.0, 0.501960784314, 0.0),
    (0.0, 0.509803921569, 0.0),
    (0.0, 0.517647058824, 0.0),
    (0.0, 0.525490196078, 0.0),
    (0.0, 0.533333333333, 0.0),
    (0.0, 0.541176470588, 0.0),
    (0.0, 0.549019607843, 0.0),
    (0.0, 0.556862745098, 0.0),
    (0.0078431372549, 0.564705882353, 0.0078431372549),
    (0.0196078431373, 0.572549019608, 0.0196078431373),
    (0.0352941176471, 0.580392156863, 0.0352941176471),
    (0.0549019607843, 0.58431372549, 0.0549019607843),
    (0.078431372549, 0.588235294118, 0.078431372549),
    (0.109803921569, 0.588235294118, 0.109803921569),
    (0.129411764706, 0.6, 0.129411764706),
    (0.149019607843, 0.619607843137, 0.149019607843),
    (0.16862745098, 0.63137254902, 0.16862745098),
    (0.18431372549, 0.639215686275, 0.18431372549),
    (0.203921568627, 0.647058823529, 0.203921568627),
    (0.223529411765, 0.654901960784, 0.223529411765),
    (0.243137254902, 0.662745098039, 0.243137254902),
    (0.258823529412, 0.670588235294, 0.258823529412),
    (0.278431372549, 0.678431372549, 0.278431372549),
    (0.298039215686, 0.686274509804, 0.298039215686),
    (0.317647058824, 0.694117647059, 0.317647058824),
    (0.337254901961, 0.698039215686, 0.337254901961),
    (0.356862745098, 0.705882352941, 0.356862745098),
    (0.372549019608, 0.713725490196, 0.372549019608),
    (0.388235294118, 0.721568627451, 0.388235294118),
    (0.407843137255, 0.729411764706, 0.407843137255),
    (0.427450980392, 0.733333333333, 0.427450980392),
    (0.447058823529, 0.741176470588, 0.447058823529),
    (0.466666666667, 0.749019607843, 0.466666666667),
    (0.486274509804, 0.756862745098, 0.486274509804),
    (0.505882352941, 0.764705882353, 0.505882352941),
    (0.521568627451, 0.772549019608, 0.521568627451),
    (0.541176470588, 0.780392156863, 0.541176470588),
    (0.560784313725, 0.788235294118, 0.560784313725),
    (0.576470588235, 0.796078431373, 0.576470588235),
    (0.596078431373, 0.803921568627, 0.596078431373),
    (0.61568627451, 0.811764705882, 0.61568627451),
    (0.635294117647, 0.819607843137, 0.635294117647),
    (0.650980392157, 0.827450980392, 0.650980392157),
    (0.670588235294, 0.835294117647, 0.670588235294),
    (0.690196078431, 0.843137254902, 0.690196078431),
    (0.709803921569, 0.850980392157, 0.709803921569),
    (0.729411764706, 0.858823529412, 0.729411764706),
    (0.745098039216, 0.866666666667, 0.745098039216),
    (0.764705882353, 0.870588235294, 0.764705882353),
    (0.78431372549, 0.878431372549, 0.78431372549),
    (0.8, 0.886274509804, 0.8),
    (0.819607843137, 0.894117647059, 0.819607843137),
    (0.839215686275, 0.901960784314, 0.839215686275),
    (0.858823529412, 0.909803921569, 0.858823529412),
    (0.878431372549, 0.917647058824, 0.878431372549),
    (0.83137254902, 0.858823529412, 0.83137254902),
    (0.737254901961, 0.745098039216, 0.737254901961),
    (0.752941176471, 0.749019607843, 0.737254901961),
    (0.874509803922, 0.866666666667, 0.83137254902),
    (0.941176470588, 0.929411764706, 0.858823529412),
    (0.941176470588, 0.921568627451, 0.8),
    (0.941176470588, 0.913725490196, 0.741176470588),
    (0.941176470588, 0.905882352941, 0.686274509804),
    (0.941176470588, 0.898039215686, 0.627450980392),
    (0.941176470588, 0.890196078431, 0.572549019608),
    (0.941176470588, 0.882352941176, 0.513725490196),
    (0.941176470588, 0.878431372549, 0.454901960784),
    (0.941176470588, 0.870588235294, 0.4),
    (0.941176470588, 0.862745098039, 0.341176470588),
    (0.941176470588, 0.854901960784, 0.286274509804),
    (0.941176470588, 0.847058823529, 0.227450980392),
    (0.941176470588, 0.839215686275, 0.16862745098),
    (0.941176470588, 0.83137254902, 0.113725490196),
    (0.941176470588, 0.823529411765, 0.0588235294118),
    (0.941176470588, 0.81568627451, 0.0274509803922),
    (0.941176470588, 0.807843137255, 0.0),
    (0.941176470588, 0.8, 0.00392156862745),
    (0.941176470588, 0.792156862745, 0.0078431372549),
    (0.941176470588, 0.78431372549, 0.0117647058824),
    (0.941176470588, 0.776470588235, 0.0196078431373),
    (0.941176470588, 0.76862745098, 0.0235294117647),
    (0.941176470588, 0.760784313725, 0.0313725490196),
    (0.941176470588, 0.752941176471, 0.0352941176471),
    (0.941176470588, 0.745098039216, 0.0392156862745),
    (0.941176470588, 0.741176470588, 0.043137254902),
    (0.941176470588, 0.733333333333, 0.0509803921569),
    (0.941176470588, 0.725490196078, 0.0549019607843),
    (0.941176470588, 0.717647058824, 0.0588235294118),
    (0.941176470588, 0.709803921569, 0.0666666666667),
    (0.941176470588, 0.701960784314, 0.0705882352941),
    (0.941176470588, 0.694117647059, 0.0745098039216),
    (0.941176470588, 0.686274509804, 0.078431372549),
    (0.937254901961, 0.678431372549, 0.0862745098039),
    (0.925490196078, 0.670588235294, 0.0901960784314),
    (0.917647058824, 0.662745098039, 0.0941176470588),
    (0.905882352941, 0.654901960784, 0.0980392156863),
    (0.898039215686, 0.647058823529, 0.105882352941),
    (0.890196078431, 0.639215686275, 0.109803921569),
    (0.878431372549, 0.63137254902, 0.117647058824),
    (0.862745098039, 0.619607843137, 0.125490196078),
    (0.850980392157, 0.607843137255, 0.129411764706),
    (0.843137254902, 0.6, 0.137254901961),
    (0.83137254902, 0.592156862745, 0.141176470588),
    (0.827450980392, 0.588235294118, 0.145098039216),
    (0.819607843137, 0.580392156863, 0.149019607843),
    (0.807843137255, 0.572549019608, 0.156862745098),
    (0.8, 0.564705882353, 0.160784313725),
    (0.788235294118, 0.556862745098, 0.16862745098),
    (0.780392156863, 0.549019607843, 0.172549019608),
    (0.76862745098, 0.541176470588, 0.176470588235),
    (0.760784313725, 0.533333333333, 0.180392156863),
    (0.749019607843, 0.525490196078, 0.188235294118),
    (0.741176470588, 0.517647058824, 0.192156862745),
    (0.733333333333, 0.509803921569, 0.196078431373),
    (0.725490196078, 0.501960784314, 0.203921568627),
    (0.717647058824, 0.494117647059, 0.207843137255),
    (0.705882352941, 0.486274509804, 0.211764705882),
    (0.698039215686, 0.478431372549, 0.21568627451),
    (0.686274509804, 0.470588235294, 0.223529411765),
    (0.678431372549, 0.462745098039, 0.227450980392),
    (0.670588235294, 0.454901960784, 0.235294117647),
    (0.662745098039, 0.450980392157, 0.239215686275),
    (0.654901960784, 0.443137254902, 0.243137254902),
    (0.643137254902, 0.435294117647, 0.247058823529),
    (0.635294117647, 0.427450980392, 0.250980392157),
    (0.623529411765, 0.419607843137, 0.250980392157),
    (0.61568627451, 0.411764705882, 0.250980392157),
    (0.607843137255, 0.403921568627, 0.250980392157),
    (0.596078431373, 0.396078431373, 0.250980392157),
    (0.588235294118, 0.388235294118, 0.250980392157),
    (0.580392156863, 0.380392156863, 0.250980392157),
    (0.572549019608, 0.372549019608, 0.250980392157),
    (0.560784313725, 0.364705882353, 0.250980392157),
    (0.552941176471, 0.356862745098, 0.250980392157),
    (0.545098039216, 0.349019607843, 0.250980392157),
    (0.533333333333, 0.341176470588, 0.250980392157),
    (0.525490196078, 0.333333333333, 0.250980392157),
    (0.517647058824, 0.325490196078, 0.250980392157),
    (0.509803921569, 0.317647058824, 0.250980392157),
    (0.513725490196, 0.313725490196, 0.254901960784),
    (0.541176470588, 0.313725490196, 0.270588235294),
    (0.56862745098, 0.313725490196, 0.286274509804),
    (0.6, 0.313725490196, 0.301960784314),
    (0.63137254902, 0.313725490196, 0.317647058824),
    (0.662745098039, 0.313725490196, 0.329411764706),
    (0.694117647059, 0.313725490196, 0.345098039216),
    (0.721568627451, 0.313725490196, 0.360784313725),
    (0.752941176471, 0.313725490196, 0.376470588235),
    (0.780392156863, 0.313725490196, 0.392156862745),
    (0.811764705882, 0.313725490196, 0.407843137255),
    (0.839215686275, 0.313725490196, 0.423529411765),
    (0.870588235294, 0.313725490196, 0.439215686275),
    (0.901960784314, 0.313725490196, 0.454901960784),
    (0.933333333333, 0.313725490196, 0.466666666667),
    (0.964705882353, 0.313725490196, 0.482352941176),
    (0.992156862745, 0.313725490196, 0.498039215686),
    (0.992156862745, 0.305882352941, 0.490196078431),
    (0.980392156863, 0.298039215686, 0.474509803922),
    (0.96862745098, 0.286274509804, 0.462745098039),
    (0.956862745098, 0.278431372549, 0.447058823529),
    (0.945098039216, 0.266666666667, 0.435294117647),
    (0.933333333333, 0.254901960784, 0.419607843137),
    (0.921568627451, 0.243137254902, 0.407843137255),
    (0.909803921569, 0.235294117647, 0.392156862745),
    (0.898039215686, 0.227450980392, 0.380392156863),
    (0.886274509804, 0.21568627451, 0.364705882353),
    (0.878431372549, 0.207843137255, 0.349019607843),
    (0.866666666667, 0.196078431373, 0.337254901961),
    (0.854901960784, 0.18431372549, 0.321568627451),
    (0.843137254902, 0.172549019608, 0.309803921569),
    (0.83137254902, 0.164705882353, 0.298039215686),
    (0.81568627451, 0.156862745098, 0.282352941176),
    (0.803921568627, 0.145098039216, 0.270588235294),
    (0.792156862745, 0.133333333333, 0.254901960784),
    (0.780392156863, 0.121568627451, 0.239215686275),
    (0.76862745098, 0.113725490196, 0.227450980392),
    (0.756862745098, 0.101960784314, 0.211764705882),
    (0.745098039216, 0.0941176470588, 0.2),
    (0.737254901961, 0.0862745098039, 0.18431372549),
    (0.725490196078, 0.0745098039216, 0.172549019608),
    (0.713725490196, 0.0627450980392, 0.160784313725),
    (0.701960784314, 0.0509803921569, 0.145098039216),
    (0.690196078431, 0.043137254902, 0.133333333333),
    (0.678431372549, 0.0313725490196, 0.117647058824),
    (0.666666666667, 0.0235294117647, 0.101960784314)
)

carbonne_map = matplotlib.colors.ListedColormap(velocity_colors, "carbonne")
custom_colormaps["carbonne"] = carbonne_map

cloudnet_colors = (
    (1.0, 1.0, 1.0),
    # (0.4 , 0.6 , 0.0), #strange green
    (0.26, 0.75, 0.98),  # light blue
    (1.0, 0.0, 0.0),
    (0.0, 0.0, 1.0),
    (1.0, 1.0, 0.0),
    (0.0, 0.8, 0.0),
    (1.0, 0.5, 0.0),
    (0.0, 0.6, 0.6),
    (0.8, 0.8, 0.8),
    (0.6, 0.6, 0.6),
    (0.4, 0.4, 0.4)
)

cloudnet_map = matplotlib.colors.ListedColormap(cloudnet_colors, "cloudnet_target")
custom_colormaps["cloudnet_target"] = cloudnet_map

categories["cloudnet_target"] = [
    "Clear sky",
    "Cloud droplets only",
    "Drizzle or rain",
    "Drizzle/rain & \ncloud droplets",
    "Ice",
    "Ice & supercooled\ndroplets",
    "Melting ice",
    "Melting ice & \ncloud droplets",
    "Aerosol",
    "Insects",
    "Aerosol & insects"
]

four_colors = np.array([
    [255, 255, 255],
    [180, 55, 87],
    [32, 159, 243],
    [206, 188, 137],
])/255
four_colors = tuple(four_colors)
four_color_map = matplotlib.colors.ListedColormap(four_colors, "four_colors")
custom_colormaps["four_colors"] = four_color_map
categories["four_colors"] = ["no liquid", "both", "ANN only", "Cloudnet only"]


custom_colormaps["four_colors2"] = matplotlib.colors.ListedColormap(four_colors, "four_colors")
categories["four_colors2"] = ["Clear sky", "above linear-1", "between linear-1/2", "below linear-2"]


cloudnet_colors_new = np.array([
    [255, 255, 255],
    [108, 255, 236],
    [32, 159, 243],
    [191, 154, 255],
    [229, 227, 235],
    [70, 74, 185],
    [255, 165, 0],
    [199, 250, 58],
    [206, 188, 137],
    [230, 74, 35],
    [180, 55, 87],
]) / 255.
cloudnet_colors_new = tuple(cloudnet_colors_new)

cloudnet_map_new = matplotlib.colors.ListedColormap(cloudnet_colors_new, "cloudnet_target_new")
custom_colormaps["cloudnet_target_new"] = cloudnet_map_new

categories["cloudnet_target_new"] = [
    "Clear sky",
    "Cloud droplets only",
    "Drizzle or rain",
    "Drizzle/rain & \ncloud droplets",
    "Ice",
    "Ice & supercooled\ndroplets",
    "Melting ice",
    "Melting ice & \ncloud droplets",
    "Aerosol",
    "Insects",
    "Aerosol & \ninsects"
]

categories["cloudnet_target_ice"] = [
    "Clear sky",
    "Cloud droplets only",
    "Drizzle or rain",
    "Drizzle/rain & \ncloud droplets",
    "Ice",
    "Ice & supercooled\ndroplets",
    "Melting ice",
    "Melting ice & \ncloud droplets",
    "Aerosol",
    "Insects",
    "Aerosol & \ninsects",
    "Large ice",
    "Columnar ice",

]
cloudnet_colors_ice = np.array([

    [255, 255, 255],
    [108, 255, 236],
    [32, 159, 243],
    [191, 154, 255],
    [229, 227, 235],
    [70, 74, 185],
    [255, 165, 0],
    [199, 250, 58],
    [206, 188, 137],
    [230, 74, 35],
    [180, 55, 87],
    [70, 70, 70],
    [150, 150, 150],
]) / 255.

cloudnet_colors_ice = tuple(cloudnet_colors_ice)

cloudnet_map_ice = matplotlib.colors.ListedColormap(cloudnet_colors_ice, "cloudnet_target_ice")
custom_colormaps["cloudnet_target_ice"] = cloudnet_map_ice

ann_colors_7class = np.array([
    [255, 255, 255],
    [108, 255, 236],
    [32, 159, 243],
    [191, 154, 255],
    [229, 227, 235],
    [70, 74, 185],
    [255, 165, 0],
    [199, 250, 58],
    [180, 55, 87],
]) / 255.
ann_colors_7class = tuple(ann_colors_7class)

ann_map_7class = matplotlib.colors.ListedColormap(ann_colors_7class, "ann_target_7class")
custom_colormaps["ann_target_7class"] = ann_map_7class

categories["ann_target_7class"] = [
    "Clear sky",
    "Cloud droplets only",
    "Drizzle or rain",
    "Drizzle/rain & \ncloud droplets",
    "Ice",
    "Ice & supercooled\ndroplets",
    "Melting ice",
    "Melting ice & \ncloud droplets",
    "Ground clutter & \ninsects"
]



ann_colors_5class = np.array([
    [255, 255, 255],
    [32, 159, 243],
    [229, 227, 235],
    [70, 74, 185],
    [180, 55, 87],
]) / 255.
ann_colors_5class = tuple(ann_colors_5class)

ann_map_5class = matplotlib.colors.ListedColormap(ann_colors_5class, "ann_target_5class")
custom_colormaps["ann_target_5class"] = ann_map_5class

categories["ann_target_5class"] = [
    "Clear sky",
    "Drizzle or rain",
    "Ice",
    "Ice and/or\ncloud droplets",
    "Other"
]

cloudnet_detection_status = ((1, 1, 1,),
                             (1, 0.9, 0),
                             (0.4, 0.4, 0.4),
                             (0, 0.8, 0),
                             (0.6, 0.6, 0.6),
                             (0.4, 0.8, 1),
                             (0.8, 0.8, 0.8),
                             (0, 0, 1),
                             (1, 0, 0),
                             (1, 0.6, 0))

cloudnet_detection_status = matplotlib.colors.ListedColormap(cloudnet_detection_status, "cloudnet_detection_status")
custom_colormaps["cloudnet_detection_status"] = cloudnet_detection_status
categories["cloudnet_detection_status"] = [
    'Clear sky',
    'Lidar echo only',
    'Radar echo but \nuncorrected atten.',
    'Good radar & \nlidar echos',
    'radar but unknown \nattenuation',
    'Good radar \necho only',
    'No radar but \nknown attenuation',
    'Radar corrected \nfor liquid atten.',
    'Radar ground \nclutter',
    'Lidar molecular \nscattering']

cloudnetpy_detection_status = ((1, 1, 1,),
                               (0.235, 0.701, 0.443),
                               (0.439, 0.921, 0.364),
                               (1, 0.905, 0.266),
                               (0.803, 0.960, 0.964),
                               (0.454, 0.509, 0.411),
                               (0.901, 0.290, 0.137),
                               (0.705, 0.215, 0.341))

cloudnetpy_detection_status = matplotlib.colors.ListedColormap(cloudnetpy_detection_status, "cloudnetpy_detection_status")
custom_colormaps["cloudnetpy_detection_status"] = cloudnetpy_detection_status
categories["cloudnetpy_detection_status"] = [
    'Clear sky',
    'Good radar & \nlidar echos',
    'Good radar \necho only',
    'Lidar echo only',
    'Radar corrected \nfor liquid atten.',
    'Radar uncorrected \nfor liquid atten.',
    'Radar ground clutter',
    'Lidar molecular \nscattering']

pollynet_class_colors = (
    (1.0, 1.0, 1.0),
    (0.9, 0.9, 0.9),
    (0.6, 0.6, 0.6),
    (0.8667, 0.8, 0.47),
    (0.9059, 0.43, 0.18),
    (0.5333, 0.13, 0.0),
    (0.0, 0.0, 0.0),
    (0.4706, 0.11, 0.51),
    (0.2275, 0.54, 0.79),
    (0.7059, 0.87, 0.97),
    (0.0667, 0.47, 0.2),
    (0.5255, 0.73, 0.42)
)

pollynet_class = matplotlib.colors.ListedColormap(pollynet_class_colors, "pollynet_class")
custom_colormaps["pollynet_class"] = pollynet_class

categories["pollynet_class"] = [
    "No signal",
    "Clean atmosphere",
    "Non-typed partic.\nlow conc.",
    "Aerosol: small",
    "Aerosol: large,\nspherical",
    "Aerosol: mixture,\npartly non-spherical",
    "Aerosol: large,\nnon-spherical",
    "Cloud: non-typed",
    "Cloud: water droplets",
    "Cloud: likely\nwater droplets",
    "Cloud: ice crystals",
    "Cloud: likely\nice crystals"
]

cloudnet_jet = (
    (1, 1, 1),
    (0.87451, 0.87451, 0.87451),
    (0.819608, 0.819608, 0.890196),
    (0.819608, 0.819608, 0.890196),
    (0.819608, 0.819608, 0.890196),
    (0.764706, 0.764706, 0.909804),
    (0.764706, 0.764706, 0.909804),
    (0.709804, 0.709804, 0.92549),
    (0.709804, 0.709804, 0.92549),
    (0.709804, 0.709804, 0.92549),
    (0.658824, 0.658824, 0.945098),
    (0.658824, 0.658824, 0.945098),
    (0.603922, 0.603922, 0.960784),
    (0.603922, 0.603922, 0.960784),
    (0.603922, 0.603922, 0.960784),
    (0.54902, 0.54902, 0.980392),
    (0.54902, 0.54902, 0.980392),
    (0.498039, 0.498039, 1.0),
    (0.498039, 0.498039, 1.0),
    (0.498039, 0.498039, 1.0),
    (0.435294, 0.435294, 1.0),
    (0.435294, 0.435294, 1.0),
    (0.372549, 0.372549, 1.0),
    (0.372549, 0.372549, 1.0),
    (0.372549, 0.372549, 1.0),
    (0.309804, 0.309804, 1.0),
    (0.309804, 0.309804, 1.0),
    (0.247059, 0.247059, 1.0),
    (0.247059, 0.247059, 1.0),
    (0.247059, 0.247059, 1.0),
    (0.184314, 0.184314, 1.0),
    (0.184314, 0.184314, 1.0),
    (0.121569, 0.121569, 1.0),
    (0.121569, 0.121569, 1.0),
    (0.121569, 0.121569, 1.0),
    (0.0588235, 0.0588235, 1.0),
    (0.0588235, 0.0588235, 1.0),
    (0.0, 0.0, 1.0),
    (0.0, 0.0, 1.0),
    (0.0, 0.0, 1.0),
    (0.0, 0.0745098, 0.952941),
    (0.0, 0.0745098, 0.952941),
    (0.0, 0.152941, 0.905882),
    (0.0, 0.152941, 0.905882),
    (0.0, 0.152941, 0.905882),
    (0.0, 0.231373, 0.858824),
    (0.0, 0.231373, 0.858824),
    (0.0, 0.309804, 0.811765),
    (0.0, 0.309804, 0.811765),
    (0.0, 0.309804, 0.811765),
    (0.0, 0.388235, 0.764706),
    (0.0, 0.388235, 0.764706),
    (0.0, 0.466667, 0.717647),
    (0.0, 0.466667, 0.717647),
    (0.0, 0.466667, 0.717647),
    (0.0, 0.545098, 0.670588),
    (0.0, 0.545098, 0.670588),
    (0.0, 0.623529, 0.623529),
    (0.0, 0.623529, 0.623529),
    (0.0, 0.623529, 0.623529),
    (0.0, 0.670588, 0.545098),
    (0.0, 0.670588, 0.545098),
    (0.0, 0.717647, 0.466667),
    (0.0, 0.717647, 0.466667),
    (0.0, 0.717647, 0.466667),
    (0.0, 0.764706, 0.388235),
    (0.0, 0.764706, 0.388235),
    (0.0, 0.811765, 0.309804),
    (0.0, 0.811765, 0.309804),
    (0.0, 0.811765, 0.309804),
    (0.0, 0.858824, 0.231373),
    (0.0, 0.858824, 0.231373),
    (0.0, 0.905882, 0.152941),
    (0.0, 0.905882, 0.152941),
    (0.0, 0.905882, 0.152941),
    (0.0, 0.952941, 0.0745098),
    (0.0, 0.952941, 0.0745098),
    (0.0, 1.0, 0.0),
    (0.0, 1.0, 0.0),
    (0.0, 1.0, 0.0),
    (0.121569, 1.0, 0.0),
    (0.121569, 1.0, 0.0),
    (0.247059, 1.0, 0.0),
    (0.247059, 1.0, 0.0),
    (0.247059, 1.0, 0.0),
    (0.372549, 1.0, 0.0),
    (0.372549, 1.0, 0.0),
    (0.498039, 1.0, 0.0),
    (0.498039, 1.0, 0.0),
    (0.498039, 1.0, 0.0),
    (0.623529, 1.0, 0.0),
    (0.623529, 1.0, 0.0),
    (0.74902, 1.0, 0.0),
    (0.74902, 1.0, 0.0),
    (0.74902, 1.0, 0.0),
    (0.87451, 1.0, 0.0),
    (0.87451, 1.0, 0.0),
    (1.0, 1.0, 0.0),
    (1.0, 1.0, 0.0),
    (1.0, 1.0, 0.0),
    (1.0, 0.937255, 0.0),
    (1.0, 0.937255, 0.0),
    (1.0, 0.87451, 0.0),
    (1.0, 0.87451, 0.0),
    (1.0, 0.87451, 0.0),
    (1.0, 0.811765, 0.0),
    (1.0, 0.811765, 0.0),
    (1.0, 0.74902, 0.0),
    (1.0, 0.74902, 0.0),
    (1.0, 0.74902, 0.0),
    (1.0, 0.686275, 0.0),
    (1.0, 0.686275, 0.0),
    (1.0, 0.623529, 0.0),
    (1.0, 0.623529, 0.0),
    (1.0, 0.623529, 0.0),
    (1.0, 0.560784, 0.0),
    (1.0, 0.560784, 0.0),
    (1.0, 0.498039, 0.0),
    (1.0, 0.498039, 0.0),
    (1.0, 0.498039, 0.0),
    (1.0, 0.435294, 0.0),
    (1.0, 0.435294, 0.0),
    (1.0, 0.372549, 0.0),
    (1.0, 0.372549, 0.0),
    (1.0, 0.372549, 0.0),
    (1.0, 0.309804, 0.0),
    (1.0, 0.309804, 0.0),
    (1.0, 0.247059, 0.0),
    (1.0, 0.247059, 0.0),
    (1.0, 0.247059, 0.0),
    (1.0, 0.184314, 0.0),
    (1.0, 0.184314, 0.0),
    (1.0, 0.121569, 0.0),
    (1.0, 0.121569, 0.0),
    (1.0, 0.121569, 0.0),
    (1.0, 0.0588235, 0.0),
    (1.0, 0.0588235, 0.0),
    (1.0, 0.0, 0.0),
    (1.0, 0.0, 0.0),
    (1.0, 0.0, 0.0),
    (0.937255, 0.0, 0.0588235),
    (0.937255, 0.0, 0.0588235),
    (0.87451, 0.0, 0.121569),
    (0.87451, 0.0, 0.121569),
    (0.87451, 0.0, 0.121569),
    (0.811765, 0.0, 0.184314),
    (0.811765, 0.0, 0.184314),
    (0.74902, 0.0, 0.247059),
    (0.74902, 0.0, 0.247059),
    (0.74902, 0.0, 0.247059),
    (0.686275, 0.0, 0.309804),
    (0.686275, 0.0, 0.309804),
    (0.623529, 0.0, 0.372549),
    (0.623529, 0.0, 0.372549),
    (0.623529, 0.0, 0.372549),
    (0.560784, 0.0, 0.435294),
    (0.560784, 0.0, 0.435294),
    (0.498039, 0.0, 0.498039),
    (0.498039, 0.0, 0.498039),
    (0.498039, 0.0, 0.498039)
)
cloudnet_jet_map = matplotlib.colors.ListedColormap(cloudnet_jet, "cloudnet_jet")
custom_colormaps["cloudnet_jet"] = cloudnet_jet_map

# cloudnet_colors2=map(tuple, np.array([
# [223, 223, 223],
# [209, 209, 227],
# [195, 195, 232],
# [181, 181, 236],
# [168, 168, 241],
# [154, 154, 245],
# [140, 140, 250],
# [127, 127, 255],
# [111, 111, 255],
# [95, 95,  255],
# [79, 79,  255],
# [63, 63,  255],
# [47, 47,  255],
# [31, 31,  255],
# [15, 15,  255],
# [0,  0,  255],
# [0, 19,  243],
# [0, 39,  231],
# [0, 59,  219],
# [0, 79,  207],
# [0, 99,  195],
# [0,  119,  183],
# [0,  139,  171],
# [0,  159,  159],
# [0,  171,  139],
# [0,  183,  119],
# [0,  195, 99],
# [0,  207, 79],
# [0,  219, 59],
# [0,  231, 39],
# [0,  243, 19],
# [0,  255,  0],
# [31,  255,  0],
# [63,  255,  0],
# [95,  255,  0],
# [127,  255,  0],
# [159,  255,  0],
# [191,  255,  0],
# [223,  255,  0],
# [255,  255,  0],
# [255,  239,  0],
# [255,  223,  0],
# [255,  207,  0],
# [255,  191,  0],
# [255,  175,  0],
# [255,  159,  0],
# [255,  143,  0],
# [255,  127,  0],
# [255,  111,  0],
# [255, 95,  0],
# [255, 79,  0],
# [255, 63,  0],
# [255, 47,  0],
# [255, 31,  0],
# [255, 15,  0],
# [255,  0,  0],
# [239,  0, 15],
# [223,  0, 31],
# [207,  0, 47],
# [191,  0, 63],
# [175,  0, 79],
# [159,  0, 95],
# [143,  0,  111],
# [127,  0,  127]])/255.0)
#
# cloudnet_map = matplotlib.colors.ListedColormap(cloudnet_colors2, "cloudnet_target2")
# custom_colormaps["cloudnet_target2"] = cloudnet_map


ldr_colors = (
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),

    (0.0, 0.0, 0.3),
    (0.0, 0.0, 0.3),
    (0.0, 0.0, 0.3),
    (0.0, 0.0, 0.3),

    (0.0, 0.7, 1.0),
    (0.0, 0.7, 1.0),
    (0.0, 0.7, 1.0),

    (0.0, 0.9, 0.0),
    (0.0, 0.9, 0.0),
    (0.0, 0.9, 0.0),
    (0.0, 0.9, 0.0),

    (1.0, 0.8, 0.0),
    (1.0, 0.8, 0.0),
    (1.0, 0.8, 0.0),
    (1.0, 0.8, 0.0),

    (1.0, 0.0, 0.0),
    (1.0, 0.0, 0.0),
    (1.0, 0.0, 0.0),
    (1.0, 0.0, 0.0),

    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6),
    (0.6, 0.6, 0.6)
)

ldr_map = matplotlib.colors.ListedColormap(ldr_colors, "LDR")
custom_colormaps["LDR"] = ldr_map

rainbow2_colors = (
    (255, 255, 255),
    (0, 0, 159),
    (0, 0, 175),
    (0, 0, 191),
    (0, 0, 207),
    (0, 0, 223),
    (0, 0, 239),
    (0, 0, 255),
    (0, 15, 255),
    (0, 31, 255),
    (0, 47, 255),
    (0, 63, 255),
    (0, 79, 255),
    (0, 95, 255),
    (0, 111, 255),
    (0, 127, 255),
    (0, 143, 255),
    (0, 159, 255),
    (0, 175, 255),
    (0, 191, 255),
    (0, 207, 255),
    (0, 223, 255),
    (0, 239, 255),
    (0, 255, 255),
    (15, 255, 239),
    (31, 255, 223),
    (47, 255, 207),
    (63, 255, 191),
    (79, 255, 175),
    (95, 255, 159),
    (111, 255, 143),
    (127, 255, 127),
    (143, 255, 111),
    (159, 255, 95),
    (175, 255, 79),
    (191, 255, 63),
    (207, 255, 47),
    (223, 255, 31),
    (239, 255, 15),
    (255, 255, 0),
    (255, 239, 0),
    (255, 223, 0),
    (255, 207, 0),
    (255, 191, 0),
    (255, 175, 0),
    (255, 159, 0),
    (255, 143, 0),
    (255, 127, 0),
    (255, 111, 0),
    (255, 95, 0),
    (255, 79, 0),
    (255, 63, 0),
    (255, 47, 0),
    (255, 31, 0),
    (255, 15, 0),
    (255, 0, 0),
    (239, 0, 0),
    (223, 0, 0),
    (207, 0, 0),
    (191, 0, 0),
    (175, 0, 0),
    (159, 0, 0),
    (143, 0, 0),
    (0, 0, 0)
)

rainbow2_colors = np.array(rainbow2_colors) / 255.0

rainbow2_map = matplotlib.colors.ListedColormap(rainbow2_colors, "rainbow2")
custom_colormaps["rainbow2"] = rainbow2_map

velocity_colors2 = (
    # (1.0 , 1.0 , 1.0),
    (1.0, 1.0, 1.0),  # end_val (0.0 , 0.0 , 0.3)
    (0.0274509803922, 0.0549019607843, 0.23137254902),
    (0.0392156862745, 0.0549019607843, 0.250980392157),
    (0.0509803921569, 0.0549019607843, 0.266666666667),
    (0.0627450980392, 0.0549019607843, 0.286274509804),
    (0.0705882352941, 0.0549019607843, 0.298039215686),
    (0.0823529411765, 0.0549019607843, 0.313725490196),
    (0.0901960784314, 0.0549019607843, 0.333333333333),
    (0.0980392156863, 0.0549019607843, 0.349019607843),
    (0.109803921569, 0.0549019607843, 0.364705882353),
    (0.121568627451, 0.0549019607843, 0.38431372549),
    (0.133333333333, 0.0549019607843, 0.4),
    (0.141176470588, 0.0549019607843, 0.41568627451),
    (0.152941176471, 0.0549019607843, 0.43137254902),
    (0.160784313725, 0.0549019607843, 0.447058823529),
    (0.172549019608, 0.0549019607843, 0.466666666667),
    (0.18431372549, 0.0549019607843, 0.482352941176),
    (0.192156862745, 0.0549019607843, 0.498039215686),
    (0.203921568627, 0.0549019607843, 0.513725490196),
    (0.211764705882, 0.0549019607843, 0.529411764706),
    (0.223529411765, 0.0549019607843, 0.549019607843),
    (0.23137254902, 0.0549019607843, 0.564705882353),
    (0.243137254902, 0.0549019607843, 0.580392156863),
    (0.254901960784, 0.0549019607843, 0.596078431373),
    (0.262745098039, 0.0549019607843, 0.611764705882),
    (0.274509803922, 0.0549019607843, 0.627450980392),
    (0.282352941176, 0.0549019607843, 0.647058823529),
    (0.294117647059, 0.0549019607843, 0.662745098039),
    (0.305882352941, 0.0549019607843, 0.682352941176),
    (0.317647058824, 0.0549019607843, 0.698039215686),
    (0.325490196078, 0.0588235294118, 0.713725490196),
    (0.333333333333, 0.0666666666667, 0.729411764706),
    (0.345098039216, 0.105882352941, 0.745098039216),
    (0.352941176471, 0.145098039216, 0.760784313725),
    (0.364705882353, 0.18431372549, 0.780392156863),
    (0.376470588235, 0.219607843137, 0.796078431373),
    (0.388235294118, 0.258823529412, 0.811764705882),
    (0.396078431373, 0.298039215686, 0.827450980392),
    (0.403921568627, 0.337254901961, 0.843137254902),
    (0.41568627451, 0.372549019608, 0.862745098039),
    (0.427450980392, 0.411764705882, 0.878431372549),
    (0.439215686275, 0.450980392157, 0.894117647059),
    (0.447058823529, 0.486274509804, 0.909803921569),
    (0.458823529412, 0.525490196078, 0.925490196078),
    (0.466666666667, 0.564705882353, 0.945098039216),
    (0.474509803922, 0.603921568627, 0.960784313725),
    (0.486274509804, 0.639215686275, 0.976470588235),
    (0.498039215686, 0.678431372549, 0.996078431373),
    (0.482352941176, 0.678431372549, 0.956862745098),
    (0.450980392157, 0.662745098039, 0.898039215686),
    (0.419607843137, 0.647058823529, 0.835294117647),
    (0.388235294118, 0.63137254902, 0.772549019608),
    (0.356862745098, 0.61568627451, 0.713725490196),
    (0.329411764706, 0.6, 0.650980392157),
    (0.298039215686, 0.58431372549, 0.592156862745),
    (0.266666666667, 0.564705882353, 0.529411764706),
    (0.235294117647, 0.549019607843, 0.470588235294),
    (0.207843137255, 0.533333333333, 0.407843137255),
    (0.176470588235, 0.517647058824, 0.345098039216),
    (0.145098039216, 0.501960784314, 0.286274509804),
    (0.113725490196, 0.486274509804, 0.223529411765),
    (0.0823529411765, 0.470588235294, 0.164705882353),
    (0.0549019607843, 0.458823529412, 0.101960784314),
    (0.0235294117647, 0.450980392157, 0.043137254902),
    (0.00392156862745, 0.447058823529, 0.0),
    (0.0, 0.454901960784, 0.0),
    (0.0, 0.462745098039, 0.0),
    (0.0, 0.470588235294, 0.0),
    (0.0, 0.478431372549, 0.0),
    (0.0, 0.486274509804, 0.0),
    (0.0, 0.494117647059, 0.0),
    (0.0, 0.501960784314, 0.0),
    (0.0, 0.509803921569, 0.0),
    (0.0, 0.517647058824, 0.0),
    (0.0, 0.525490196078, 0.0),
    (0.0, 0.533333333333, 0.0),
    (0.0, 0.541176470588, 0.0),
    (0.0, 0.549019607843, 0.0),
    (0.0, 0.556862745098, 0.0),
    (0.0078431372549, 0.564705882353, 0.0078431372549),
    (0.0196078431373, 0.572549019608, 0.0196078431373),
    (0.0352941176471, 0.580392156863, 0.0352941176471),
    (0.0549019607843, 0.58431372549, 0.0549019607843),
    (0.078431372549, 0.588235294118, 0.078431372549),
    (0.109803921569, 0.588235294118, 0.109803921569),
    (0.129411764706, 0.6, 0.129411764706),
    (0.149019607843, 0.619607843137, 0.149019607843),
    (0.16862745098, 0.63137254902, 0.16862745098),
    (0.18431372549, 0.639215686275, 0.18431372549),
    (0.203921568627, 0.647058823529, 0.203921568627),
    (0.223529411765, 0.654901960784, 0.223529411765),
    (0.243137254902, 0.662745098039, 0.243137254902),
    (0.258823529412, 0.670588235294, 0.258823529412),
    (0.278431372549, 0.678431372549, 0.278431372549),
    (0.298039215686, 0.686274509804, 0.298039215686),
    (0.317647058824, 0.694117647059, 0.317647058824),
    (0.337254901961, 0.698039215686, 0.337254901961),
    (0.356862745098, 0.705882352941, 0.356862745098),
    (0.372549019608, 0.713725490196, 0.372549019608),
    (0.388235294118, 0.721568627451, 0.388235294118),
    (0.407843137255, 0.729411764706, 0.407843137255),
    (0.427450980392, 0.733333333333, 0.427450980392),
    (0.447058823529, 0.741176470588, 0.447058823529),
    (0.466666666667, 0.749019607843, 0.466666666667),
    (0.486274509804, 0.756862745098, 0.486274509804),
    (0.505882352941, 0.764705882353, 0.505882352941),
    (0.521568627451, 0.772549019608, 0.521568627451),
    (0.541176470588, 0.780392156863, 0.541176470588),
    (0.560784313725, 0.788235294118, 0.560784313725),
    (0.576470588235, 0.796078431373, 0.576470588235),
    (0.596078431373, 0.803921568627, 0.596078431373),
    (0.61568627451, 0.811764705882, 0.61568627451),
    (0.635294117647, 0.819607843137, 0.635294117647),
    (0.650980392157, 0.827450980392, 0.650980392157),
    (0.670588235294, 0.835294117647, 0.670588235294),
    (0.690196078431, 0.843137254902, 0.690196078431),
    (0.709803921569, 0.850980392157, 0.709803921569),
    (0.729411764706, 0.858823529412, 0.729411764706),
    (0.745098039216, 0.866666666667, 0.745098039216),
    (0.764705882353, 0.870588235294, 0.764705882353),
    (0.78431372549, 0.878431372549, 0.78431372549),
    (0.8, 0.886274509804, 0.8),
    (0.819607843137, 0.894117647059, 0.819607843137),
    (0.839215686275, 0.901960784314, 0.839215686275),
    (0.858823529412, 0.909803921569, 0.858823529412),
    (0.878431372549, 0.917647058824, 0.878431372549),
    (0.83137254902, 0.858823529412, 0.83137254902),
    (0.737254901961, 0.745098039216, 0.737254901961),
    (0.752941176471, 0.749019607843, 0.737254901961),
    (0.874509803922, 0.866666666667, 0.83137254902),
    (0.941176470588, 0.929411764706, 0.858823529412),
    (0.941176470588, 0.921568627451, 0.8),
    (0.941176470588, 0.913725490196, 0.741176470588),
    (0.941176470588, 0.905882352941, 0.686274509804),
    (0.941176470588, 0.898039215686, 0.627450980392),
    (0.941176470588, 0.890196078431, 0.572549019608),
    (0.941176470588, 0.882352941176, 0.513725490196),
    (0.941176470588, 0.878431372549, 0.454901960784),
    (0.941176470588, 0.870588235294, 0.4),
    (0.941176470588, 0.862745098039, 0.341176470588),
    (0.941176470588, 0.854901960784, 0.286274509804),
    (0.941176470588, 0.847058823529, 0.227450980392),
    (0.941176470588, 0.839215686275, 0.16862745098),
    (0.941176470588, 0.83137254902, 0.113725490196),
    (0.941176470588, 0.823529411765, 0.0588235294118),
    (0.941176470588, 0.81568627451, 0.0274509803922),
    (0.941176470588, 0.807843137255, 0.0),
    (0.941176470588, 0.8, 0.00392156862745),
    (0.941176470588, 0.792156862745, 0.0078431372549),
    (0.941176470588, 0.78431372549, 0.0117647058824),
    (0.941176470588, 0.776470588235, 0.0196078431373),
    (0.941176470588, 0.76862745098, 0.0235294117647),
    (0.941176470588, 0.760784313725, 0.0313725490196),
    (0.941176470588, 0.752941176471, 0.0352941176471),
    (0.941176470588, 0.745098039216, 0.0392156862745),
    (0.941176470588, 0.741176470588, 0.043137254902),
    (0.941176470588, 0.733333333333, 0.0509803921569),
    (0.941176470588, 0.725490196078, 0.0549019607843),
    (0.941176470588, 0.717647058824, 0.0588235294118),
    (0.941176470588, 0.709803921569, 0.0666666666667),
    (0.941176470588, 0.701960784314, 0.0705882352941),
    (0.941176470588, 0.694117647059, 0.0745098039216),
    (0.941176470588, 0.686274509804, 0.078431372549),
    (0.937254901961, 0.678431372549, 0.0862745098039),
    (0.925490196078, 0.670588235294, 0.0901960784314),
    (0.917647058824, 0.662745098039, 0.0941176470588),
    (0.905882352941, 0.654901960784, 0.0980392156863),
    (0.898039215686, 0.647058823529, 0.105882352941),
    (0.890196078431, 0.639215686275, 0.109803921569),
    (0.878431372549, 0.63137254902, 0.117647058824),
    (0.862745098039, 0.619607843137, 0.125490196078),
    (0.850980392157, 0.607843137255, 0.129411764706),
    (0.843137254902, 0.6, 0.137254901961),
    (0.83137254902, 0.592156862745, 0.141176470588),
    (0.827450980392, 0.588235294118, 0.145098039216),
    (0.819607843137, 0.580392156863, 0.149019607843),
    (0.807843137255, 0.572549019608, 0.156862745098),
    (0.8, 0.564705882353, 0.160784313725),
    (0.788235294118, 0.556862745098, 0.16862745098),
    (0.780392156863, 0.549019607843, 0.172549019608),
    (0.76862745098, 0.541176470588, 0.176470588235),
    (0.760784313725, 0.533333333333, 0.180392156863),
    (0.749019607843, 0.525490196078, 0.188235294118),
    (0.741176470588, 0.517647058824, 0.192156862745),
    (0.733333333333, 0.509803921569, 0.196078431373),
    (0.725490196078, 0.501960784314, 0.203921568627),
    (0.717647058824, 0.494117647059, 0.207843137255),
    (0.705882352941, 0.486274509804, 0.211764705882),
    (0.698039215686, 0.478431372549, 0.21568627451),
    (0.686274509804, 0.470588235294, 0.223529411765),
    (0.678431372549, 0.462745098039, 0.227450980392),
    (0.670588235294, 0.454901960784, 0.235294117647),
    (0.662745098039, 0.450980392157, 0.239215686275),
    (0.654901960784, 0.443137254902, 0.243137254902),
    (0.643137254902, 0.435294117647, 0.247058823529),
    (0.635294117647, 0.427450980392, 0.250980392157),
    (0.623529411765, 0.419607843137, 0.250980392157),
    (0.61568627451, 0.411764705882, 0.250980392157),
    (0.607843137255, 0.403921568627, 0.250980392157),
    (0.596078431373, 0.396078431373, 0.250980392157),
    (0.588235294118, 0.388235294118, 0.250980392157),
    (0.580392156863, 0.380392156863, 0.250980392157),
    (0.572549019608, 0.372549019608, 0.250980392157),
    (0.560784313725, 0.364705882353, 0.250980392157),
    (0.552941176471, 0.356862745098, 0.250980392157),
    (0.545098039216, 0.349019607843, 0.250980392157),
    (0.533333333333, 0.341176470588, 0.250980392157),
    (0.525490196078, 0.333333333333, 0.250980392157),
    (0.517647058824, 0.325490196078, 0.250980392157),
    (0.509803921569, 0.317647058824, 0.250980392157),
    (0.513725490196, 0.313725490196, 0.254901960784),
    (0.541176470588, 0.313725490196, 0.270588235294),
    (0.56862745098, 0.313725490196, 0.286274509804),
    (0.6, 0.313725490196, 0.301960784314),
    (0.63137254902, 0.313725490196, 0.317647058824),
    (0.662745098039, 0.313725490196, 0.329411764706),
    (0.694117647059, 0.313725490196, 0.345098039216),
    (0.721568627451, 0.313725490196, 0.360784313725),
    (0.752941176471, 0.313725490196, 0.376470588235),
    (0.780392156863, 0.313725490196, 0.392156862745),
    (0.811764705882, 0.313725490196, 0.407843137255),
    (0.839215686275, 0.313725490196, 0.423529411765),
    (0.870588235294, 0.313725490196, 0.439215686275),
    (0.901960784314, 0.313725490196, 0.454901960784),
    (0.933333333333, 0.313725490196, 0.466666666667),
    (0.964705882353, 0.313725490196, 0.482352941176),
    (0.992156862745, 0.313725490196, 0.498039215686),
    (0.992156862745, 0.305882352941, 0.490196078431),
    (0.980392156863, 0.298039215686, 0.474509803922),
    (0.96862745098, 0.286274509804, 0.462745098039),
    (0.956862745098, 0.278431372549, 0.447058823529),
    (0.945098039216, 0.266666666667, 0.435294117647),
    (0.933333333333, 0.254901960784, 0.419607843137),
    (0.921568627451, 0.243137254902, 0.407843137255),
    (0.909803921569, 0.235294117647, 0.392156862745),
    (0.898039215686, 0.227450980392, 0.380392156863),
    (0.886274509804, 0.21568627451, 0.364705882353),
    (0.878431372549, 0.207843137255, 0.349019607843),
    (0.866666666667, 0.196078431373, 0.337254901961),
    (0.854901960784, 0.18431372549, 0.321568627451),
    (0.843137254902, 0.172549019608, 0.309803921569),
    (0.83137254902, 0.164705882353, 0.298039215686),
    (0.81568627451, 0.156862745098, 0.282352941176),
    (0.803921568627, 0.145098039216, 0.270588235294),
    (0.792156862745, 0.133333333333, 0.254901960784),
    (0.780392156863, 0.121568627451, 0.239215686275),
    (0.76862745098, 0.113725490196, 0.227450980392),
    (0.756862745098, 0.101960784314, 0.211764705882),
    (0.745098039216, 0.0941176470588, 0.2),
    (0.737254901961, 0.0862745098039, 0.18431372549),
    (0.725490196078, 0.0745098039216, 0.172549019608),
    (0.713725490196, 0.0627450980392, 0.160784313725),
    (0.701960784314, 0.0509803921569, 0.145098039216),
    (0.690196078431, 0.043137254902, 0.133333333333),
    (0.678431372549, 0.0313725490196, 0.117647058824),
    (1.0, 1.0, 1.0)
)

carbonne_map2 = matplotlib.colors.ListedColormap(velocity_colors2, "carbonne2")
custom_colormaps["carbonne2"] = carbonne_map2

velocity_colors_down = [
    # (1.0, 1.0, 1.0),
    (0.0, 0.0, 0.3),  # end_val dark blue
    (0.0274509803922, 0.0549019607843, 0.23137254902),
    (0.0392156862745, 0.0549019607843, 0.250980392157),
    (0.0509803921569, 0.0549019607843, 0.266666666667),
    (0.0627450980392, 0.0549019607843, 0.286274509804),
    (0.0705882352941, 0.0549019607843, 0.298039215686),
    (0.0823529411765, 0.0549019607843, 0.313725490196),
    (0.0901960784314, 0.0549019607843, 0.333333333333),
    (0.0980392156863, 0.0549019607843, 0.349019607843),
    (0.109803921569, 0.0549019607843, 0.364705882353),
    (0.121568627451, 0.0549019607843, 0.38431372549),
    (0.133333333333, 0.0549019607843, 0.4),
    (0.141176470588, 0.0549019607843, 0.41568627451),
    (0.152941176471, 0.0549019607843, 0.43137254902),
    (0.160784313725, 0.0549019607843, 0.447058823529),
    (0.172549019608, 0.0549019607843, 0.466666666667),
    (0.18431372549, 0.0549019607843, 0.482352941176),
    (0.192156862745, 0.0549019607843, 0.498039215686),
    (0.203921568627, 0.0549019607843, 0.513725490196),
    (0.211764705882, 0.0549019607843, 0.529411764706),
    (0.223529411765, 0.0549019607843, 0.549019607843),
    (0.23137254902, 0.0549019607843, 0.564705882353),
    (0.243137254902, 0.0549019607843, 0.580392156863),
    (0.254901960784, 0.0549019607843, 0.596078431373),
    (0.262745098039, 0.0549019607843, 0.611764705882),
    (0.274509803922, 0.0549019607843, 0.627450980392),
    (0.282352941176, 0.0549019607843, 0.647058823529),
    (0.294117647059, 0.0549019607843, 0.662745098039),
    (0.305882352941, 0.0549019607843, 0.682352941176),
    (0.317647058824, 0.0549019607843, 0.698039215686),
    (0.325490196078, 0.0588235294118, 0.713725490196),
    (0.333333333333, 0.0666666666667, 0.729411764706),
    (0.345098039216, 0.105882352941, 0.745098039216),
    (0.352941176471, 0.145098039216, 0.760784313725),
    (0.364705882353, 0.18431372549, 0.780392156863),
    (0.376470588235, 0.219607843137, 0.796078431373),
    (0.388235294118, 0.258823529412, 0.811764705882),
    (0.396078431373, 0.298039215686, 0.827450980392),
    (0.403921568627, 0.337254901961, 0.843137254902),
    (0.41568627451, 0.372549019608, 0.862745098039),
    (0.427450980392, 0.411764705882, 0.878431372549),
    (0.439215686275, 0.450980392157, 0.894117647059),
    (0.447058823529, 0.486274509804, 0.909803921569),
    (0.458823529412, 0.525490196078, 0.925490196078),
    (0.466666666667, 0.564705882353, 0.945098039216),
    (0.474509803922, 0.603921568627, 0.960784313725),
    (0.486274509804, 0.639215686275, 0.976470588235),
    (0.498039215686, 0.678431372549, 0.996078431373),
    (0.482352941176, 0.678431372549, 0.956862745098),
    (0.450980392157, 0.662745098039, 0.898039215686),
    (0.419607843137, 0.647058823529, 0.835294117647),
    (0.388235294118, 0.63137254902, 0.772549019608),
    (0.356862745098, 0.61568627451, 0.713725490196),
    (0.329411764706, 0.6, 0.650980392157),
    (0.298039215686, 0.58431372549, 0.592156862745),
    (0.266666666667, 0.564705882353, 0.529411764706),
    (0.235294117647, 0.549019607843, 0.470588235294),
    (0.207843137255, 0.533333333333, 0.407843137255),
    (0.176470588235, 0.517647058824, 0.345098039216),
    (0.145098039216, 0.501960784314, 0.286274509804),
    (0.113725490196, 0.486274509804, 0.223529411765),
    (0.0823529411765, 0.470588235294, 0.164705882353),
    (0.0549019607843, 0.458823529412, 0.101960784314),
    (0.0235294117647, 0.450980392157, 0.043137254902),
    (0.00392156862745, 0.447058823529, 0.0),
    (0.0, 0.454901960784, 0.0),
    (0.0, 0.462745098039, 0.0),
    (0.0, 0.470588235294, 0.0),
    (0.0, 0.478431372549, 0.0),
    (0.0, 0.486274509804, 0.0),
    (0.0, 0.494117647059, 0.0),
    (0.0, 0.501960784314, 0.0),
    (0.0, 0.509803921569, 0.0),
    (0.0, 0.517647058824, 0.0),
    (0.0, 0.525490196078, 0.0),
    (0.0, 0.533333333333, 0.0),
    (0.0, 0.541176470588, 0.0),
    (0.0, 0.549019607843, 0.0),
    (0.0, 0.556862745098, 0.0),
    (0.0078431372549, 0.564705882353, 0.0078431372549),
    (0.0196078431373, 0.572549019608, 0.0196078431373),
    (0.0352941176471, 0.580392156863, 0.0352941176471),
    (0.0549019607843, 0.58431372549, 0.0549019607843),
    (0.078431372549, 0.588235294118, 0.078431372549),
    (0.109803921569, 0.588235294118, 0.109803921569),
    (0.129411764706, 0.6, 0.129411764706),
    (0.149019607843, 0.619607843137, 0.149019607843),
    (0.16862745098, 0.63137254902, 0.16862745098),
    (0.18431372549, 0.639215686275, 0.18431372549),
    (0.203921568627, 0.647058823529, 0.203921568627),
    (0.223529411765, 0.654901960784, 0.223529411765),
    (0.243137254902, 0.662745098039, 0.243137254902),
    (0.258823529412, 0.670588235294, 0.258823529412),
    (0.278431372549, 0.678431372549, 0.278431372549),
    (0.298039215686, 0.686274509804, 0.298039215686),
    (0.317647058824, 0.694117647059, 0.317647058824),
    (0.337254901961, 0.698039215686, 0.337254901961),
    (0.356862745098, 0.705882352941, 0.356862745098),
    (0.372549019608, 0.713725490196, 0.372549019608),
    (0.388235294118, 0.721568627451, 0.388235294118),
    (0.407843137255, 0.729411764706, 0.407843137255),
    (0.427450980392, 0.733333333333, 0.427450980392),
    (0.447058823529, 0.741176470588, 0.447058823529),
    (0.466666666667, 0.749019607843, 0.466666666667),
    (0.486274509804, 0.756862745098, 0.486274509804),
    (0.505882352941, 0.764705882353, 0.505882352941),
    (0.521568627451, 0.772549019608, 0.521568627451),
    (0.541176470588, 0.780392156863, 0.541176470588),
    (0.560784313725, 0.788235294118, 0.560784313725),
    (0.576470588235, 0.796078431373, 0.576470588235),
    (0.596078431373, 0.803921568627, 0.596078431373),
    (0.61568627451, 0.811764705882, 0.61568627451),
    (0.635294117647, 0.819607843137, 0.635294117647),
    (0.650980392157, 0.827450980392, 0.650980392157),
    (0.670588235294, 0.835294117647, 0.670588235294),
    (0.690196078431, 0.843137254902, 0.690196078431),
    (0.709803921569, 0.850980392157, 0.709803921569),
    (0.729411764706, 0.858823529412, 0.729411764706),
    (0.745098039216, 0.866666666667, 0.745098039216),
    (0.764705882353, 0.870588235294, 0.764705882353),
    (0.78431372549, 0.878431372549, 0.78431372549),
    (0.8, 0.886274509804, 0.8),  # light green
    (0.819607843137, 0.894117647059, 0.819607843137),
    (0.839215686275, 0.901960784314, 0.839215686275),
    (0.858823529412, 0.909803921569, 0.858823529412),
    (0.878431372549, 0.917647058824, 0.878431372549),
    (0.83137254902, 0.858823529412, 0.83137254902),
    (0.737254901961, 0.745098039216, 0.737254901961),
    (0.752941176471, 0.749019607843, 0.737254901961)
]

carbonne_map_down = matplotlib.colors.ListedColormap(velocity_colors_down, "carbonne_down")
custom_colormaps["carbonne_down"] = carbonne_map_down
