# coding: utf-8

"""
    DocuSign Rooms API - v2

    An API for an integrator to access the features of DocuSign Rooms  # noqa: E501

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_rooms.client.configuration import Configuration


class User(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'user_id': 'int',
        'email': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'is_locked_out': 'bool',
        'status': 'str',
        'access_level': 'str',
        'default_office_id': 'int',
        'title_id': 'int',
        'role_id': 'int',
        'profile_image_url': 'str',
        'offices': 'list[int]',
        'regions': 'list[int]',
        'permissions': 'ClassicManagerPermissions'
    }

    attribute_map = {
        'user_id': 'userId',
        'email': 'email',
        'first_name': 'firstName',
        'last_name': 'lastName',
        'is_locked_out': 'isLockedOut',
        'status': 'status',
        'access_level': 'accessLevel',
        'default_office_id': 'defaultOfficeId',
        'title_id': 'titleId',
        'role_id': 'roleId',
        'profile_image_url': 'profileImageUrl',
        'offices': 'offices',
        'regions': 'regions',
        'permissions': 'permissions'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """User - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._user_id = None
        self._email = None
        self._first_name = None
        self._last_name = None
        self._is_locked_out = None
        self._status = None
        self._access_level = None
        self._default_office_id = None
        self._title_id = None
        self._role_id = None
        self._profile_image_url = None
        self._offices = None
        self._regions = None
        self._permissions = None
        self.discriminator = None

        setattr(self, "_{}".format('user_id'), kwargs.get('user_id', None))
        setattr(self, "_{}".format('email'), kwargs.get('email', None))
        setattr(self, "_{}".format('first_name'), kwargs.get('first_name', None))
        setattr(self, "_{}".format('last_name'), kwargs.get('last_name', None))
        setattr(self, "_{}".format('is_locked_out'), kwargs.get('is_locked_out', None))
        setattr(self, "_{}".format('status'), kwargs.get('status', None))
        setattr(self, "_{}".format('access_level'), kwargs.get('access_level', None))
        setattr(self, "_{}".format('default_office_id'), kwargs.get('default_office_id', None))
        setattr(self, "_{}".format('title_id'), kwargs.get('title_id', None))
        setattr(self, "_{}".format('role_id'), kwargs.get('role_id', None))
        setattr(self, "_{}".format('profile_image_url'), kwargs.get('profile_image_url', None))
        setattr(self, "_{}".format('offices'), kwargs.get('offices', None))
        setattr(self, "_{}".format('regions'), kwargs.get('regions', None))
        setattr(self, "_{}".format('permissions'), kwargs.get('permissions', None))

    @property
    def user_id(self):
        """Gets the user_id of this User.  # noqa: E501


        :return: The user_id of this User.  # noqa: E501
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this User.


        :param user_id: The user_id of this User.  # noqa: E501
        :type: int
        """

        self._user_id = user_id

    @property
    def email(self):
        """Gets the email of this User.  # noqa: E501


        :return: The email of this User.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this User.


        :param email: The email of this User.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def first_name(self):
        """Gets the first_name of this User.  # noqa: E501


        :return: The first_name of this User.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this User.


        :param first_name: The first_name of this User.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this User.  # noqa: E501


        :return: The last_name of this User.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this User.


        :param last_name: The last_name of this User.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def is_locked_out(self):
        """Gets the is_locked_out of this User.  # noqa: E501


        :return: The is_locked_out of this User.  # noqa: E501
        :rtype: bool
        """
        return self._is_locked_out

    @is_locked_out.setter
    def is_locked_out(self, is_locked_out):
        """Sets the is_locked_out of this User.


        :param is_locked_out: The is_locked_out of this User.  # noqa: E501
        :type: bool
        """

        self._is_locked_out = is_locked_out

    @property
    def status(self):
        """Gets the status of this User.  # noqa: E501


        :return: The status of this User.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this User.


        :param status: The status of this User.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def access_level(self):
        """Gets the access_level of this User.  # noqa: E501


        :return: The access_level of this User.  # noqa: E501
        :rtype: str
        """
        return self._access_level

    @access_level.setter
    def access_level(self, access_level):
        """Sets the access_level of this User.


        :param access_level: The access_level of this User.  # noqa: E501
        :type: str
        """
        allowed_values = ["Contributor", "Office", "Region", "Company", "Admin"]  # noqa: E501
        if (self._configuration.client_side_validation and
                access_level not in allowed_values):
            raise ValueError(
                "Invalid value for `access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(access_level, allowed_values)
            )

        self._access_level = access_level

    @property
    def default_office_id(self):
        """Gets the default_office_id of this User.  # noqa: E501


        :return: The default_office_id of this User.  # noqa: E501
        :rtype: int
        """
        return self._default_office_id

    @default_office_id.setter
    def default_office_id(self, default_office_id):
        """Sets the default_office_id of this User.


        :param default_office_id: The default_office_id of this User.  # noqa: E501
        :type: int
        """

        self._default_office_id = default_office_id

    @property
    def title_id(self):
        """Gets the title_id of this User.  # noqa: E501


        :return: The title_id of this User.  # noqa: E501
        :rtype: int
        """
        return self._title_id

    @title_id.setter
    def title_id(self, title_id):
        """Sets the title_id of this User.


        :param title_id: The title_id of this User.  # noqa: E501
        :type: int
        """

        self._title_id = title_id

    @property
    def role_id(self):
        """Gets the role_id of this User.  # noqa: E501


        :return: The role_id of this User.  # noqa: E501
        :rtype: int
        """
        return self._role_id

    @role_id.setter
    def role_id(self, role_id):
        """Sets the role_id of this User.


        :param role_id: The role_id of this User.  # noqa: E501
        :type: int
        """

        self._role_id = role_id

    @property
    def profile_image_url(self):
        """Gets the profile_image_url of this User.  # noqa: E501


        :return: The profile_image_url of this User.  # noqa: E501
        :rtype: str
        """
        return self._profile_image_url

    @profile_image_url.setter
    def profile_image_url(self, profile_image_url):
        """Sets the profile_image_url of this User.


        :param profile_image_url: The profile_image_url of this User.  # noqa: E501
        :type: str
        """

        self._profile_image_url = profile_image_url

    @property
    def offices(self):
        """Gets the offices of this User.  # noqa: E501


        :return: The offices of this User.  # noqa: E501
        :rtype: list[int]
        """
        return self._offices

    @offices.setter
    def offices(self, offices):
        """Sets the offices of this User.


        :param offices: The offices of this User.  # noqa: E501
        :type: list[int]
        """

        self._offices = offices

    @property
    def regions(self):
        """Gets the regions of this User.  # noqa: E501


        :return: The regions of this User.  # noqa: E501
        :rtype: list[int]
        """
        return self._regions

    @regions.setter
    def regions(self, regions):
        """Sets the regions of this User.


        :param regions: The regions of this User.  # noqa: E501
        :type: list[int]
        """

        self._regions = regions

    @property
    def permissions(self):
        """Gets the permissions of this User.  # noqa: E501


        :return: The permissions of this User.  # noqa: E501
        :rtype: ClassicManagerPermissions
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this User.


        :param permissions: The permissions of this User.  # noqa: E501
        :type: ClassicManagerPermissions
        """

        self._permissions = permissions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(User, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, User):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, User):
            return True

        return self.to_dict() != other.to_dict()
