# Collective Mind meta-framework

[Collective Knowledge concept (CK)](https://arxiv.org/pdf/2011.01149.pdf) 
provides a simple way to unify, manage, connect and reuse any artifacts, scripts, tools and workflows 
on any platform with any software and hardware stack. It is motivated by our 
[tedious experience](https://learning.acm.org/techtalks/reproducibility) 
reproducing research papers on machine learning and systems and validating them in the real world.

Collective Mind workflow automation meta-framework (CM aka CK2) is the 2nd implementation 
of the CK concept being developed by the [open MLCommons taskforce on education and reproducibility](https://github.com/mlcommons/ck/blob/master/docs/mlperf-education-workgroup.md)
to make MLOps and DevOps more interoperable, portable, deterministic and reproducible.

[MLCommons](https://mlcommons.org) uses CM to to modularize ML and AI systems and automate their benchmarking, 
optimization and deployment across diverse and continuously changing software, hardware and data
from the cloud to embedded devices.

[![License](https://img.shields.io/badge/License-Apache%202.0-green)](https://github.com/mlcommons/ck)
[![Python Version](https://img.shields.io/badge/python-3+-blue.svg)](https://github.com/mlcommons/ck)

&copy; 2022 [MLCommons](https://mlcommons.org)<br>

## Documentation

* [Table of contents](https://github.com/mlcommons/ck/blob/master/docs/README.md)

## Maintainers

* [Grigori Fursin](https://cknowledge.io/@gfursin) (OctoML, MLCommons, cTuning foundation)
* [Arjun Suresh](https://www.linkedin.com/in/arjunsuresh) (OctoML, MLCommons)

## Acknowledgments

This project is supported by [MLCommons](https://mlcommons.org), [OctoML](https://octoml.ai) 
and [individual contributors](https://github.com/mlcommons/ck/blob/master/CONTRIBUTING.md).
