#!/usr/bin/python
# -*- coding: utf-8 -*-

__author__ = "Ricardo Ribeiro"
__credits__ = ["Ricardo Ribeiro"]
__license__ = "MIT"
__version__ = "0.0"
__maintainer__ = "Ricardo Ribeiro"
__email__ = "ricardojvr@gmail.com"
__status__ = "Development"

from AnyQt.QtWebEngineWidgets 			import QWebEngineView as QWebView
from AnyQt.QtCore 						import QUrl
from AnyQt.QtWidgets                    import QSizePolicy
from pyforms_gui.controls.control_base 	import ControlBase


class ControlWeb(ControlBase, QWebView):
    def __init__(self, *args, **kwargs):
        QWebView.__init__(self)
        if 'load_finished_event' in kwargs: 
            self.load_finished_event=kwargs['load_finished_event']
        self.loadFinished.connect(self.__load_finished_evt)
        ControlBase.__init__(self, *args, **kwargs)

        
    def init_form(self):
        """
        Load Control and initiate the events
        """
        ControlBase.init_form(self)
        if self._value: QWebView.load(self, QUrl(self._value))
        if self.help: self.form.setToolTip(self.help)

        self.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding);
    ############################################################################
    ############ Properties ####################################################
    ############################################################################

    def __load_finished_evt(self, ok):
        self.load_finished_event(ok)

    def load_finished_event(self,ok):
        pass

    @property
    def value(self): return ControlBase.value.fget(self)

    @value.setter
    def value(self, value):
        ControlBase.value.fset(self, value)
        QWebView.load(self, QUrl(value))

    @property
    def html(self): return None

    @html.setter
    def html(self, value):
        QWebView.setHtml(self, value)

    @property
    def form(self):
        return self
