import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name="ontology_processing",
    version="1.0.2",
    description="Climate Mind ontology processing code.",
    author="ClimateMind",
    author_email="hello@climatemind.org",
    url="https://github.com/ClimateMind/climatemind-ontology-processing",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    package_dir={"": "ontology_processing"},
    packages=setuptools.find_packages(where="ontology_processing"),
    python_requires=">=3.6",
    install_requires=[
        'Brotli',
        'click',
        'cycler',
        'dash',
        'dash-core-components',
        'dash-html-components',
        'dash-renderer',
        'dash-table',
        'decorator',
        'Flask',
        'Flask-Compress',
        'future',
        'itsdangerous',
        'Jinja2',
        'kiwisolver',
        'MarkupSafe',
        'matplotlib',
        'networkx',
        'numpy',
        'Owlready2',
        'pandas',
        'Pillow',
        'plotly',
        'pyparsing',
        'python-dateutil',
        'pytz',
        'retrying',
        'scipy',
        'six',
        'validators',
        'Werkzeug',
    ]
)
