/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.SortingLongCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import picard.cmdline.Option;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;
import picard.sam.markduplicates.util.DiskBasedReadEndsForMarkDuplicatesMap;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesCodec;

public class MarkDuplicates
extends AbstractMarkDuplicatesCommandLineProgram {
    private final Log log = Log.getInstance(MarkDuplicates.class);
    @Option(shortName="MAX_SEQS", doc="This option is obsolete. ReadEnds will always be spilled to disk.")
    public int MAX_SEQUENCES_FOR_DISK_READ_ENDS_MAP = 50000;
    @Option(shortName="MAX_FILE_HANDLES", doc="Maximum number of file handles to keep open when spilling read ends to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_FILE_HANDLES_FOR_READ_ENDS_MAP = 8000;
    @Option(doc="This number, plus the maximum RAM available to the JVM, determine the memory footprint used by some of the sorting collections.  If you are running out of memory, try reducing this number.")
    public double SORTING_COLLECTION_SIZE_RATIO = 0.25;
    private SortingCollection<ReadEndsForMarkDuplicates> pairSort;
    private SortingCollection<ReadEndsForMarkDuplicates> fragSort;
    private SortingLongCollection duplicateIndexes;
    private int numDuplicateIndices = 0;
    private LibraryIdGenerator libraryIdGenerator = null;

    public MarkDuplicates() {
        this.DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.SUM_OF_BASE_QUALITIES;
    }

    public static void main(String[] args) {
        new MarkDuplicates().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFilesAreReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        IOUtil.assertFileIsWritable(this.METRICS_FILE);
        this.reportMemoryStats("Start of doWork");
        this.log.info("Reading input file and constructing read end information.");
        this.buildSortedReadEndLists();
        this.reportMemoryStats("After buildSortedReadEndLists");
        this.generateDuplicateIndexes();
        this.reportMemoryStats("After generateDuplicateIndexes");
        this.log.info("Marking " + this.numDuplicateIndices + " records as duplicates.");
        if (this.READ_NAME_REGEX == null) {
            this.log.warn("Skipped optical duplicate cluster discovery; library size estimation may be inaccurate!");
        } else {
            this.log.info("Found " + this.libraryIdGenerator.getNumberOfOpticalDuplicateClusters() + " optical duplicate clusters.");
        }
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator = this.openInputs();
        SAMFileHeader header = headerAndIterator.header;
        SAMFileHeader outputHeader = header.clone();
        outputHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        for (String comment : this.COMMENT) {
            outputHeader.addComment(comment);
        }
        Map<String, String> chainedPgIds = this.getChainedPgIds(outputHeader);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outputHeader, true, this.OUTPUT);
        long recordInFileIndex = 0L;
        long nextDuplicateIndex = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : -1L;
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Written");
        CloseableIterator<SAMRecord> iterator = headerAndIterator.iterator;
        while (iterator.hasNext()) {
            SAMRecord rec = (SAMRecord)iterator.next();
            if (!rec.isSecondaryOrSupplementary()) {
                String library = LibraryIdGenerator.getLibraryName(header, rec);
                DuplicationMetrics metrics = this.libraryIdGenerator.getMetricsByLibrary(library);
                if (metrics == null) {
                    metrics = new DuplicationMetrics();
                    metrics.LIBRARY = library;
                    this.libraryIdGenerator.addMetricsByLibrary(library, metrics);
                }
                if (rec.getReadUnmappedFlag()) {
                    ++metrics.UNMAPPED_READS;
                } else if (!rec.getReadPairedFlag() || rec.getMateUnmappedFlag()) {
                    ++metrics.UNPAIRED_READS_EXAMINED;
                } else {
                    ++metrics.READ_PAIRS_EXAMINED;
                }
                if (recordInFileIndex == nextDuplicateIndex) {
                    rec.setDuplicateReadFlag(true);
                    if (!rec.getReadPairedFlag() || rec.getMateUnmappedFlag()) {
                        ++metrics.UNPAIRED_READ_DUPLICATES;
                    } else {
                        ++metrics.READ_PAIR_DUPLICATES;
                    }
                    nextDuplicateIndex = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : -1L;
                } else {
                    rec.setDuplicateReadFlag(false);
                }
            }
            ++recordInFileIndex;
            if (this.REMOVE_DUPLICATES && rec.getDuplicateReadFlag()) continue;
            if (this.PROGRAM_RECORD_ID != null) {
                rec.setAttribute(SAMTag.PG.name(), (Object)chainedPgIds.get(rec.getStringAttribute(SAMTag.PG.name())));
            }
            out.addAlignment(rec);
            progress.record(rec);
        }
        iterator.close();
        this.duplicateIndexes.cleanup();
        this.reportMemoryStats("Before output close");
        out.close();
        this.reportMemoryStats("After output close");
        this.finalizeAndWriteMetrics(this.libraryIdGenerator);
        return 0;
    }

    long numOpticalDuplicates() {
        return (long)this.libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap().getSumOfValues();
    }

    private void reportMemoryStats(String stage) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        this.log.info(stage + " freeMemory: " + runtime.freeMemory() + "; totalMemory: " + runtime.totalMemory() + "; maxMemory: " + runtime.maxMemory());
    }

    private void buildSortedReadEndLists() {
        int maxInMemory = (int)((double)Runtime.getRuntime().maxMemory() * this.SORTING_COLLECTION_SIZE_RATIO / 65.0);
        this.log.info("Will retain up to " + maxInMemory + " data points before spilling to disk.");
        this.pairSort = SortingCollection.newInstance(ReadEndsForMarkDuplicates.class, new ReadEndsForMarkDuplicatesCodec(), new ReadEndsMDComparator(), maxInMemory, this.TMP_DIR);
        this.fragSort = SortingCollection.newInstance(ReadEndsForMarkDuplicates.class, new ReadEndsForMarkDuplicatesCodec(), new ReadEndsMDComparator(), maxInMemory, this.TMP_DIR);
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator = this.openInputs();
        SAMFileHeader header = headerAndIterator.header;
        DiskBasedReadEndsForMarkDuplicatesMap tmp = new DiskBasedReadEndsForMarkDuplicatesMap(this.MAX_FILE_HANDLES_FOR_READ_ENDS_MAP);
        long index = 0L;
        ProgressLogger progress = new ProgressLogger(this.log, 1000000, "Read");
        CloseableIterator<SAMRecord> iterator = headerAndIterator.iterator;
        if (null == this.libraryIdGenerator) {
            this.libraryIdGenerator = new LibraryIdGenerator(header);
        }
        while (iterator.hasNext()) {
            SAMRecord rec = (SAMRecord)iterator.next();
            if (this.PROGRAM_RECORD_ID != null) {
                this.pgIdsSeen.add(rec.getStringAttribute(SAMTag.PG.name()));
            }
            if (rec.getReadUnmappedFlag()) {
                if (rec.getReferenceIndex() == -1) {
                    break;
                }
            } else if (!rec.isSecondaryOrSupplementary()) {
                ReadEndsForMarkDuplicates fragmentEnd = this.buildReadEnds(header, index, rec);
                this.fragSort.add(fragmentEnd);
                if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag()) {
                    String key = rec.getAttribute(ReservedTagConstants.READ_GROUP_ID) + ":" + rec.getReadName();
                    ReadEndsForMarkDuplicates pairedEnds = tmp.remove(rec.getReferenceIndex(), key);
                    if (pairedEnds == null) {
                        pairedEnds = this.buildReadEnds(header, index, rec);
                        tmp.put(pairedEnds.read2ReferenceIndex, key, pairedEnds);
                    } else {
                        int sequence = fragmentEnd.read1ReferenceIndex;
                        int coordinate = fragmentEnd.read1Coordinate;
                        pairedEnds.orientationForOpticalDuplicates = rec.getFirstOfPairFlag() ? ReadEnds.getOrientationByte(rec.getReadNegativeStrandFlag(), pairedEnds.orientation == 1) : ReadEnds.getOrientationByte(pairedEnds.orientation == 1, rec.getReadNegativeStrandFlag());
                        if (sequence > pairedEnds.read1ReferenceIndex || sequence == pairedEnds.read1ReferenceIndex && coordinate >= pairedEnds.read1Coordinate) {
                            pairedEnds.read2ReferenceIndex = sequence;
                            pairedEnds.read2Coordinate = coordinate;
                            pairedEnds.read2IndexInFile = index;
                            pairedEnds.orientation = ReadEnds.getOrientationByte(pairedEnds.orientation == 1, rec.getReadNegativeStrandFlag());
                        } else {
                            pairedEnds.read2ReferenceIndex = pairedEnds.read1ReferenceIndex;
                            pairedEnds.read2Coordinate = pairedEnds.read1Coordinate;
                            pairedEnds.read2IndexInFile = pairedEnds.read1IndexInFile;
                            pairedEnds.read1ReferenceIndex = sequence;
                            pairedEnds.read1Coordinate = coordinate;
                            pairedEnds.read1IndexInFile = index;
                            pairedEnds.orientation = ReadEnds.getOrientationByte(rec.getReadNegativeStrandFlag(), pairedEnds.orientation == 1);
                        }
                        pairedEnds.score = (short)(pairedEnds.score + DuplicateScoringStrategy.computeDuplicateScore(rec, this.DUPLICATE_SCORING_STRATEGY));
                        this.pairSort.add(pairedEnds);
                    }
                }
            }
            ++index;
            if (!progress.record(rec)) continue;
            this.log.info("Tracking " + tmp.size() + " as yet unmatched pairs. " + tmp.sizeInRam() + " records in RAM.");
        }
        this.log.info("Read " + index + " records. " + tmp.size() + " pairs never matched.");
        iterator.close();
        this.pairSort.doneAdding();
        this.fragSort.doneAdding();
    }

    private ReadEndsForMarkDuplicates buildReadEnds(SAMFileHeader header, long index, SAMRecord rec) {
        ReadEndsForMarkDuplicates ends = new ReadEndsForMarkDuplicates();
        ends.read1ReferenceIndex = rec.getReferenceIndex();
        ends.read1Coordinate = rec.getReadNegativeStrandFlag() ? rec.getUnclippedEnd() : rec.getUnclippedStart();
        ends.orientation = rec.getReadNegativeStrandFlag() ? (byte)1 : 0;
        ends.read1IndexInFile = index;
        ends.score = DuplicateScoringStrategy.computeDuplicateScore(rec, this.DUPLICATE_SCORING_STRATEGY);
        if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag()) {
            ends.read2ReferenceIndex = rec.getMateReferenceIndex();
        }
        ends.libraryId = this.libraryIdGenerator.getLibraryId(rec);
        if (this.opticalDuplicateFinder.addLocationInformation(rec.getReadName(), ends)) {
            ends.readGroup = 0;
            String rg = (String)rec.getAttribute("RG");
            List<SAMReadGroupRecord> readGroups = header.getReadGroups();
            if (rg != null && readGroups != null) {
                for (SAMReadGroupRecord readGroup : readGroups) {
                    if (readGroup.getReadGroupId().equals(rg)) break;
                    ends.readGroup = (short)(ends.readGroup + 1);
                }
            }
        }
        return ends;
    }

    private void generateDuplicateIndexes() {
        int maxInMemory = (int)Math.min((double)Runtime.getRuntime().maxMemory() * 0.25 / 8.0, 2.147483642E9);
        this.log.info("Will retain up to " + maxInMemory + " duplicate indices before spilling to disk.");
        this.duplicateIndexes = new SortingLongCollection(maxInMemory, this.TMP_DIR.toArray(new File[this.TMP_DIR.size()]));
        ReadEndsForMarkDuplicates firstOfNextChunk = null;
        ArrayList<ReadEndsForMarkDuplicates> nextChunk = new ArrayList<ReadEndsForMarkDuplicates>(200);
        this.log.info("Traversing read pair information and detecting duplicates.");
        for (ReadEndsForMarkDuplicates next : this.pairSort) {
            if (firstOfNextChunk == null) {
                firstOfNextChunk = next;
                nextChunk.add(firstOfNextChunk);
                continue;
            }
            if (this.areComparableForDuplicates(firstOfNextChunk, next, true)) {
                nextChunk.add(next);
                continue;
            }
            if (nextChunk.size() > 1) {
                this.markDuplicatePairs(nextChunk);
            }
            nextChunk.clear();
            nextChunk.add(next);
            firstOfNextChunk = next;
        }
        if (nextChunk.size() > 1) {
            this.markDuplicatePairs(nextChunk);
        }
        this.pairSort.cleanup();
        this.pairSort = null;
        this.log.info("Traversing fragment information and detecting duplicates.");
        boolean containsPairs = false;
        boolean containsFrags = false;
        for (ReadEndsForMarkDuplicates next : this.fragSort) {
            if (firstOfNextChunk != null && this.areComparableForDuplicates(firstOfNextChunk, next, false)) {
                nextChunk.add(next);
                containsPairs = containsPairs || next.isPaired();
                containsFrags = containsFrags || !next.isPaired();
                continue;
            }
            if (nextChunk.size() > 1 && containsFrags) {
                this.markDuplicateFragments(nextChunk, containsPairs);
            }
            nextChunk.clear();
            nextChunk.add(next);
            firstOfNextChunk = next;
            containsPairs = next.isPaired();
            containsFrags = !next.isPaired();
        }
        this.markDuplicateFragments(nextChunk, containsPairs);
        this.fragSort.cleanup();
        this.fragSort = null;
        this.log.info("Sorting list of duplicate records.");
        this.duplicateIndexes.doneAddingStartIteration();
    }

    private boolean areComparableForDuplicates(ReadEndsForMarkDuplicates lhs, ReadEndsForMarkDuplicates rhs, boolean compareRead2) {
        boolean retval;
        boolean bl = retval = lhs.libraryId == rhs.libraryId && lhs.read1ReferenceIndex == rhs.read1ReferenceIndex && lhs.read1Coordinate == rhs.read1Coordinate && lhs.orientation == rhs.orientation;
        if (retval && compareRead2) {
            retval = lhs.read2ReferenceIndex == rhs.read2ReferenceIndex && lhs.read2Coordinate == rhs.read2Coordinate;
        }
        return retval;
    }

    private void addIndexAsDuplicate(long bamIndex) {
        this.duplicateIndexes.add(bamIndex);
        ++this.numDuplicateIndices;
    }

    private void markDuplicatePairs(List<ReadEndsForMarkDuplicates> list) {
        short maxScore = 0;
        ReadEndsForMarkDuplicates best = null;
        for (ReadEndsForMarkDuplicates end : list) {
            if (end.score <= maxScore && best != null) continue;
            maxScore = end.score;
            best = end;
        }
        for (ReadEndsForMarkDuplicates end : list) {
            if (end == best) continue;
            this.addIndexAsDuplicate(end.read1IndexInFile);
            this.addIndexAsDuplicate(end.read2IndexInFile);
        }
        if (this.READ_NAME_REGEX != null) {
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(list, this.opticalDuplicateFinder, this.libraryIdGenerator);
        }
    }

    private void markDuplicateFragments(List<ReadEndsForMarkDuplicates> list, boolean containsPairs) {
        if (containsPairs) {
            for (ReadEndsForMarkDuplicates end : list) {
                if (end.isPaired()) continue;
                this.addIndexAsDuplicate(end.read1IndexInFile);
            }
        } else {
            short maxScore = 0;
            ReadEndsForMarkDuplicates best = null;
            for (ReadEndsForMarkDuplicates end : list) {
                if (end.score <= maxScore && best != null) continue;
                maxScore = end.score;
                best = end;
            }
            for (ReadEndsForMarkDuplicates end : list) {
                if (end == best) continue;
                this.addIndexAsDuplicate(end.read1IndexInFile);
            }
        }
    }

    static class ReadEndsMDComparator
    implements Comparator<ReadEndsForMarkDuplicates> {
        ReadEndsMDComparator() {
        }

        @Override
        public int compare(ReadEndsForMarkDuplicates lhs, ReadEndsForMarkDuplicates rhs) {
            int retval = lhs.libraryId - rhs.libraryId;
            if (retval == 0) {
                retval = lhs.read1ReferenceIndex - rhs.read1ReferenceIndex;
            }
            if (retval == 0) {
                retval = lhs.read1Coordinate - rhs.read1Coordinate;
            }
            if (retval == 0) {
                retval = lhs.orientation - rhs.orientation;
            }
            if (retval == 0) {
                retval = lhs.read2ReferenceIndex - rhs.read2ReferenceIndex;
            }
            if (retval == 0) {
                retval = lhs.read2Coordinate - rhs.read2Coordinate;
            }
            if (retval == 0) {
                retval = (int)(lhs.read1IndexInFile - rhs.read1IndexInFile);
            }
            if (retval == 0) {
                retval = (int)(lhs.read2IndexInFile - rhs.read2IndexInFile);
            }
            return retval;
        }
    }
}

