/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.BinaryBAMIndexWriter;
import htsjdk.samtools.BinningIndexBuilder;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.TextualBAMIndexWriter;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.OutputStream;

public class BAMIndexer {
    private final int numReferences;
    private final BAMIndexWriter outputWriter;
    private int currentReference = 0;
    private final BAMIndexBuilder indexBuilder;

    public BAMIndexer(File output, SAMFileHeader fileHeader) {
        this.numReferences = fileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(fileHeader.getSequenceDictionary());
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, output);
    }

    public BAMIndexer(OutputStream output, SAMFileHeader fileHeader) {
        this.numReferences = fileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(fileHeader.getSequenceDictionary());
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, output);
    }

    public void processAlignment(SAMRecord rec) {
        try {
            int reference = rec.getReferenceIndex();
            if (reference != -1 && reference != this.currentReference) {
                this.advanceToReference(reference);
            }
            this.indexBuilder.processAlignment(rec);
        }
        catch (Exception e) {
            throw new SAMException("Exception creating BAM index for record " + rec, e);
        }
    }

    public void finish() {
        this.advanceToReference(this.numReferences);
        this.outputWriter.writeNoCoordinateRecordCount(this.indexBuilder.getNoCoordinateRecordCount());
        this.outputWriter.close();
    }

    private void advanceToReference(int nextReference) {
        while (this.currentReference < nextReference) {
            BAMIndexContent content = this.indexBuilder.processReference(this.currentReference);
            this.outputWriter.writeReference(content);
            ++this.currentReference;
            if (this.currentReference >= this.numReferences) continue;
            this.indexBuilder.startNewReference();
        }
    }

    public static void createAndWriteIndex(File input, File output, boolean textOutput) {
        CachingBAMFileIndex existingIndex = new CachingBAMFileIndex(input, null);
        int n_ref = existingIndex.getNumberOfReferences();
        BAMIndexWriter outputWriter = textOutput ? new TextualBAMIndexWriter(n_ref, output) : new BinaryBAMIndexWriter(n_ref, output);
        try {
            for (int i = 0; i < n_ref; ++i) {
                outputWriter.writeReference(existingIndex.getQueryResults(i));
            }
            outputWriter.writeNoCoordinateRecordCount(existingIndex.getNoCoordinateCount());
            outputWriter.close();
        }
        catch (Exception e) {
            throw new SAMException("Exception creating BAM index", e);
        }
    }

    public static void createIndex(SAMFileReader reader, File output) {
        BAMIndexer.createIndex(reader, output, null);
    }

    public static void createIndex(SAMFileReader reader, File output, Log log) {
        BAMIndexer indexer = new BAMIndexer(output, reader.getFileHeader());
        reader.enableFileSource(true);
        int totalRecords = 0;
        for (SAMRecord rec : reader) {
            if (++totalRecords % 1000000 == 0 && null != log) {
                log.info(totalRecords + " reads processed ...");
            }
            indexer.processAlignment(rec);
        }
        indexer.finish();
    }

    private class BAMIndexBuilder {
        private final SAMSequenceDictionary sequenceDictionary;
        private BinningIndexBuilder binningIndexBuilder;
        private int currentReference = -1;
        private final BAMIndexMetaData indexStats = new BAMIndexMetaData();

        BAMIndexBuilder(SAMSequenceDictionary sequenceDictionary) {
            this.sequenceDictionary = sequenceDictionary;
            if (!sequenceDictionary.isEmpty()) {
                this.startNewReference();
            }
        }

        public void processAlignment(final SAMRecord rec) {
            this.indexStats.recordMetaData(rec);
            if (rec.getAlignmentStart() == 0) {
                return;
            }
            int reference = rec.getReferenceIndex();
            if (reference != this.currentReference) {
                throw new SAMException("Unexpected reference " + reference + " when constructing index for " + this.currentReference + " for record " + rec);
            }
            this.binningIndexBuilder.processFeature(new BinningIndexBuilder.FeatureToBeIndexed(){

                @Override
                public int getStart() {
                    return rec.getAlignmentStart();
                }

                @Override
                public int getEnd() {
                    return rec.getAlignmentEnd();
                }

                @Override
                public Integer getIndexingBin() {
                    Integer binNumber = rec.getIndexingBin();
                    return binNumber == null ? rec.computeIndexingBin() : binNumber.intValue();
                }

                @Override
                public Chunk getChunk() {
                    SAMFileSource source = rec.getFileSource();
                    if (source == null) {
                        throw new SAMException("No source (virtual file offsets); needed for indexing on BAM Record " + rec);
                    }
                    return ((BAMFileSpan)source.getFilePointer()).getSingleChunk();
                }
            });
        }

        public BAMIndexContent processReference(int reference) {
            if (reference != this.currentReference) {
                throw new SAMException("Unexpected reference " + reference + " when constructing index for " + this.currentReference);
            }
            BinningIndexContent indexContent = this.binningIndexBuilder.generateIndexContent();
            if (indexContent == null) {
                return null;
            }
            return new BAMIndexContent(indexContent.getReferenceSequence(), indexContent.getBins(), this.indexStats, indexContent.getLinearIndex());
        }

        public long getNoCoordinateRecordCount() {
            return this.indexStats.getNoCoordinateRecordCount();
        }

        void startNewReference() {
            ++this.currentReference;
            this.indexStats.newReference();
            this.binningIndexBuilder = new BinningIndexBuilder(this.currentReference, this.sequenceDictionary.getSequence(this.currentReference).getSequenceLength());
        }
    }
}

