// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// SECDED decoder generated by util/design/secded_gen.py

module prim_secded_39_32_dec (
  input        [38:0] data_i,
  output logic [31:0] data_o,
  output logic [6:0] syndrome_o,
  output logic [1:0] err_o
);

  logic single_error;

  // Syndrome calculation
  assign syndrome_o[0] = ^(data_i & 39'h012606BD25);
  assign syndrome_o[1] = ^(data_i & 39'h02DEBA8050);
  assign syndrome_o[2] = ^(data_i & 39'h04413D89AA);
  assign syndrome_o[3] = ^(data_i & 39'h0831234ED1);
  assign syndrome_o[4] = ^(data_i & 39'h10C2C1323B);
  assign syndrome_o[5] = ^(data_i & 39'h202DCC624C);
  assign syndrome_o[6] = ^(data_i & 39'h4098505586);

  // Corrected output calculation
  assign data_o[0] = (syndrome_o == 7'h19) ^ data_i[0];
  assign data_o[1] = (syndrome_o == 7'h54) ^ data_i[1];
  assign data_o[2] = (syndrome_o == 7'h61) ^ data_i[2];
  assign data_o[3] = (syndrome_o == 7'h34) ^ data_i[3];
  assign data_o[4] = (syndrome_o == 7'h1a) ^ data_i[4];
  assign data_o[5] = (syndrome_o == 7'h15) ^ data_i[5];
  assign data_o[6] = (syndrome_o == 7'h2a) ^ data_i[6];
  assign data_o[7] = (syndrome_o == 7'h4c) ^ data_i[7];
  assign data_o[8] = (syndrome_o == 7'h45) ^ data_i[8];
  assign data_o[9] = (syndrome_o == 7'h38) ^ data_i[9];
  assign data_o[10] = (syndrome_o == 7'h49) ^ data_i[10];
  assign data_o[11] = (syndrome_o == 7'hd) ^ data_i[11];
  assign data_o[12] = (syndrome_o == 7'h51) ^ data_i[12];
  assign data_o[13] = (syndrome_o == 7'h31) ^ data_i[13];
  assign data_o[14] = (syndrome_o == 7'h68) ^ data_i[14];
  assign data_o[15] = (syndrome_o == 7'h7) ^ data_i[15];
  assign data_o[16] = (syndrome_o == 7'h1c) ^ data_i[16];
  assign data_o[17] = (syndrome_o == 7'hb) ^ data_i[17];
  assign data_o[18] = (syndrome_o == 7'h25) ^ data_i[18];
  assign data_o[19] = (syndrome_o == 7'h26) ^ data_i[19];
  assign data_o[20] = (syndrome_o == 7'h46) ^ data_i[20];
  assign data_o[21] = (syndrome_o == 7'he) ^ data_i[21];
  assign data_o[22] = (syndrome_o == 7'h70) ^ data_i[22];
  assign data_o[23] = (syndrome_o == 7'h32) ^ data_i[23];
  assign data_o[24] = (syndrome_o == 7'h2c) ^ data_i[24];
  assign data_o[25] = (syndrome_o == 7'h13) ^ data_i[25];
  assign data_o[26] = (syndrome_o == 7'h23) ^ data_i[26];
  assign data_o[27] = (syndrome_o == 7'h62) ^ data_i[27];
  assign data_o[28] = (syndrome_o == 7'h4a) ^ data_i[28];
  assign data_o[29] = (syndrome_o == 7'h29) ^ data_i[29];
  assign data_o[30] = (syndrome_o == 7'h16) ^ data_i[30];
  assign data_o[31] = (syndrome_o == 7'h52) ^ data_i[31];

  // err_o calc. bit0: single error, bit1: double error
  assign single_error = ^syndrome_o;
  assign err_o[0] = single_error;
  assign err_o[1] = ~single_error & (|syndrome_o);

endmodule : prim_secded_39_32_dec
