# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.ucb
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_remote_content_provider_acceptor import XRemoteContentProviderAcceptor as XRemoteContentProviderAcceptor_af1b125d

class XRemoteContentProviderConnectionControl(XInterface_8f010a43):
    """
    A simple mechanism to find out if the connection between a remote content provider distributor and acceptor gets lost.
    
    This interface should be supported by the DoneListener parameter of XRemoteContentProviderAcceptor.addRemoteContentProvider().

    See Also:
        `API XRemoteContentProviderConnectionControl <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1ucb_1_1XRemoteContentProviderConnectionControl.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.ucb.XRemoteContentProviderConnectionControl']

    def enableConnectionControl(self, Acceptor: 'XRemoteContentProviderAcceptor_af1b125d', Token: 'XInterface_8f010a43') -> None:
        """
        Enable connection control, using as a token some object implemented on the remote content provider acceptor's side.
        
        The implementation of this interface must hold a reference to the supplied token. If the connection gets lost, the reference count of the token will drop, which the remote content provider acceptor can observe.
        """

