# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.drawing
import typing
from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa
from ..beans.x_tolerant_multi_property_set import XTolerantMultiPropertySet as XTolerantMultiPropertySet_7bd4114e
from .x_glue_points_supplier import XGluePointsSupplier as XGluePointsSupplier_3a770faa
from .x_shape import XShape as XShape_8fd00a3d
from ..lang.x_component import XComponent as XComponent_98dc0ab5
if typing.TYPE_CHECKING:
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
    from ..container.x_name_container import XNameContainer as XNameContainer_cb90e47
    from .homogen_matrix3 import HomogenMatrix3 as HomogenMatrix3_f0fb0d69
    from ..style.x_style import XStyle as XStyle_7c7f09a2

class Shape(XPropertySet_bc180bfa, XTolerantMultiPropertySet_7bd4114e, XGluePointsSupplier_3a770faa, XShape_8fd00a3d, XComponent_98dc0ab5):
    """
    Service Class

    This abstract service specifies the general characteristics of all Shapes.
    
    **since**
    
        LibreOffice 4.2

    See Also:
        `API Shape <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1drawing_1_1Shape.html>`_
    """
    @property
    def InteropGrabBag(self) -> 'typing.Tuple[PropertyValue_c9610c73, ...]':
        """
        Grab bag of shape properties, used as a string-any map for interim interop purposes.
        
        This property is intentionally not handled by the ODF filter. Any member that should be handled there should be first moved out from this grab bag to a separate property.
        
        **since**
        
            LibreOffice 4.2
        """
    @property
    def Hyperlink(self) -> str:
        """
        this property lets you get and set a hyperlink for this shape.
        """
    @property
    def LayerID(self) -> int:
        """
        This is the ID of the Layer to which this Shape is attached.
        """
    @property
    def LayerName(self) -> str:
        """
        This is the name of the Layer to which this Shape is attached.
        """
    @property
    def MoveProtect(self) -> bool:
        """
        With this set to TRUE, this Shape cannot be moved interactively in the user interface.
        """
    @property
    def Name(self) -> str:
        """
        This is the name of this Shape.
        """
    @property
    def NavigationOrder(self) -> int:
        """
        this property stores the navigation order of this shape.
        
        If this value is negative, the navigation order for this shapes page is equal to the z-order.
        """
    @property
    def Printable(self) -> bool:
        """
        If this is FALSE, the Shape is not visible on printer outputs.
        """
    @property
    def RelativeHeight(self) -> int:
        """
        contains the relative height of the object.
        
        It is only valid if it is greater than zero.
        
        **since**
        
            LibreOffice 4.3
        """
    @property
    def RelativeHeightRelation(self) -> int:
        """
        contains the relation of the relative height of the object.
        
        It is only valid if RelativeHeight is greater than zero.
        
        **since**
        
            LibreOffice 4.3
        """
    @property
    def RelativeWidth(self) -> int:
        """
        contains the relative width of the object.
        
        It is only valid if it is greater than zero.
        
        **since**
        
            LibreOffice 4.3
        """
    @property
    def RelativeWidthRelation(self) -> int:
        """
        contains the relation of the relative width of the object.
        
        It is only valid if RelativeWidth is greater than zero.
        
        **since**
        
            LibreOffice 4.3
        """
    @property
    def ShapeUserDefinedAttributes(self) -> 'XNameContainer_cb90e47':
        """
        this property stores xml attributes.
        
        They will be saved to and restored from automatic styles inside xml files.
        """
    @property
    def SizeProtect(self) -> bool:
        """
        With this set to TRUE, this Shape may not be sized interactively in the user interface.
        """
    @property
    def Style(self) -> 'XStyle_7c7f09a2':
        """
        this property lets you get and set a style for this shape.
        """
    @property
    def Transformation(self) -> 'HomogenMatrix3_f0fb0d69':
        """
        this property lets you get and set the transformation matrix for this shape.
        
        The transformation is a 3x3 homogeneous matrix and can contain translation, rotation, shearing and scaling.
        """
    @property
    def Visible(self) -> bool:
        """
        If this is FALSE, the Shape is not visible on screen outputs.
        
        Please note that the Shape may still be visible when printed, see Printable.
        """
    @property
    def ZOrder(self) -> int:
        """
        is used to query or change the ZOrder of this Shape.
        """


