; Script generated by the Inno Script Studio Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
#include <idp.iss>

#define MyAppName "QuantAn"
#define MyAppVersion "1.0.0"
#define MyAppPublisher "University of West Bohemia, NTIS"
#define MyAppURL "http://mjirik.github.io/quantan/"

[Files]
;Source: "{tmp}\Miniconda-latest-Windows-x86_64.exe"; DestDir: "{app}"; Flags: external; ExternalSize: 22743040
Source: "quantan\icon\icon.ico"; DestDir: "{app}"
;Source: "..\..\Downloads\Miniconda-latest-Windows-x86_64.exe"; DestDir: "{tmp}"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{08C90394-34FC-432B-9AF0-D7E48F337DFC}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\{#MyAppName}
;DefaultDirName={%HOMEPATH}\{#MyAppName}
;DefaultDirName={userpf}\{#MyAppName}
DefaultGroupName={#MyAppName}
OutputBaseFilename=setup_quantan
Compression=lzma
SolidCompression=yes
;PrivilegesRequired=lowest
UsePreviousSetupType=False
UsePreviousTasks=False
UsePreviousLanguage=False
ExtraDiskSpaceRequired=43
SetupIconFile=quantan\icon\icon.ico
UsePreviousAppDir=False
UsePreviousGroup=False

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "czech"; MessagesFile: "compiler:Languages\Czech.isl"

[Run]
; Filename: "{tmp}\Miniconda-latest-Windows-x86_64.exe"; Parameters: "/AddToPath=1 /RegisterPython=1 /D={%HOMEPATH}\Minicoconda2"; Flags: waituntilterminated runasoriginaluser
Filename: "{tmp}\Miniconda-latest-Windows-x86_64.exe"; Parameters: "/AddToPath=1 /RegisterPython=1 /InstallationType=AllUsers"; Flags: waituntilterminated runasoriginaluser; Check: IsCondaInstalled
; Filename: "{cmd}"; Parameters: "/C ""pause"""

; instalace je rozdelena pro pripad, ze by jiz prostredi quantan existovalo, pak by doslo k selhani
Filename: "{cmd}"; Parameters: "/C ""set PATH=%PATH%;%HOMEPATH%\Miniconda2;%HOMEPATH%\Miniconda2\Scripts;C:\Miniconda2\Scripts;C:\Miniconda2 & conda create -y -c SimpleITK -c mjirik -n quantan quantan"""; Flags: runasoriginaluser waituntilidle
; Filename: "{cmd}"; Parameters: "/C ""set PATH=%PATH%;%HOMEPATH%\Miniconda2;%HOMEPATH%\Miniconda2\Scripts;C:\Miniconda2\Scripts;C:\Miniconda2 & conda install -y -c SimpleITK -c mjirik quantan"""; Flags: runasoriginaluser waituntilidle
; Filename: "{cmd}"; Parameters: "/C ""pause"""

;if IsCondaInstalled then

[Code]
function IsCondaInstalled: boolean;
var
  ResultCode: Integer;
begin
//result := not FileExists('c:\Miniconda2\Scripts\conda.exe');
result := not (FileExists('c:\Miniconda2\Scripts\conda.exe') or FileExists('{%HOMEPATH}\Miniconda2\Scripts\conda.exe') or FileExists('c:\Anaconda2\Scripts\conda.exe') or FileExists('c:\Miniconda\Scripts\conda.exe') or FileExists('c:\Anaconda\Scripts\conda.exe') or FileExists('{%HOMEPATH}\Miniconda2\Scripts\conda.exe') or FileExists('{%HOMEPATH}\Miniconda\Scripts\conda.exe') or FileExists('{%HOMEPATH}\Anaconda2\Scripts\conda.exe') or FileExists('{%HOMEPATH}\Anaconda\Scripts\conda.exe'));

end;

procedure InitializeWizard();
begin
  if IsCondaInstalled then
    idpAddFileSize('https://repo.continuum.io/miniconda/Miniconda-latest-Windows-x86_64.exe', ExpandConstant('{tmp}\Miniconda-latest-Windows-x86_64.exe'), 22743040);
  idpDownloadAfter(wpReady);
end;

[Icons]
Name: "{group}\QuantAn"; Filename: "{cmd}"; WorkingDir: "{userdocs}"; Flags: runminimized; IconFilename: "{app}\icon.ico"; IconIndex: 0; Parameters: "/C ""call activate quantan & python -m quantan"""
Name: "{commondesktop}\QuantAn"; Filename: "{cmd}"; WorkingDir: "{commondocs}"; Flags: runminimized; IconFilename: "{app}\icon.ico"; IconIndex: 0; Parameters: "/C ""call activate quantan & python -m quantan"""