import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Config::AggregationAuthorization`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html
 */
export interface CfnAggregationAuthorizationProps {
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedaccountid
     */
    readonly authorizedAccountId: string;
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAwsRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedawsregion
     */
    readonly authorizedAwsRegion: string;
    /**
     * `AWS::Config::AggregationAuthorization.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Config::AggregationAuthorization`.
 *
 * @external
 * @cloudformationResource AWS::Config::AggregationAuthorization
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html
 */
export declare class CfnAggregationAuthorization extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::AggregationAuthorization";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAggregationAuthorization;
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedaccountid
     */
    authorizedAccountId: string;
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAwsRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedawsregion
     */
    authorizedAwsRegion: string;
    /**
     * `AWS::Config::AggregationAuthorization.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Config::AggregationAuthorization`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAggregationAuthorizationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Config::ConfigRule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 */
export interface CfnConfigRuleProps {
    /**
     * `AWS::Config::ConfigRule.Source`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-source
     */
    readonly source: CfnConfigRule.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigRule.ConfigRuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-configrulename
     */
    readonly configRuleName?: string;
    /**
     * `AWS::Config::ConfigRule.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-description
     */
    readonly description?: string;
    /**
     * `AWS::Config::ConfigRule.InputParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-inputparameters
     */
    readonly inputParameters?: any | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigRule.MaximumExecutionFrequency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-maximumexecutionfrequency
     */
    readonly maximumExecutionFrequency?: string;
    /**
     * `AWS::Config::ConfigRule.Scope`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-scope
     */
    readonly scope?: CfnConfigRule.ScopeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 */
export declare class CfnConfigRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigRule;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Compliance.Type
     */
    readonly attrComplianceType: string;
    /**
     * @external
     * @cloudformationAttribute ConfigRuleId
     */
    readonly attrConfigRuleId: string;
    /**
     * `AWS::Config::ConfigRule.Source`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-source
     */
    source: CfnConfigRule.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigRule.ConfigRuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-configrulename
     */
    configRuleName: string | undefined;
    /**
     * `AWS::Config::ConfigRule.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-description
     */
    description: string | undefined;
    /**
     * `AWS::Config::ConfigRule.InputParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-inputparameters
     */
    inputParameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConfigRule.MaximumExecutionFrequency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-maximumexecutionfrequency
     */
    maximumExecutionFrequency: string | undefined;
    /**
     * `AWS::Config::ConfigRule.Scope`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-scope
     */
    scope: CfnConfigRule.ScopeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Config::ConfigRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 */
export declare namespace CfnConfigRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html
     */
    interface ScopeProperty {
        /**
         * `CfnConfigRule.ScopeProperty.ComplianceResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-complianceresourceid
         */
        readonly complianceResourceId?: string;
        /**
         * `CfnConfigRule.ScopeProperty.ComplianceResourceTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-complianceresourcetypes
         */
        readonly complianceResourceTypes?: string[];
        /**
         * `CfnConfigRule.ScopeProperty.TagKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-tagkey
         */
        readonly tagKey?: string;
        /**
         * `CfnConfigRule.ScopeProperty.TagValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-tagvalue
         */
        readonly tagValue?: string;
    }
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 */
export declare namespace CfnConfigRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html
     */
    interface SourceProperty {
        /**
         * `CfnConfigRule.SourceProperty.Owner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html#cfn-config-configrule-source-owner
         */
        readonly owner: string;
        /**
         * `CfnConfigRule.SourceProperty.SourceDetails`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html#cfn-config-configrule-source-sourcedetails
         */
        readonly sourceDetails?: Array<CfnConfigRule.SourceDetailProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnConfigRule.SourceProperty.SourceIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html#cfn-config-configrule-source-sourceidentifier
         */
        readonly sourceIdentifier: string;
    }
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 */
export declare namespace CfnConfigRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html
     */
    interface SourceDetailProperty {
        /**
         * `CfnConfigRule.SourceDetailProperty.EventSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html#cfn-config-configrule-source-sourcedetail-eventsource
         */
        readonly eventSource: string;
        /**
         * `CfnConfigRule.SourceDetailProperty.MaximumExecutionFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html#cfn-config-configrule-sourcedetail-maximumexecutionfrequency
         */
        readonly maximumExecutionFrequency?: string;
        /**
         * `CfnConfigRule.SourceDetailProperty.MessageType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html#cfn-config-configrule-source-sourcedetail-messagetype
         */
        readonly messageType: string;
    }
}
/**
 * Properties for defining a `AWS::Config::ConfigurationAggregator`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 */
export interface CfnConfigurationAggregatorProps {
    /**
     * `AWS::Config::ConfigurationAggregator.ConfigurationAggregatorName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-configurationaggregatorname
     */
    readonly configurationAggregatorName: string;
    /**
     * `AWS::Config::ConfigurationAggregator.AccountAggregationSources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-accountaggregationsources
     */
    readonly accountAggregationSources?: Array<CfnConfigurationAggregator.AccountAggregationSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigurationAggregator.OrganizationAggregationSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-organizationaggregationsource
     */
    readonly organizationAggregationSource?: CfnConfigurationAggregator.OrganizationAggregationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigurationAggregator.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigurationAggregator
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 */
export declare class CfnConfigurationAggregator extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigurationAggregator";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigurationAggregator;
    /**
     * `AWS::Config::ConfigurationAggregator.ConfigurationAggregatorName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-configurationaggregatorname
     */
    configurationAggregatorName: string;
    /**
     * `AWS::Config::ConfigurationAggregator.AccountAggregationSources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-accountaggregationsources
     */
    accountAggregationSources: Array<CfnConfigurationAggregator.AccountAggregationSourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConfigurationAggregator.OrganizationAggregationSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-organizationaggregationsource
     */
    organizationAggregationSource: CfnConfigurationAggregator.OrganizationAggregationSourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConfigurationAggregator.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Config::ConfigurationAggregator`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationAggregatorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigurationAggregator
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 */
export declare namespace CfnConfigurationAggregator {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html
     */
    interface AccountAggregationSourceProperty {
        /**
         * `CfnConfigurationAggregator.AccountAggregationSourceProperty.AccountIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html#cfn-config-configurationaggregator-accountaggregationsource-accountids
         */
        readonly accountIds: string[];
        /**
         * `CfnConfigurationAggregator.AccountAggregationSourceProperty.AllAwsRegions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html#cfn-config-configurationaggregator-accountaggregationsource-allawsregions
         */
        readonly allAwsRegions?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationAggregator.AccountAggregationSourceProperty.AwsRegions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html#cfn-config-configurationaggregator-accountaggregationsource-awsregions
         */
        readonly awsRegions?: string[];
    }
}
/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigurationAggregator
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 */
export declare namespace CfnConfigurationAggregator {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html
     */
    interface OrganizationAggregationSourceProperty {
        /**
         * `CfnConfigurationAggregator.OrganizationAggregationSourceProperty.AllAwsRegions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html#cfn-config-configurationaggregator-organizationaggregationsource-allawsregions
         */
        readonly allAwsRegions?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationAggregator.OrganizationAggregationSourceProperty.AwsRegions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html#cfn-config-configurationaggregator-organizationaggregationsource-awsregions
         */
        readonly awsRegions?: string[];
        /**
         * `CfnConfigurationAggregator.OrganizationAggregationSourceProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html#cfn-config-configurationaggregator-organizationaggregationsource-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * Properties for defining a `AWS::Config::ConfigurationRecorder`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html
 */
export interface CfnConfigurationRecorderProps {
    /**
     * `AWS::Config::ConfigurationRecorder.RoleARN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::Config::ConfigurationRecorder.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name
     */
    readonly name?: string;
    /**
     * `AWS::Config::ConfigurationRecorder.RecordingGroup`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup
     */
    readonly recordingGroup?: CfnConfigurationRecorder.RecordingGroupProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Config::ConfigurationRecorder`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigurationRecorder
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html
 */
export declare class CfnConfigurationRecorder extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigurationRecorder";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigurationRecorder;
    /**
     * `AWS::Config::ConfigurationRecorder.RoleARN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn
     */
    roleArn: string;
    /**
     * `AWS::Config::ConfigurationRecorder.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name
     */
    name: string | undefined;
    /**
     * `AWS::Config::ConfigurationRecorder.RecordingGroup`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup
     */
    recordingGroup: CfnConfigurationRecorder.RecordingGroupProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Config::ConfigurationRecorder`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationRecorderProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigurationRecorder`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConfigurationRecorder
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html
 */
export declare namespace CfnConfigurationRecorder {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html
     */
    interface RecordingGroupProperty {
        /**
         * `CfnConfigurationRecorder.RecordingGroupProperty.AllSupported`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-allsupported
         */
        readonly allSupported?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationRecorder.RecordingGroupProperty.IncludeGlobalResourceTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-includeglobalresourcetypes
         */
        readonly includeGlobalResourceTypes?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationRecorder.RecordingGroupProperty.ResourceTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-resourcetypes
         */
        readonly resourceTypes?: string[];
    }
}
/**
 * Properties for defining a `AWS::Config::ConformancePack`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html
 */
export interface CfnConformancePackProps {
    /**
     * `AWS::Config::ConformancePack.ConformancePackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackname
     */
    readonly conformancePackName: string;
    /**
     * `AWS::Config::ConformancePack.ConformancePackInputParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackinputparameters
     */
    readonly conformancePackInputParameters?: Array<CfnConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3bucket
     */
    readonly deliveryS3Bucket?: string;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3KeyPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3keyprefix
     */
    readonly deliveryS3KeyPrefix?: string;
    /**
     * `AWS::Config::ConformancePack.TemplateBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatebody
     */
    readonly templateBody?: string;
    /**
     * `AWS::Config::ConformancePack.TemplateS3Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templates3uri
     */
    readonly templateS3Uri?: string;
}
/**
 * A CloudFormation `AWS::Config::ConformancePack`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConformancePack
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html
 */
export declare class CfnConformancePack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConformancePack";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConformancePack;
    /**
     * `AWS::Config::ConformancePack.ConformancePackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackname
     */
    conformancePackName: string;
    /**
     * `AWS::Config::ConformancePack.ConformancePackInputParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackinputparameters
     */
    conformancePackInputParameters: Array<CfnConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3bucket
     */
    deliveryS3Bucket: string | undefined;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3KeyPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3keyprefix
     */
    deliveryS3KeyPrefix: string | undefined;
    /**
     * `AWS::Config::ConformancePack.TemplateBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatebody
     */
    templateBody: string | undefined;
    /**
     * `AWS::Config::ConformancePack.TemplateS3Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templates3uri
     */
    templateS3Uri: string | undefined;
    /**
     * Create a new `AWS::Config::ConformancePack`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConformancePackProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConformancePack`.
 *
 * @external
 * @cloudformationResource AWS::Config::ConformancePack
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html
 */
export declare namespace CfnConformancePack {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-conformancepack-conformancepackinputparameter.html
     */
    interface ConformancePackInputParameterProperty {
        /**
         * `CfnConformancePack.ConformancePackInputParameterProperty.ParameterName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-conformancepack-conformancepackinputparameter.html#cfn-config-conformancepack-conformancepackinputparameter-parametername
         */
        readonly parameterName: string;
        /**
         * `CfnConformancePack.ConformancePackInputParameterProperty.ParameterValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-conformancepack-conformancepackinputparameter.html#cfn-config-conformancepack-conformancepackinputparameter-parametervalue
         */
        readonly parameterValue: string;
    }
}
/**
 * Properties for defining a `AWS::Config::DeliveryChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html
 */
export interface CfnDeliveryChannelProps {
    /**
     * `AWS::Config::DeliveryChannel.S3BucketName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3bucketname
     */
    readonly s3BucketName: string;
    /**
     * `AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-configsnapshotdeliveryproperties
     */
    readonly configSnapshotDeliveryProperties?: CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Config::DeliveryChannel.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-name
     */
    readonly name?: string;
    /**
     * `AWS::Config::DeliveryChannel.S3KeyPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3keyprefix
     */
    readonly s3KeyPrefix?: string;
    /**
     * `AWS::Config::DeliveryChannel.SnsTopicARN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-snstopicarn
     */
    readonly snsTopicArn?: string;
}
/**
 * A CloudFormation `AWS::Config::DeliveryChannel`.
 *
 * @external
 * @cloudformationResource AWS::Config::DeliveryChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html
 */
export declare class CfnDeliveryChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::DeliveryChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeliveryChannel;
    /**
     * `AWS::Config::DeliveryChannel.S3BucketName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3bucketname
     */
    s3BucketName: string;
    /**
     * `AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-configsnapshotdeliveryproperties
     */
    configSnapshotDeliveryProperties: CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::DeliveryChannel.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-name
     */
    name: string | undefined;
    /**
     * `AWS::Config::DeliveryChannel.S3KeyPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3keyprefix
     */
    s3KeyPrefix: string | undefined;
    /**
     * `AWS::Config::DeliveryChannel.SnsTopicARN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-snstopicarn
     */
    snsTopicArn: string | undefined;
    /**
     * Create a new `AWS::Config::DeliveryChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeliveryChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::DeliveryChannel`.
 *
 * @external
 * @cloudformationResource AWS::Config::DeliveryChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html
 */
export declare namespace CfnDeliveryChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-deliverychannel-configsnapshotdeliveryproperties.html
     */
    interface ConfigSnapshotDeliveryPropertiesProperty {
        /**
         * `CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty.DeliveryFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-deliverychannel-configsnapshotdeliveryproperties.html#cfn-config-deliverychannel-configsnapshotdeliveryproperties-deliveryfrequency
         */
        readonly deliveryFrequency?: string;
    }
}
/**
 * Properties for defining a `AWS::Config::OrganizationConfigRule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 */
export interface CfnOrganizationConfigRuleProps {
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationConfigRuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationconfigrulename
     */
    readonly organizationConfigRuleName: string;
    /**
     * `AWS::Config::OrganizationConfigRule.ExcludedAccounts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-excludedaccounts
     */
    readonly excludedAccounts?: string[];
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata
     */
    readonly organizationCustomRuleMetadata?: CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty | cdk.IResolvable;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata
     */
    readonly organizationManagedRuleMetadata?: CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`.
 *
 * @external
 * @cloudformationResource AWS::Config::OrganizationConfigRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 */
export declare class CfnOrganizationConfigRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::OrganizationConfigRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOrganizationConfigRule;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationConfigRuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationconfigrulename
     */
    organizationConfigRuleName: string;
    /**
     * `AWS::Config::OrganizationConfigRule.ExcludedAccounts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-excludedaccounts
     */
    excludedAccounts: string[] | undefined;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata
     */
    organizationCustomRuleMetadata: CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata
     */
    organizationManagedRuleMetadata: CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Config::OrganizationConfigRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOrganizationConfigRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`.
 *
 * @external
 * @cloudformationResource AWS::Config::OrganizationConfigRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 */
export declare namespace CfnOrganizationConfigRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html
     */
    interface OrganizationCustomRuleMetadataProperty {
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-description
         */
        readonly description?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.InputParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-inputparameters
         */
        readonly inputParameters?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.LambdaFunctionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-lambdafunctionarn
         */
        readonly lambdaFunctionArn: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.MaximumExecutionFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-maximumexecutionfrequency
         */
        readonly maximumExecutionFrequency?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.OrganizationConfigRuleTriggerTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-organizationconfigruletriggertypes
         */
        readonly organizationConfigRuleTriggerTypes: string[];
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.ResourceIdScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourceidscope
         */
        readonly resourceIdScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.ResourceTypesScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourcetypesscope
         */
        readonly resourceTypesScope?: string[];
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.TagKeyScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagkeyscope
         */
        readonly tagKeyScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.TagValueScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagvaluescope
         */
        readonly tagValueScope?: string;
    }
}
/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`.
 *
 * @external
 * @cloudformationResource AWS::Config::OrganizationConfigRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 */
export declare namespace CfnOrganizationConfigRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html
     */
    interface OrganizationManagedRuleMetadataProperty {
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-description
         */
        readonly description?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.InputParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-inputparameters
         */
        readonly inputParameters?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.MaximumExecutionFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-maximumexecutionfrequency
         */
        readonly maximumExecutionFrequency?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.ResourceIdScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourceidscope
         */
        readonly resourceIdScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.ResourceTypesScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourcetypesscope
         */
        readonly resourceTypesScope?: string[];
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.RuleIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-ruleidentifier
         */
        readonly ruleIdentifier: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.TagKeyScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagkeyscope
         */
        readonly tagKeyScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.TagValueScope`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagvaluescope
         */
        readonly tagValueScope?: string;
    }
}
/**
 * Properties for defining a `AWS::Config::OrganizationConformancePack`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html
 */
export interface CfnOrganizationConformancePackProps {
    /**
     * `AWS::Config::OrganizationConformancePack.OrganizationConformancePackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-organizationconformancepackname
     */
    readonly organizationConformancePackName: string;
    /**
     * `AWS::Config::OrganizationConformancePack.ConformancePackInputParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-conformancepackinputparameters
     */
    readonly conformancePackInputParameters?: Array<CfnOrganizationConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3bucket
     */
    readonly deliveryS3Bucket?: string;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3KeyPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3keyprefix
     */
    readonly deliveryS3KeyPrefix?: string;
    /**
     * `AWS::Config::OrganizationConformancePack.ExcludedAccounts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-excludedaccounts
     */
    readonly excludedAccounts?: string[];
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templatebody
     */
    readonly templateBody?: string;
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateS3Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templates3uri
     */
    readonly templateS3Uri?: string;
}
/**
 * A CloudFormation `AWS::Config::OrganizationConformancePack`.
 *
 * @external
 * @cloudformationResource AWS::Config::OrganizationConformancePack
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html
 */
export declare class CfnOrganizationConformancePack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::OrganizationConformancePack";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOrganizationConformancePack;
    /**
     * `AWS::Config::OrganizationConformancePack.OrganizationConformancePackName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-organizationconformancepackname
     */
    organizationConformancePackName: string;
    /**
     * `AWS::Config::OrganizationConformancePack.ConformancePackInputParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-conformancepackinputparameters
     */
    conformancePackInputParameters: Array<CfnOrganizationConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3Bucket`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3bucket
     */
    deliveryS3Bucket: string | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3KeyPrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3keyprefix
     */
    deliveryS3KeyPrefix: string | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.ExcludedAccounts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-excludedaccounts
     */
    excludedAccounts: string[] | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templatebody
     */
    templateBody: string | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateS3Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templates3uri
     */
    templateS3Uri: string | undefined;
    /**
     * Create a new `AWS::Config::OrganizationConformancePack`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOrganizationConformancePackProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::OrganizationConformancePack`.
 *
 * @external
 * @cloudformationResource AWS::Config::OrganizationConformancePack
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html
 */
export declare namespace CfnOrganizationConformancePack {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconformancepack-conformancepackinputparameter.html
     */
    interface ConformancePackInputParameterProperty {
        /**
         * `CfnOrganizationConformancePack.ConformancePackInputParameterProperty.ParameterName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconformancepack-conformancepackinputparameter.html#cfn-config-organizationconformancepack-conformancepackinputparameter-parametername
         */
        readonly parameterName: string;
        /**
         * `CfnOrganizationConformancePack.ConformancePackInputParameterProperty.ParameterValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconformancepack-conformancepackinputparameter.html#cfn-config-organizationconformancepack-conformancepackinputparameter-parametervalue
         */
        readonly parameterValue: string;
    }
}
/**
 * Properties for defining a `AWS::Config::RemediationConfiguration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
export interface CfnRemediationConfigurationProps {
    /**
     * `AWS::Config::RemediationConfiguration.ConfigRuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-configrulename
     */
    readonly configRuleName: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetid
     */
    readonly targetId: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targettype
     */
    readonly targetType: string;
    /**
     * `AWS::Config::RemediationConfiguration.Automatic`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-automatic
     */
    readonly automatic?: boolean | cdk.IResolvable;
    /**
     * `AWS::Config::RemediationConfiguration.ExecutionControls`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-executioncontrols
     */
    readonly executionControls?: CfnRemediationConfiguration.ExecutionControlsProperty | cdk.IResolvable;
    /**
     * `AWS::Config::RemediationConfiguration.MaximumAutomaticAttempts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-maximumautomaticattempts
     */
    readonly maximumAutomaticAttempts?: number;
    /**
     * `AWS::Config::RemediationConfiguration.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-parameters
     */
    readonly parameters?: any | cdk.IResolvable;
    /**
     * `AWS::Config::RemediationConfiguration.ResourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-resourcetype
     */
    readonly resourceType?: string;
    /**
     * `AWS::Config::RemediationConfiguration.RetryAttemptSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-retryattemptseconds
     */
    readonly retryAttemptSeconds?: number;
    /**
     * `AWS::Config::RemediationConfiguration.TargetVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetversion
     */
    readonly targetVersion?: string;
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
export declare class CfnRemediationConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::RemediationConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRemediationConfiguration;
    /**
     * `AWS::Config::RemediationConfiguration.ConfigRuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-configrulename
     */
    configRuleName: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetid
     */
    targetId: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targettype
     */
    targetType: string;
    /**
     * `AWS::Config::RemediationConfiguration.Automatic`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-automatic
     */
    automatic: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.ExecutionControls`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-executioncontrols
     */
    executionControls: CfnRemediationConfiguration.ExecutionControlsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.MaximumAutomaticAttempts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-maximumautomaticattempts
     */
    maximumAutomaticAttempts: number | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-parameters
     */
    parameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.ResourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-resourcetype
     */
    resourceType: string | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.RetryAttemptSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-retryattemptseconds
     */
    retryAttemptSeconds: number | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.TargetVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetversion
     */
    targetVersion: string | undefined;
    /**
     * Create a new `AWS::Config::RemediationConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRemediationConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-executioncontrols.html
     */
    interface ExecutionControlsProperty {
        /**
         * `CfnRemediationConfiguration.ExecutionControlsProperty.SsmControls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-executioncontrols.html#cfn-config-remediationconfiguration-executioncontrols-ssmcontrols
         */
        readonly ssmControls?: CfnRemediationConfiguration.SsmControlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-remediationparametervalue.html
     */
    interface RemediationParameterValueProperty {
        /**
         * `CfnRemediationConfiguration.RemediationParameterValueProperty.ResourceValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-remediationparametervalue.html#cfn-config-remediationconfiguration-remediationparametervalue-resourcevalue
         */
        readonly resourceValue?: CfnRemediationConfiguration.ResourceValueProperty | cdk.IResolvable;
        /**
         * `CfnRemediationConfiguration.RemediationParameterValueProperty.StaticValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-remediationparametervalue.html#cfn-config-remediationconfiguration-remediationparametervalue-staticvalue
         */
        readonly staticValue?: CfnRemediationConfiguration.StaticValueProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-resourcevalue.html
     */
    interface ResourceValueProperty {
        /**
         * `CfnRemediationConfiguration.ResourceValueProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-resourcevalue.html#cfn-config-remediationconfiguration-resourcevalue-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-ssmcontrols.html
     */
    interface SsmControlsProperty {
        /**
         * `CfnRemediationConfiguration.SsmControlsProperty.ConcurrentExecutionRatePercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-ssmcontrols.html#cfn-config-remediationconfiguration-ssmcontrols-concurrentexecutionratepercentage
         */
        readonly concurrentExecutionRatePercentage?: number;
        /**
         * `CfnRemediationConfiguration.SsmControlsProperty.ErrorPercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-ssmcontrols.html#cfn-config-remediationconfiguration-ssmcontrols-errorpercentage
         */
        readonly errorPercentage?: number;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-staticvalue.html
     */
    interface StaticValueProperty {
        /**
         * `CfnRemediationConfiguration.StaticValueProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-staticvalue.html#cfn-config-remediationconfiguration-staticvalue-values
         */
        readonly values?: string[];
    }
}
/**
 * Properties for defining a `AWS::Config::StoredQuery`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html
 */
export interface CfnStoredQueryProps {
    /**
     * `AWS::Config::StoredQuery.QueryExpression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-queryexpression
     */
    readonly queryExpression: string;
    /**
     * `AWS::Config::StoredQuery.QueryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-queryname
     */
    readonly queryName: string;
    /**
     * `AWS::Config::StoredQuery.QueryDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-querydescription
     */
    readonly queryDescription?: string;
    /**
     * `AWS::Config::StoredQuery.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Config::StoredQuery`.
 *
 * @external
 * @cloudformationResource AWS::Config::StoredQuery
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html
 */
export declare class CfnStoredQuery extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::StoredQuery";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStoredQuery;
    /**
     * @external
     * @cloudformationAttribute QueryArn
     */
    readonly attrQueryArn: string;
    /**
     * @external
     * @cloudformationAttribute QueryId
     */
    readonly attrQueryId: string;
    /**
     * `AWS::Config::StoredQuery.QueryExpression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-queryexpression
     */
    queryExpression: string;
    /**
     * `AWS::Config::StoredQuery.QueryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-queryname
     */
    queryName: string;
    /**
     * `AWS::Config::StoredQuery.QueryDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-querydescription
     */
    queryDescription: string | undefined;
    /**
     * `AWS::Config::StoredQuery.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-storedquery.html#cfn-config-storedquery-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Config::StoredQuery`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStoredQueryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
