Kubernetes Local Services
=========================
[![](https://img.shields.io/pypi/v/helm-charts.svg)](https://pypi.org/project/helm-charts/)
[![](https://img.shields.io/pypi/l/helm-charts.svg?colorB=blue)](https://pypi.org/project/helm-charts/)
[![](https://img.shields.io/pypi/pyversions/helm-charts.svg)](https://pypi.org/project/helm-charts/)

Install various Kubernetes Helm charts on your local Kubernetes installation 

- [Traefik](https://traefik.io/) (As Ingress Controller)
- [Kubernetes Dashboard](https://kubernetes.io/docs/tasks/access-application-cluster/web-ui-dashboard/)
- [OpenFaaS](https://www.openfaas.com/)
- [Airflow](https://airflow.apache.org/)
- More to come

Prerequisites
-------------

Install Docker **Edge** version,
Follow instructions [here](https://store.docker.com/editions/community/docker-ce-desktop-mac) (MacOS), 
Enter Docker preferences, And make sure to activate Kubernetes.
![](docs/docker_kubernetes.png)

* The application assumes that file `~/.kube/config` created/appended is generated by Docker installation,
  If this is not the case and you have multiple kube config files,
  please make sure to copy relevant local configs to `~/.kube/config.local`

Installation
------------

Run
```bash
pip install helm-charts
```

Usage
-----
execute `helm_charts` from command line

Access Kubernetes Dashboard
---------------------------

If `kubernetes_dashboard` selected during installation process,
In order to login, access https://kubernetes.localhost
Press `Choose kubeconfig file` or `...` on right side,  
Select `~/.kube/config.local` file and press `SIGN IN`
![](docs/kubernetes_dashboard.png)
