import * as cdk from '@aws-cdk/core';
/**
 * A resource that creates Amazon Elastic Kubernetes Service (Amazon EKS) clusters.
 *
 * @schema CfnClusterProps
 */
export interface CfnClusterProps {
    /**
     * A unique name for your cluster.
     *
     * @schema CfnClusterProps#Name
     */
    readonly name?: string;
    /**
     * Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role.
     *
     * This provides permissions for Amazon EKS to call other AWS APIs.
     *
     * @schema CfnClusterProps#RoleArn
     */
    readonly roleArn: string;
    /**
     * Name of the AWS Identity and Access Management (IAM) role used for clusters that have the public endpoint disabled.
     *
     * this provides permissions for Lambda to be invoked and attach to the cluster VPC
     *
     * @schema CfnClusterProps#LambdaRoleName
     */
    readonly lambdaRoleName?: string;
    /**
     * Desired Kubernetes version for your cluster.
     *
     * If you don't specify this value, the cluster uses the latest version from Amazon EKS.
     *
     * @schema CfnClusterProps#Version
     */
    readonly version?: string;
    /**
     * Network configuration for Amazon EKS cluster.
     *
     * @schema CfnClusterProps#KubernetesNetworkConfig
     */
    readonly kubernetesNetworkConfig?: CfnClusterPropsKubernetesNetworkConfig;
    /**
     * An object that represents the virtual private cloud (VPC) configuration to use for an Amazon EKS cluster.
     *
     * @schema CfnClusterProps#ResourcesVpcConfig
     */
    readonly resourcesVpcConfig: CfnClusterPropsResourcesVpcConfig;
    /**
     * Enables exporting of logs from the Kubernetes control plane to Amazon CloudWatch Logs.
     *
     * By default, logs from the cluster control plane are not exported to CloudWatch Logs. The valid log types are api, audit, authenticator, controllerManager, and scheduler.
     *
     * @schema CfnClusterProps#EnabledClusterLoggingTypes
     */
    readonly enabledClusterLoggingTypes?: string[];
    /**
     * Encryption configuration for the cluster.
     *
     * @schema CfnClusterProps#EncryptionConfig
     */
    readonly encryptionConfig?: EncryptionConfigEntry[];
    /**
     * @schema CfnClusterProps#KubernetesApiAccess
     */
    readonly kubernetesApiAccess?: CfnClusterPropsKubernetesApiAccess;
    /**
     * @schema CfnClusterProps#Tags
     */
    readonly tags?: CfnClusterPropsTags[];
}
/**
 * Converts an object of type 'CfnClusterProps' to JSON representation.
 */
export declare function toJson_CfnClusterProps(obj: CfnClusterProps | undefined): Record<string, any> | undefined;
/**
 * Network configuration for Amazon EKS cluster.
 *
 * @schema CfnClusterPropsKubernetesNetworkConfig
 */
export interface CfnClusterPropsKubernetesNetworkConfig {
    /**
     * Specify the range from which cluster services will receive IPv4 addresses.
     *
     * @schema CfnClusterPropsKubernetesNetworkConfig#ServiceIpv4Cidr
     */
    readonly serviceIpv4Cidr?: string;
}
/**
 * Converts an object of type 'CfnClusterPropsKubernetesNetworkConfig' to JSON representation.
 */
export declare function toJson_CfnClusterPropsKubernetesNetworkConfig(obj: CfnClusterPropsKubernetesNetworkConfig | undefined): Record<string, any> | undefined;
/**
 * An object that represents the virtual private cloud (VPC) configuration to use for an Amazon EKS cluster.
 *
 * @schema CfnClusterPropsResourcesVpcConfig
 */
export interface CfnClusterPropsResourcesVpcConfig {
    /**
     * Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
     *
     * If you don't specify a security group, the default security group for your VPC is used.
     *
     * @schema CfnClusterPropsResourcesVpcConfig#SecurityGroupIds
     */
    readonly securityGroupIds?: string[];
    /**
     * Specify subnets for your Amazon EKS worker nodes.
     *
     * Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
     *
     * @schema CfnClusterPropsResourcesVpcConfig#SubnetIds
     */
    readonly subnetIds: string[];
    /**
     * Set this value to false to disable public access to your cluster's Kubernetes API server endpoint.
     *
     * If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is true , which enables public access for your Kubernetes API server.
     *
     * @schema CfnClusterPropsResourcesVpcConfig#EndpointPublicAccess
     */
    readonly endpointPublicAccess?: boolean;
    /**
     * Set this value to true to enable private access for your cluster's Kubernetes API server endpoint.
     *
     * If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is false , which disables private access for your Kubernetes API server. If you disable private access and you have worker nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks for communication with the worker nodes or Fargate pods.
     *
     * @schema CfnClusterPropsResourcesVpcConfig#EndpointPrivateAccess
     */
    readonly endpointPrivateAccess?: boolean;
    /**
     * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
     *
     * Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0 . If you've disabled private endpoint access and you have worker nodes or AWS Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks.
     *
     * @schema CfnClusterPropsResourcesVpcConfig#PublicAccessCidrs
     */
    readonly publicAccessCidrs?: string[];
}
/**
 * Converts an object of type 'CfnClusterPropsResourcesVpcConfig' to JSON representation.
 */
export declare function toJson_CfnClusterPropsResourcesVpcConfig(obj: CfnClusterPropsResourcesVpcConfig | undefined): Record<string, any> | undefined;
/**
 * The encryption configuration for the cluster.
 *
 * @schema EncryptionConfigEntry
 */
export interface EncryptionConfigEntry {
    /**
     * Specifies the resources to be encrypted.
     *
     * The only supported value is "secrets".
     *
     * @schema EncryptionConfigEntry#Resources
     */
    readonly resources?: string[];
    /**
     * @schema EncryptionConfigEntry#Provider
     */
    readonly provider?: Provider;
}
/**
 * Converts an object of type 'EncryptionConfigEntry' to JSON representation.
 */
export declare function toJson_EncryptionConfigEntry(obj: EncryptionConfigEntry | undefined): Record<string, any> | undefined;
/**
 * @schema CfnClusterPropsKubernetesApiAccess
 */
export interface CfnClusterPropsKubernetesApiAccess {
    /**
     * @schema CfnClusterPropsKubernetesApiAccess#Roles
     */
    readonly roles?: KubernetesApiAccessEntry[];
    /**
     * @schema CfnClusterPropsKubernetesApiAccess#Users
     */
    readonly users?: KubernetesApiAccessEntry[];
}
/**
 * Converts an object of type 'CfnClusterPropsKubernetesApiAccess' to JSON representation.
 */
export declare function toJson_CfnClusterPropsKubernetesApiAccess(obj: CfnClusterPropsKubernetesApiAccess | undefined): Record<string, any> | undefined;
/**
 * @schema CfnClusterPropsTags
 */
export interface CfnClusterPropsTags {
    /**
     * @schema CfnClusterPropsTags#Value
     */
    readonly value: string;
    /**
     * @schema CfnClusterPropsTags#Key
     */
    readonly key: string;
}
/**
 * Converts an object of type 'CfnClusterPropsTags' to JSON representation.
 */
export declare function toJson_CfnClusterPropsTags(obj: CfnClusterPropsTags | undefined): Record<string, any> | undefined;
/**
 * AWS Key Management Service (AWS KMS) customer master key (CMK).
 *
 * Either the ARN or the alias can be used.
 *
 * @schema Provider
 */
export interface Provider {
    /**
     * Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     *
     * The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK.
     *
     * @schema Provider#KeyArn
     */
    readonly keyArn?: string;
}
/**
 * Converts an object of type 'Provider' to JSON representation.
 */
export declare function toJson_Provider(obj: Provider | undefined): Record<string, any> | undefined;
/**
 * @schema KubernetesApiAccessEntry
 */
export interface KubernetesApiAccessEntry {
    /**
     * @schema KubernetesApiAccessEntry#Arn
     */
    readonly arn?: string;
    /**
     * @schema KubernetesApiAccessEntry#Username
     */
    readonly username?: string;
    /**
     * @schema KubernetesApiAccessEntry#Groups
     */
    readonly groups?: string[];
}
/**
 * Converts an object of type 'KubernetesApiAccessEntry' to JSON representation.
 */
export declare function toJson_KubernetesApiAccessEntry(obj: KubernetesApiAccessEntry | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::EKS::Cluster`.
 *
 * @external
 * @cloudformationResource AWSQS::EKS::Cluster
 * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
 */
export declare class CfnCluster extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::EKS::Cluster";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnClusterProps;
    /**
     * Attribute `AWSQS::EKS::Cluster.Arn`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
     */
    readonly attrArn: string;
    /**
     * Attribute `AWSQS::EKS::Cluster.Endpoint`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
     */
    readonly attrEndpoint: string;
    /**
     * Attribute `AWSQS::EKS::Cluster.ClusterSecurityGroupId`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
     */
    readonly attrClusterSecurityGroupId: string;
    /**
     * Attribute `AWSQS::EKS::Cluster.CertificateAuthorityData`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
     */
    readonly attrCertificateAuthorityData: string;
    /**
     * Attribute `AWSQS::EKS::Cluster.EncryptionConfigKeyArn`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
     */
    readonly attrEncryptionConfigKeyArn: string;
    /**
     * Attribute `AWSQS::EKS::Cluster.OIDCIssuerURL`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
     */
    readonly attrOIDCIssuerURL: string;
    /**
     * Create a new `AWSQS::EKS::Cluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClusterProps);
}
