from __future__ import annotations

import datetime

from beancount.core.amount import Amount
from beancount.core.data import Currency, Posting
from beancount.core.display_context import DisplayFormatter
from beancount.core.inventory import Inventory
from decimal import Decimal
from typing import Any, Callable, Optional

class Cost:
    number: Decimal
    currency: Currency
    date: datetime.date
    label: Optional[str]
    def _replace(self: Cost) -> Cost: ...
    def _asdict(self: Cost) -> dict[str, Any]: ...

class CostSpec:
    number_per: Optional[Decimal]
    number_total: Optional[Decimal]
    currency: Optional[str]
    date: Optional[datetime.date]
    label: Optional[str]
    merge: Optional[bool]
    def _replace(self: CostSpec) -> CostSpec: ...
    def _asdict(self: CostSpec) -> dict[str, Any]: ...

def cost_to_str(
    cost: Cost | CostSpec, dformat: DisplayFormatter, detail: bool = ...
) -> str: ...

CURRENCY_ORDER: dict[str, int]
NCURRENCIES: int

def get_position(posting: Posting) -> Position: ...
def to_string(
    pos: Position | Posting,
    dformat: DisplayFormatter = ...,
    detail: bool = ...,
) -> str: ...

class Position:
    units: Amount
    cost: Cost | CostSpec
    cost_types: tuple[type[Cost], type[CostSpec]]
    def __new__(
        cls: type[Position], units: Amount, cost: Cost | CostSpec | None = ...
    ) -> Position: ...
    def __hash__(self: Position) -> int: ...
    def to_string(
        self: Position, dformat: DisplayFormatter = ..., detail: bool = ...
    ) -> str: ...
    def __eq__(self: Position, other: object) -> bool: ...
    def sortkey(
        self: Position,
    ) -> tuple[Amount, Decimal, Currency, Decimal]: ...
    def __lt__(self: Position, other: object) -> bool: ...
    def __copy__(self: Position) -> Position: ...
    def currency_pair(
        self: Position,
    ) -> tuple[Currency, Optional[Currency]]: ...
    def get_negative(self: Position) -> Position: ...
    __neg__: Callable[[Position], Position]
    def __abs__(self: Position) -> Position: ...
    def __mul__(self: Position, scalar: Decimal) -> Inventory: ...
    def is_negative_at_cost(self: Position) -> bool: ...
    def _replace(self: Position) -> Position: ...
    def _asdict(self: Position) -> dict[str, Any]: ...
    @staticmethod
    def from_string(string: str) -> Position: ...
    @staticmethod
    def from_amounts(
        units: Amount, cost_amount: Amount | None = ...
    ) -> Position: ...

from_string: Callable[[str], Position]
from_amounts: Callable[[Amount, Amount | None], Position]
