# Practical Tutorials

Welcome to the hands-on section of the HydraFlow documentation. These tutorials provide practical examples to help you understand how HydraFlow works in real-world scenarios.

## What You'll Learn

These tutorials demonstrate the core capabilities of HydraFlow through executable examples:

1. **Basic Application** - Create and run a simple HydraFlow application
2. **Automated Workflows** - Define and execute complex experiment workflows
3. **Results Analysis** - Load, filter, and analyze experiment results

Each tutorial includes:

- Complete working code examples
- Step-by-step explanations
- Real command outputs
- Practical insights

## Prerequisites

To follow these tutorials, you'll need:

- HydraFlow installed ([Installation Guide](../getting-started/installation.md))
- Basic understanding of Python
- Familiarity with machine learning experiment concepts

## Learning Path

These tutorials are designed to be followed in sequence:

<div class="grid cards" markdown>

- :material-application-outline: [**Basic Application**](applications.md)
  Learn how to create and run a simple HydraFlow application
- :material-cog-play-outline: [**Automated Workflows**](advanced.md)
  Define complex experiment workflows using `hydraflow.yaml`
- :material-chart-box-outline: [**Results Analysis**](analysis.md)
  Analyze experiment results using HydraFlow's powerful APIs

</div>

By working through these tutorials, you'll gain a practical understanding of HydraFlow's capabilities and how it can streamline your machine learning experiments.

## Next Steps

After completing these tutorials, you'll be ready to:

- Explore the detailed [User Guide](../part1-applications/index.md) for in-depth explanations
- Apply HydraFlow to your own machine learning projects
- Customize HydraFlow's components for your specific needs