# Руководство по устранению неполадок (ARA API)

Этот документ поможет диагностировать и решать распространенные проблемы, которые могут возникнуть при работе с ARA API.

## 1. Общие советы по диагностике

1.  **Проверьте логи**: Первое, что нужно сделать при возникновении проблемы – изучить логи приложения. Они обычно содержат подробную информацию об ошибках и исключениях. Расположение лог-файлов и уровень детализации настраиваются в конфигурационном файле (см. `config_manager.py` и `logger_config.py`).
2.  **Статус gRPC**: При проблемах с API убедитесь, что gRPC сервер запущен и доступен. Проверьте консольный вывод при запуске сервера на наличие ошибок инициализации.
3.  **Конфигурация**: Убедитесь, что конфигурационные файлы (`config.yaml` или аналогичный) корректны и содержат правильные параметры (порты, пути, настройки оборудования).
4.  **Зависимости**: Проверьте, что все необходимые зависимости установлены и их версии совместимы.
5.  **Сетевое соединение**: Если клиент и сервер находятся на разных машинах, проверьте сетевое соединение между ними (ping, доступность портов).

## 2. Проблемы с gRPC сервисами

### 2.1. Клиент не может подключиться к серверу

*   **Симптомы**: Ошибки типа `UNAVAILABLE`, `DEADLINE_EXCEEDED` на стороне клиента.
*   **Возможные причины и решения**:
    *   **Сервер не запущен**: Убедитесь, что главный скрипт приложения (`main.py` или `app.py`) успешно запущен и gRPC сервер стартовал без ошибок.
    *   **Неправильный адрес/порт**: Проверьте, что клиент использует правильный IP-адрес и порт, на котором слушает gRPC сервер (указан в конфигурации и при запуске сервера).
    *   **Брандмауэр/Firewall**: Брандмауэр на сервере или клиенте может блокировать соединение. Убедитесь, что порт gRPC открыт.
    *   **Проблемы с сетью**: Общие проблемы с сетевой связью.

### 2.2. Ошибки `INVALID_ARGUMENT`

*   **Симптомы**: Сервер возвращает статус `INVALID_ARGUMENT`.
*   **Возможные причины и решения**:
    *   **Некорректные параметры запроса**: Клиент отправил запрос с неверными или отсутствующими обязательными параметрами. Проверьте документацию по API (`api_guide.md`) и определения `.proto` файлов для корректной структуры запроса.
    *   **Неверный тип данных**: Тип данных одного из полей запроса не соответствует ожидаемому сервером.

### 2.3. Ошибки `NOT_FOUND`

*   **Симптомы**: Сервер возвращает статус `NOT_FOUND`.
*   **Возможные причины и решения**:
    *   **Ресурс не существует**: Запрашиваемый ресурс (например, камера с определенным ID, файл конфигурации) не найден на сервере.
    *   **Неверный идентификатор**: Клиент использует неверный идентификатор для доступа к ресурсу.

### 2.4. Ошибки `PERMISSION_DENIED` или `UNAUTHENTICATED`

*   **Симптомы**: Сервер отказывает в доступе.
*   **Возможные причины и решения**:
    *   **Механизмы аутентификации/авторизации**: Если в системе реализованы такие механизмы, убедитесь, что клиент предоставляет корректные учетные данные или имеет необходимые права.

### 2.5. Ошибки `INTERNAL` или `UNKNOWN`

*   **Симптомы**: Общие ошибки на стороне сервера.
*   **Возможные причины и решения**:
    *   **Необработанное исключение на сервере**: Проверьте логи сервера на наличие стектрейсов и сообщений об ошибках. Это может указывать на баг в коде сервера.
    *   **Проблемы с зависимостями сервера**: Например, внешняя библиотека или сервис, от которого зависит ARA API, не работает корректно.

### 2.6. Проблемы с `ApplicationManager` и запуском процессов

* **Симптомы**: Один или несколько сервисов (MSP, Navigation, Vision) не запускаются; ошибки в консоли, связанные с `ApplicationManager` или дочерними процессами.
* **Возможные причины и решения**:
  * **Ошибка в конфигурации запуска**: `ApplicationManager` может неверно интерпретировать аргументы командной строки или конфигурационный файл, что приводит к неправильному запуску дочерних процессов. Проверьте правильность передаваемых аргументов и конфигурацию.
  * **Ресурсы не освобождаются корректно**: При перезапуске или остановке, если дочерние процессы не завершаются должным образом, это может помешать новому запуску. Убедитесь, что логика остановки в `ApplicationManager` и в самих процессах (`terminate`, `join`) работает корректно.
  * **Конфликт портов gRPC**: Если `ApplicationManager` или дочерние процессы пытаются запустить gRPC серверы на уже занятых портах (например, если предыдущий экземпляр приложения не был полностью остановлен). Проверьте доступность портов.
  * **Ошибки внутри дочернего процесса при инициализации**: Проблема может быть не в `ApplicationManager`, а в одном из `XXXManagerProcess` (например, `MSPManagerProcess` не может инициализировать `MSPManager`). Смотрите логи конкретного сервиса.

## 3. Проблемы с модулем MSP (`MspService`)

### 3.1. Нет ответа от полетного контроллера

* **Симптомы**: `MspService` возвращает ошибки, связанные с таймаутом или отсутствием данных (`UNAVAILABLE`, `DATA_LOSS`, или специфические ошибки MSP).
* **Возможные причины и решения**:
  * **Физическое подключение**: Проверьте кабель UART/USB между устройством, где запущен ARA API, и полетным контроллером. Убедитесь, что TX/RX подключены правильно.
  * **Настройки последовательного порта**: В конфигурации ARA API (`config.yaml`) должны быть правильно указаны порт (`/dev/ttyUSB0`, `COM3` и т.д.) и скорость (`baudrate`) для связи с ПК. Эти параметры должны совпадать с настройками ПК.
  * **Полетный контроллер не отвечает**: Убедитесь, что ПК включен, прошит и настроен на прием MSP команд через соответствующий UART.
  * **Права доступа к порту**: В Linux пользователь, от имени которого запущено приложение, должен иметь права на чтение/запись для последовательного порта (обычно членство в группе `dialout`).
  * **Другое ПО использует порт**: Убедитесь, что никакое другое приложение (например, конфигуратор полетного контроллера) не использует этот же последовательный порт одновременно.

### 3.2. Ошибки CRC (Cyclic Redundancy Check)

* **Симптомы**: В логах появляются сообщения об ошибках CRC при обмене данными с ПК.
* **Возможные причины и решения**:
  * **Помехи на линии связи**: Плохое качество кабеля, электромагнитные наводки могут вызывать искажение данных.
  * **Неправильная скорость порта**: Несоответствие `baudrate` между ARA API и ПК.
  * **Проблемы с прошивкой ПК**: Редко, но возможно.

## 4. Проблемы с модулем навигации (`NavigationService`)

### 4.1. Команды навигации не выполняются (взлет, посадка, движение)

* **Симптомы**: `NavigationService` возвращает `success: false` или ошибки `FAILED_PRECONDITION`.
* **Возможные причины и решения**:
  * **Дрон не готов (precondition failed)**: Полетный контроллер может быть не заармлен, отсутствует GPS-фиксация (если требуется для команды), низкий заряд батареи, или другие условия безопасности не выполнены.
    * **Решение**: Проверьте статус дрона через MSP (например, запросив `MSP_STATUS_EX` или аналогичные команды) или через логгирование в `NavigationProcessor`.
  * **Некорректные параметры команды**: Например, попытка взлететь на слишком большую высоту или двигаться в недостижимую точку.
  * **Проблемы с системой позиционирования**: Если навигация зависит от GPS, VIO или другой системы позиционирования, убедитесь, что эта система работает корректно и предоставляет точные данные.
  * **Ошибки в логике `NavigationProcessor`**: Проверьте логи на наличие ошибок внутри процессора навигации.

## 5. Проблемы с модулем компьютерного зрения (`VisionService`)

### 5.1. Нет видеопотока или изображений (`GetImageStream`)

* **Симптомы**: `VisionService` не возвращает данные или возвращает ошибку `NOT_FOUND` / `UNAVAILABLE`.
* **Возможные причины и решения**:
  * **Камера не подключена или неисправна**: Проверьте физическое подключение камеры.
  * **Неправильный `camera_id`**: Убедитесь, что используемый ID камеры соответствует конфигурации в `CameraManager`.
  * **Драйверы камеры**: Убедитесь, что в системе установлены необходимые драйверы для камеры.
  * **Камера используется другим приложением**: Только одно приложение может получать доступ к камере одновременно (для большинства типов камер).
  * **Права доступа к камере**: В Linux может потребоваться добавить пользователя в группу `video`.
  * **Ошибки в `CameraManager`**: Проверьте логи на ошибки инициализации или захвата кадров.

### 5.2. Детекция объектов не работает или работает некорректно (`DetectObjects`)

* **Симптомы**: Нет обнаруженных объектов, неверные детекции, низкая точность.
* **Возможные причины и решения**:
  * **Модель детекции не загружена**: Проверьте, что путь к файлам модели (например, `.tflite`, `.onnx`, `.pb`) и файлам меток (labels) указан правильно в конфигурации `VisionService` или передается корректно при инициализации `VisionController`. Убедитесь, что файлы существуют и доступны для чтения. Проверьте логи `VisionProcessor` на ошибки загрузки модели.
  * **Неподдерживаемый формат модели или ошибка конфигурации**: Убедитесь, что используемая модель (например, TensorFlow, ONNX, PyTorch) совместима с кодом `VisionProcessor`.
  * **Недостаточное освещение или плохое качество изображения**: Для корректной работы моделей КЗ требуется хорошее качество входных данных.
  * **Параметры детекции**: Попробуйте настроить параметры детекции (например, порог уверенности) в `DetectionRequest` или в конфигурации модели.
  * **Высокая нагрузка на систему**: Детекция объектов может быть ресурсоемкой. Если система перегружена, это может влиять на производительность.
  * **Несоответствие версии библиотеки КЗ/МО**: Убедитесь, что версия библиотеки, используемой для запуска модели (например, TensorFlow Lite Runtime, ONNX Runtime), совместима с самой моделью и кодом `VisionProcessor`.

### 5.3. Проблемы с `CameraManager` (если используется)

* **Симптомы**: `VisionService` не может получить доступ к камере, ошибки `UNAVAILABLE` или специфичные ошибки камеры.
* **Возможные причины и решения**:
  * **`CameraManager` не реализован или не настроен**: Если `CameraManager` является предполагаемым компонентом, убедитесь, что он добавлен в проект и корректно настроен в `VisionController`.
  * **Неправильная конфигурация камеры в `CameraManager`**: ID камеры, разрешение, формат видео могут быть указаны неверно.
  * **Проблемы с драйверами на уровне ОС**: Даже если камера физически подключена, могут отсутствовать или некорректно работать системные драйверы.

## 6. Проблемы с конфигурацией

### 6.1. Приложение не запускается из-за ошибки конфигурации

* **Симптомы**: Ошибки при запуске, связанные с чтением или парсингом конфигурационного файла.
* **Возможные причины и решения**:
  * **Файл конфигурации отсутствует или указан неверный путь**.
  * **Синтаксическая ошибка в файле конфигурации** (например, в YAML или JSON). Проверьте синтаксис с помощью валидатора.
  * **Отсутствуют обязательные параметры**.

### 6.2. Некорректные пути в конфигурации

* **Симптомы**: Ошибки `FileNotFoundError` или аналогичные при попытке доступа к файлам (модели КЗ, лог-файлы, CSV для анализатора).
* **Возможные причины и решения**:
  * **Относительные пути**: Если используются относительные пути, убедитесь, что они корректно разрешаются относительно текущей рабочей директории приложения. Рекомендуется использовать абсолютные пути или пути, формируемые относительно корня проекта.
  * **Опечатки в путях**: Проверьте правильность написания путей в конфигурационном файле.

## 7. Проблемы с зависимостями

### 7.1. Ошибки `ImportError` или `ModuleNotFoundError`

* **Симптомы**: Приложение не запускается, сообщая о ненайденном модуле.
* **Возможные причины и решения**:
  * **Зависимость не установлена**: Установите все зависимости, перечисленные в `requirements.txt` (или аналогичном файле), используя `pip install -r requirements.txt`.
  * **Проблемы с виртуальным окружением**: Убедитесь, что вы работаете в правильном виртуальном окружении, где установлены все зависимости.

## 8. Сбор информации для отладки

Если вы не можете решить проблему самостоятельно, при обращении за помощью предоставьте следующую информацию:

* **Версия ARA API** (если версионируется).
* **Операционная система** и ее версия.
* **Версия Python**.
* **Содержимое конфигурационного файла** (удалите чувствительные данные).
* **Полные логи приложения** с момента запуска до возникновения ошибки.
* **Точные шаги для воспроизведения проблемы**.
* **Ожидаемое поведение и фактическое поведение**.

## 9. Проблемы межпроцессного взаимодействия (IPC)

* **Симптомы**: Данные между различными компонентами системы (например, между `NavigationController` и `MSPController`, или между `ApplicationManager` и дочерними процессами) передаются некорректно, с задержками, или не передаются вовсе. Ошибки, связанные с `multiprocessing.Pipe`, `Queue` или другими механизмами IPC.
* **Возможные причины и решения**:
  * **Дедлоки (Deadlocks)**: Неправильный порядок блокировок или ожидания ресурсов может привести к взаимной блокировке процессов.
  * **Переполнение очередей/пайпов**: Если один процесс генерирует данные быстрее, чем другой успевает их обрабатывать, очередь или пайп может переполниться.
  * **Ошибки сериализации/десериализации**: При передаче сложных объектов между процессами могут возникать проблемы с их корректной сериализацией и десериализацией. Убедитесь, что передаваемые объекты поддерживают `pickle` или используется другой подходящий механизм.
  * **Неправильная логика синхронизации**: Ошибки в использовании семафоров, событий или других примитивов синхронизации.
  * **Некорректное закрытие каналов связи**: Пайпы и очереди должны корректно закрываться при завершении работы процессов, чтобы избежать утечек ресурсов или ошибок `BrokenPipeError`.
* **Диагностика**:
  * **Логирование**: Добавьте подробное логирование в точках отправки и приема данных через IPC.
  * **Отладчики**: Используйте отладчики, поддерживающие многопроцессность, если это возможно.
  * **Упрощение**: Попробуйте воспроизвести проблему на минимальном примере, изолировав компоненты, участвующие в IPC.

---
*Этот документ будет обновляться по мере выявления новых типичных проблем и их решений.*
