# Описание модулей (ARA API)

В этом документе представлен общий обзор основных модулей, входящих в состав проекта ARA API.
Более подробную информацию о каждом модуле, его внутренней структуре, классах и функциях можно найти в документе [Детальное описание модулей](./modules_detailed.md).

## 1. Корневая директория `ara_api`

Содержит основную логику приложения.

* **`__main__.py`**: Точка входа для запуска приложения. Отвечает за инициализацию и запуск gRPC сервера и других необходимых компонентов.
* **`_core/`**: Директория с ядром бизнес-логики.
  * **`services/`**: Содержит реализации gRPC сервисов (MSP, Navigation, Vision). Каждый подмодуль здесь соответствует одному сервису и включает его реализацию и, возможно, связанную логику обработки.
  * **`processors/`**: Содержит классы-обработчики (процессоры), которые инкапсулируют сложную логику, связанную с конкретными задачами (например, `MspProcessor` для работы с MSP, `NavProcessor` для навигации, `VisionProcessor` для задач компьютерного зрения).
  * **`manager.py`**: (Если существует в таком виде) Может содержать класс-менеджер или логику для координации работы различных частей ядра.
* **`_utils/`**: Директория со вспомогательными утилитами и модулями.
  * **`communication/`**: Модули, связанные с коммуникациями.
    * **`gRPC/`**: Сгенерированный Python код из `.proto` файлов (определения сообщений и сервисов).
    * **`protobuf/`**: `.proto` файлы, определяющие контракты gRPC API.
    * **`grpc_sync.py`, `websocket_sync.py`**: (Если используются) Могут содержать обертки или утилиты для работы с gRPC и WebSocket.
  * **`config.py`**: Управление конфигурацией приложения (загрузка, доступ к параметрам).
  * **`logger.py`**: Настройка и управление логированием.
  * **`exception.py`**: Определение пользовательских классов исключений.
  * **`transmitter.py`**: Низкоуровневая работа с последовательным портом для MSP или других нужд.
  * **`data/`**: Модули для определения структур данных, специфичных для домена (например, `msp_data.py`, `nav_data.py`).
  * (Другие утилиты, например, для работы с камерами, математические расчеты и т.д.)

## 2. Директория `docs`

Содержит всю документацию проекта, включая это руководство.

* **`index.md`**: Главная страница документации.
* **`architecture.md`**: Описание архитектуры системы.
* **`api_guide.md`**: Руководство по использованию gRPC API.
* **`modules.md`**: Этот файл - общее описание модулей.
* **`modules_detailed.md`**: Детальное описание каждого модуля.
* **`protocols.md`**: Описание используемых протоколов связи.
* **`troubleshooting.md`**: Руководство по устранению неполадок.
* **`contributing.md`**: Руководство для контрибьюторов.
* **`glossary.md`**: Словарь терминов.
* **`development_guide.md`**: Руководство по настройке окружения и разработке.

## 3. Директория `tests`

Содержит автоматические тесты (модульные, интеграционные) для проверки корректности работы кода.
Структура директории `tests` обычно зеркально отражает структуру директории `ara_api` для удобства навигации и организации тестов.

## 4. Файлы в корне проекта

* **`pyproject.toml`**: Файл конфигурации проекта для Poetry, содержащий метаданные проекта, зависимости и настройки сборки.
* **`poetry.lock`**: Файл, генерируемый Poetry, который содержит точные версии всех зависимостей, обеспечивая воспроизводимость окружения.
* **`README.md`**: Общее описание проекта, инструкции по установке и быстрому старту.
* **`LICENSE`**: Файл с информацией о лицензии проекта.
* **`generate_proto.sh`**: Скрипт для автоматической генерации Python кода из `.proto` файлов.
* **`.gitignore`**: Определяет файлы и директории, которые должны быть проигнорированы системой контроля версий Git.

Для более глубокого понимания каждого модуля, пожалуйста, обратитесь к [Детальному описанию модулей](./modules_detailed.md).
