# Глоссарий терминов (ARA API)

Этот глоссарий определяет ключевые термины, используемые в проекте ARA API и его документации.

## A

* **API (Application Programming Interface)**: Интерфейс прикладного программирования. В контексте ARA – это набор gRPC сервисов, позволяющих внешним приложениям взаимодействовать с системой дрона.
* **ARA API**: Название данного проекта, предоставляющего API для управления и взаимодействия с дроном.
* **ApplicationManager**: Основной управляющий класс в `ara_api`, ответственный за инициализацию и управление жизненным циклом дочерних процессов (менеджеров сервисов).
* **Арминг (Arming)**: Процесс активации моторов дрона, после которого он готов к взлету. Для арминга обычно требуется выполнение ряда предусловий (например, калибровка сенсоров, отсутствие ошибок).

## B

* **Betaflight**: Популярная прошивка для полетных контроллеров, часто используемая в FPV-дронах. Поддерживает протокол MSP.

## C

* **CameraManager**: (Гипотетический) Модуль, отвечающий за управление камерами, захват изображений и видеопотоков.
* **CRC (Cyclic Redundancy Check)**: Циклический избыточный код. Алгоритм обнаружения ошибок, используемый для проверки целостности данных при передаче, например, в протоколе MSP.
* **CV (Computer Vision)**: Компьютерное зрение. Область искусственного интеллекта, связанная с анализом изображений и видео.

## D

* **Дизарминг (Disarming)**: Процесс деактивации моторов дрона.
* **Дрон (Drone)**: Беспилотный летательный аппарат (БПЛА).

## F

* **FC (Flight Controller)**: См. ПК (Полетный Контроллер).

## G

* **gRPC (Google Remote Procedure Call)**: Высокопроизводительный фреймворк для удаленного вызова процедур (RPC), разработанный Google. Используется в ARA API как основной протокол для взаимодействия клиент-сервер.
* **GPS (Global Positioning System)**: Глобальная система позиционирования. Используется для определения географического местоположения дрона.

## I

* **iNAV**: Прошивка для полетных контроллеров, ориентированная на автономные полеты и навигацию. Поддерживает протокол MSP.
* **IPC (Inter-Process Communication)**: Межпроцессное взаимодействие. Механизмы, позволяющие различным процессам обмениваться данными (например, `multiprocessing.Queue` в Python).

## M

* **Менеджер сервиса (Service Manager)**: В архитектуре ARA API, это процесс, управляющий конкретным сервисом (например, `MSPManagerProcess`, `NavigationManagerProcess`, `VisionManagerProcess`). Запускается и контролируется `ApplicationManager`.
* **MSP (MultiWii Serial Protocol)**: Протокол последовательной связи, часто используемый для взаимодействия с полетными контроллерами (например, на базе прошивок Betaflight, iNAV, Cleanflight). Позволяет считывать данные с сенсоров, отправлять команды управления и настраивать параметры.
  * **MSP Код (MSP Code)**: Числовой идентификатор конкретной команды или запроса данных в протоколе MSP.
* **Модель (Machine Learning Model)**: В контексте компьютерного зрения – обученная нейронная сеть или другой алгоритм машинного обучения, используемый для задач, таких как детекция объектов, сегментация и т.д.

## N

* **Навигация (Navigation)**: Процесс управления движением дрона в пространстве, включая взлет, посадку, перемещение по заданным координатам или маршруту.

## P

* **ПК (Полетный Контроллер / Flight Controller, FC)**: Электронное устройство, являющееся "мозгом" дрона. Обрабатывает данные с сенсоров (гироскоп, акселерометр, компас, GPS и т.д.) и управляет моторами для стабилизации и перемещения дрона.
* **Poetry**: Инструмент для управления зависимостями и пакетами в Python. Используется в ARA API.
* **Процессор (Processor)**: В контексте ARA API, компонент внутри менеджера сервиса, отвечающий за основную логику обработки данных или выполнения команд (например, `MspProcessor`, `NavProcessor`, `VisionProcessor`).
* **Protobuf (Protocol Buffers)**: Языко- и платформонезависимый механизм сериализации структурированных данных, разработанный Google. Используется в gRPC для определения структуры сообщений и сервисов.
  * **.proto файл**: Файл, содержащий определения сообщений и сервисов в синтаксисе Protocol Buffers.

## Q

* **Queue (Очередь)**: Структура данных, используемая для межпроцессного взаимодействия (IPC) в ARA API для передачи данных между `ApplicationManager` и менеджерами сервисов.

## R

* **RC (Remote Control)**: Пульт дистанционного управления дроном.
* **RPC (Remote Procedure Call)**: Удаленный вызов процедур. Технология, позволяющая программе вызывать процедуру (функцию, метод) в другом адресном пространстве (обычно на другом компьютере в сети).

## S

* **SDK (Software Development Kit)**: Комплект средств разработки. В контексте ARA API может означать клиентские библиотеки и инструменты для упрощения интеграции с API.
* **Сервис (gRPC Service)**: В gRPC, сервис определяет набор методов (RPC), которые могут быть вызваны удаленно. В ARA API каждый основной функциональный блок (MSP, навигация, зрение) представлен своим gRPC сервисом.
* **STM32**: Семейство 32-битных микроконтроллеров, часто используемых в полетных контроллерах.

## T

* **Телеметрия (Telemetry)**: Данные о состоянии и параметрах полета дрона (например, высота, скорость, заряд батареи, координаты), передаваемые на наземную станцию или управляющее приложение.
* **Transmitter**: Вспомогательный класс в `ara_api/_utils`, отвечающий за отправку данных, например, по последовательному порту для MSP.

## U

* **UART (Universal Asynchronous Receiver-Transmitter)**: Универсальный асинхронный приемопередатчик. Стандартный интерфейс для последовательной передачи данных, часто используемый для подключения полетного контроллера к другим устройствам.

## V

* **VIO (Visual-Inertial Odometry)**: Визуально-инерциальная одометрия. Технология определения положения и ориентации объекта путем совместной обработки данных с камер (визуальная информация) и инерциальных датчиков (IMU).

## W

* **WebSocket**: Протокол связи поверх TCP-соединения, предназначенный для обмена сообщениями между браузером и веб-сервером в режиме реального времени. Может использоваться для стриминга данных.

---

*Этот глоссарий будет пополняться по мере необходимости.*
