# Руководство по разработке и настройке окружения (ARA API)

Это руководство поможет вам настроить рабочее окружение для разработки и внесения вклада в проект ARA API.

## 1. Требования к системе

* **Python**: Версия 3.10 или выше (согласно `pyproject.toml`).
* **Poetry**: Инструмент для управления зависимостями и сборки проекта. Инструкции по установке см. на [официальном сайте Poetry](https://python-poetry.org/docs/#installation).
* **Git**: Система контроля версий.
* **Protobuf Compiler (`protoc`)**: Необходим для генерации кода из `.proto` файлов. Инструкции по установке см. в [документации Protocol Buffers](https://grpc.io/docs/protoc-installation/).
* **gRPC tools для Python**: Устанавливаются через Poetry как зависимости проекта (`grpcio`, `grpcio-tools`).
* (Опционально) **Docker**: Для контейнеризации и развертывания.
* (Опционально) **Совместимый полетный контроллер**: Для тестирования функционала, связанного с MSP (например, Betaflight, iNAV на STM32).
* (Опционально) **Камеры**: Для тестирования функционала компьютерного зрения.

## 2. Настройка окружения

1. **Клонируйте репозиторий** (если вы еще этого не сделали):

    ```bash
    git clone https://gitlab.com/ara-project/ara-api.git # Пример URL, уточните актуальный
    cd ara-api
    ```

2. **Установите Poetry** (если еще не установлен).

3. **Установите зависимости проекта** с помощью Poetry:

    ```bash
    poetry install
    ```

    Эта команда создаст виртуальное окружение (если его нет) и установит все зависимости, перечисленные в `pyproject.toml` и `poetry.lock`.

4. **Активируйте виртуальное окружение**, созданное Poetry:

    ```bash
    poetry shell
    ```

    После этого все команды `python`, `pip` и т.д. будут выполняться в контексте этого окружения.

5. **Установите `protoc`** (компилятор Protocol Buffers), если он еще не установлен. Убедитесь, что он доступен в вашем `PATH`.

6. **Сгенерируйте gRPC код** из `.proto` файлов:
    В корне проекта находится скрипт `generate_proto.sh`. Запустите его:

    ```bash
    ./generate_proto.sh
    ```

    Этот шаг необходим после каждого изменения в `.proto` файлах.

## 3. Запуск приложения

После успешной настройки окружения и установки зависимостей, вы можете запустить основное приложение ARA API.

Точка входа определена в `pyproject.toml` как скрипт `ara-api-core`, который указывает на `ara_api.__main__:main`. Для запуска используйте Poetry:

```bash
poetry run ara-api-core
```

Или напрямую через модуль:

```bash
poetry run python -m ara_api
```

Проверьте консольный вывод на наличие ошибок. Если все настроено правильно, gRPC сервер должен запуститься и слушать на указанном в конфигурации порту.

## 4. Конфигурация

Основные параметры приложения настраиваются через модуль `ara_api/_utils/config.py`. Этот модуль может загружать конфигурацию из переменных окружения, файлов `.env` или иметь значения по умолчанию.

* Изучите `ara_api/_utils/config.py` для понимания всех доступных параметров конфигурации.
* При необходимости создайте файл `.env` в корне проекта для переопределения значений по умолчанию (если поддерживается загрузка из `.env`).
* Ключевые параметры могут включать:
  * Порт gRPC сервера (например, `GRPC_PORT`).
  * Параметры подключения к полетному контроллеру (например, `SERIAL_PORT`, `BAUDRATE`).
  * Пути к моделям машинного обучения.
  * Настройки логирования.

## 5. Разработка

* **Ветки**: Создавайте отдельные ветки для каждой новой фичи или исправления бага (`git checkout -b feature/имя-фичи`).
* **Стиль кода**: Следуйте указаниям в [Руководстве для контрибьюторов](./contributing.md) (PEP 8, black, flake8, mypy, docstrings).
* **Тестирование**: Пишите юнит-тесты и интеграционные тесты для нового кода. Проект использует `pytest` для тестирования. Файл `tests/conftest.py` может содержать общие фикстуры для тестов.
  * **Структура тестов**: Тесты располагаются в директории `tests/`. Пример тестов можно найти в `tests/test_flight_operations.py`, где используется `pytest-mock` для мокирования зависимостей.
  * **Запуск тестов**: Запускайте тесты с помощью Poetry:

    ```bash
    poetry run pytest
    ```

  * **Рекомендации по написанию тестов**:
    * Тестируйте отдельные функции и методы (юнит-тесты).
    * Тестируйте взаимодействие между компонентами (интеграционные тесты).
    * Используйте моки для изоляции тестируемого кода от внешних зависимостей (например, реальных gRPC сервисов, полетного контроллера).
    * Стремитесь к высокому покрытию кода тестами.
* **Документация**: Обновляйте документацию при внесении изменений, затрагивающих API или поведение системы.

## 6. Отладка

* **Логирование**: Используйте систему логирования. Уровень логирования и вывод можно настроить в конфигурации. Проверяйте логи для диагностики проблем.
* **Отладчик Python**: Используйте отладчик вашего IDE (VS Code, PyCharm) или стандартный `pdb`.
* **gRPC клиенты**: Используйте инструменты, такие как `grpcurl` или Postman (с поддержкой gRPC), для отправки тестовых запросов к вашим gRPC сервисам.
    Пример с `grpcurl` (если сервер запущен локально на порту, указанном в `ara_api/_utils/config.py`, например, 50051):

    ```bash
    # Список сервисов
    grpcurl -plaintext localhost:50051 list

    # Описание сервиса (пример для MspService)
    grpcurl -plaintext localhost:50051 describe .ara_api.msp.MspService

    # Вызов метода (пример для GetMspData)
    grpcurl -plaintext -d \'{\"codes\": [102, 105]}\' localhost:50051 .ara_api.msp.MspService/GetMspData
    ```

## 7. Работа с Docker (если применимо)

Если проект использует Docker:

* **Сборка образа**: `docker build -t ara-api .`
* **Запуск контейнера**: `docker run -p 50051:50051 --rm ara-api` (адаптируйте порты и другие параметры по необходимости).
* **Docker Compose**: Если есть `docker-compose.yml`, используйте `docker-compose up`.

## 8. Обновление зависимостей

* Для обновления всех зависимостей до последних версий, совместимых с `pyproject.toml`:

    ```bash
    poetry update
    ```

* Для добавления новой зависимости:

    ```bash
    poetry add <package_name>
    ```

Следуя этому руководству, вы сможете успешно настроить свое рабочее окружение и начать разработку ARA API.
