# Руководство для контрибьюторов (ARA API)

Приветствуем ваш интерес к развитию проекта ARA API! Этот документ поможет вам понять, как внести свой вклад.

## 1. Начало работы

* **Форкните репозиторий**: Сделайте форк основного репозитория ARA API на свой GitHub/GitLab аккаунт.
* **Клонируйте форк**: `git clone [URL вашего форка]`
* **Создайте ветку**: `git checkout -b feature/ваша-фича` или `bugfix/описание-багфикса`.

## 2. Стиль кода

Мы придерживаемся следующих стандартов для кода на Python:

* **PEP 8**: Пожалуйста, следуйте [PEP 8 Style Guide for Python Code](https://www.python.org/dev/peps/pep-0008/).
* **Форматирование**: Используйте `black` для автоматического форматирования кода. Конфигурация `black` должна быть совместима с `pyproject.toml`.
* **Линтинг**: Используйте `flake8` или `pylint` для проверки качества кода. Конфигурации линтеров будут добавлены в репозиторий.
* **Типизация**: Используйте аннотации типов Python (`typing` модуль). Код должен проходить проверку `mypy`.
* **Комментарии и Docstrings**:
  * Пишите понятные комментарии для сложных участков кода.
  * Все публичные модули, классы, функции и методы должны иметь docstrings в стиле [Google Python Style Guide](https://google.github.io/styleguide/pyguide.html#38-comments-and-docstrings) или [NumPy/SciPy docstring standard](https://numpydoc.readthedocs.io/en/latest/format.html).
    * Пример для функции:
```python
def my_function(param1: int, param2: str) -> bool:
    """Краткое описание функции.

    Более детальное описание, если необходимо.

    Args:
        param1: Описание первого параметра.
        param2: Описание второго параметра.

    Returns:
        True если успешно, False иначе.

    Raises:
        ValueError: Если param2 некорректен.
    """
    # ... код функции ...
```

## 3. Процесс отправки изменений (Pull Request / Merge Request)

1. **Убедитесь, что код работает**: Перед отправкой изменений, протестируйте их локально.
2. **Напишите тесты**: Для новых функций или исправлений багов, пожалуйста, добавляйте или обновляйте соответствующие юнит-тесты и интеграционные тесты. Тесты должны находиться в директории `tests`.
3. **Обновите документацию**: Если ваши изменения затрагивают API, добавляют новую функциональность или изменяют существующее поведение, обновите соответствующую документацию в папке `docs`.
4. **Коммиты**:
   * Пишите осмысленные сообщения коммитов.
   * Старайтесь делать атомарные коммиты (один коммит – одно логическое изменение).
   * Следуйте [Conventional Commits](https://www.conventionalcommits.org/) если это принято в проекте.
5. **Rebase (при необходимости)**: Перед созданием Pull Request, сделайте `git rebase upstream/main` (или соответствующей ветки), чтобы ваша ветка была основана на последних изменениях из основного репозитория и история коммитов была чистой.
6. **Создайте Pull Request (PR) / Merge Request (MR)**:
   * Отправьте PR/MR из вашей feature-ветки в `main` (или `develop`) ветку основного репозитория.
   * Дайте подробное описание изменений в PR/MR: что было изменено и зачем.
   * Если PR/MR исправляет существующий Issue, укажите его номер (например, `Closes #123`).
7. **Code Review**: Ваш PR/MR будет рассмотрен командой. Будьте готовы ответить на вопросы и внести доработки по результатам ревью.
8. **Слияние**: После успешного ревью и прохождения всех проверок (CI/CD), ваш PR/MR будет слит.

## 4. Сообщения об ошибках (Issues)

* Перед созданием нового Issue, пожалуйста, поищите существующие, чтобы избежать дублирования.
* При создании Issue, предоставьте как можно больше информации:
  * Четкое и описательное название.
  * Шаги для воспроизведения ошибки.
  * Ожидаемое поведение.
  * Фактическое поведение.
  * Версия ПО, ОС, и другие релевантные детали окружения.
  * Логи ошибок и скриншоты (если применимо).

## 5. Предложения по улучшению

Мы всегда рады новым идеям! Вы можете предложить улучшение, создав Issue с соответствующей меткой (например, `enhancement` или `feature-request`).

## 6. Каналы коммуникации

* **Issues в репозитории**: Для обсуждения конкретных задач, багов, фич.
* **(Предположительно) GitLab Merge Requests**: Для код-ревью и обсуждения конкретных изменений.
* **(Возможно) Выделенный чат или форум**: Если проект имеет большое сообщество или требует более оперативного обсуждения (например, Slack, Discord, Gitter). На данный момент не указано.

Спасибо за ваш вклад в ARA API!
