## [1.1.0] - 2025-11-19

### ✨ New Features

- Add context to claude code (dev)
- Add navigation service to gRPC test with metadata
- Add pytest to test deps
- Add .vscode settings, task and other configs to repo
- Add config params for frequency of updating
- Add new UI Helper with rich instead of colorama and pyfiglet
- Add config class for vision detection controller
- Add analyzing of summary and create reports path with txt files
- Add classes for obstacle
- Add test for planning
- Add tests for project(try #2)
- Add debugger for testing (but need to test)
- Add new debug configurations
- Create commands and command_processor
- Test automatic fragment creation
- Create documentations for ara api (test, need to reread)
- Update navigation process class
- Add new tasks in .vscode
- Create context manager
- Add simple smooth algorithm and update config file
- Create gRPCSync class with Singleton pattern
- Create state machine for new service
- Add visualization test for MPPI and Carrot Planner in 3 cases
- Add carrot planner for movement
- Add transform method inside RC dataclass
- Init manim subproject for drawing a animation for docs
- Add gRPC methods test cases
- Add simple goal checker
- Add test planner, need to refactor
- Add new test file for nav commands (test-cmd source)
- Add skeleton of nav algorithms for new planning methods
- Add metadata to navigation service(separation of test logic and client)
- Add import testing and unit tests, update .gitignore
- Add camera controller to vision controller's package
- Add cache singleton for navigation commands
- Add rest wrapper for web gui
- Add test files for visualizing and analyzing of path
- Initial commit for starting navigation local and global planners
- Init data types for msp, vision and navigation nodes
- Init processors files and add msp process manager
- Add new header to ui_helper module
- Add test for msp service
- Add new data types for navigation


### 🐛 Bug Fixes

- Fix fixing imports on generated files
- Complete gRPCSync with singleton pattern
- Change and update dataclasses in data path and in other modules where it used
- Fix circular imports in package
- Fix mermaid diagram
- Fix circular imports
- Correction of a misprint
- Fix cmd_land_rc rpc in navigation proto
- Fix analyzer pages imports
- Test and fix debug
- Fix vision service(missing format in string and wrong method for qr)
- Fix imports (DroneKinematics)
- Fix imports im grpc
- Fix and test msp_service
- Fix imports, add new data_types and change path in test.sh
- Fix inconvenient logic for creation and use altitude dataclass
- Fix imports in generated files
- Fix coverage testing
- Fix imports and method Rotation.from_two_position
- Auto stash before merge of "feature/services" and "origin/feature/services"
- Fix thread to process in MSPProcessorManager
- Delete unused imports and fix logging logic
- Fix type of values, refactor 1 DocString and create logger and gRPC for services configs
- Fix out of bound error that find in debug mode
- Fix msp_data.RC dataclass and add map method to altitude
- Fix circular imports and delete unused exceptions module
- Fix update_loop in msp service
- Fix default aruco type dict
- Fix msp_service sending data and add main for debug only MSP service
- Rename file names and update grpc fetcher
- Fix vision_service lock after request and QR-codes
- Fix RLock Exception in processors when they try to log data
- Fix transmitter abstract methods
- Fix test_nav_cmd test-case
- Fix RC dataclass


### 🔄 Changes

- Fix vector3 in move rpc (before was vector2)
- Delete unused test files for plotly visualization
- Update import from communication module with new grpc logic
- Update config for testing how works application manager
- Migrate to v1.1.0 from v1.1.0rc2 and change dev status to 4 - Beta
- Simple refactor vision processor
- Update protobuf files and regenerate new instances
- Change some log levels
- Refactoring data path (all dataclasses inside one file -> one dataclass inside one file)
- Complete land cmd, add data cache and fix expo in TakeOff cmd
- Migrate from cached dict to cache class singleton in state machine and all commands
- Pre-writing _core path
- Remove pages from analyzer (need to rewrite with gRPCSync)
- New logic for speed cmd, update log levels, fix rc data and config, fix land and takeoff cmds
- Add new methods and classes import from _communication
- Fix imports (local_planner) (wtf)
- Refactor planner path, all planner in algorithms path
- Update config file
- Redefining analyser logic
- Updating the rules for the ruff linter and adding towncrier with its settings
- Init new structure for api
- Reinitialize vision module
- Add scipy as new dependency
- Update transmitter and refactor
- Update .gitignore(.pytest_cache/)
- Refactor behavior and complete nav state machine
- Update vision data_types
- Refactor by ruff
- Remember that i need to commit __init__ :/
- Update docs, but need to reread and rewrite smth
- Remove creating of "log" path that never used
- Update project info and gitignore
- Rename testing path from "tests" to "test"
- Refactoring with ruff for PEP
- Small refactor vision service
- Stage changelog fragments
- Commit changelog fragments
- Remove path reports from git
- Update generate_proto.sh with new project architecture
- Delete dijkstra from PlanningAlgorithm
- Fix vision service and add more debug output
- Refactor test grpc integration
- Change source for logging (one class instead each other changing)
- Refactoring docs to doc  and add towncrier as autochangelogger
- Full refactor msp package (need to write sender for rc and zero odom)
- Update vision controller
- Delete unused tests
- Add new dependencies for monitoring processors
- Update generate_proto.sh with new logic of protobuf
- Add post-processing to generate_proto.bash for changing imports
- Add representation magic method to msp and nav data types
- Update transmitter and interfaces from review(need to test)
- Simple refactoring of manager, processors and comment grpc_sync
- Update __init__.py in service module
- Early switch to version 1.1.0-pre (for merge)
- Remove test planner, refactoring now
- Refactor obstacle detector and remove local_planner
- Move last ara-api to backup path
- Adapting carrot-test for real life terrain
- Update data logic and fix bags
- Add dynamic window size to UI Helper
- Add cache singleton to __init__ in utils
- Import override for utils
- Update gitignore for mypy and ruff cache
- Update navigation service
- Small docs refactoring
- Refactoring test cases
- Amend "reinitilize navigation module" and fix import in __main__.py
- Fix takeoff cmd and nav state machine, add new logic
- Update vision_controller and vision_processor, but need to test
- Update msp messages
- Define import logic for communication package
- Reinitialize navigation module
- Update logging logic for ara-api
- Delete useful config params
- Refactoring vscode tasks
- Add new metadata and source for testing
- Fix pyproject.toml development status
- Refactor test grpc methods
- Stage and commit fragments
- Refactor application manager class
- Update navigation service, need insert new logic to this
- Fix generation_proto.sh grpc-tool generation call
- Update MSP's processor and service
- Add new fragments
- Refactor imports by ruff and fix circular imports
- Add correction from formula 10 in "Biased Sampling for MPPI"
- Delete unuseful class variable
- Update global planner and carrot testing for smoothing
- Implementation of GoalChecker and CarrotPlanner logic into the global planner
- Add navigation and vision processes to manager
- Refactor test path
- Change config for test
- Premature migration for version 1.0.1
- Additional refactoring of imports


### 💥 Breaking Changes

- Add MPPI to nav core as controller, add new dataclasses, create config for MPPI and fix imports
- Critical safety fixes and production readiness improvements
- Change project architecture(again and need to refactor more)
- Big refactoring msp service and add velocity data from FC
- Update protobuf and grpc logic
- Remove backup ara_api code from project
- Create new biased mppi controller (14 steps for compute control)
- Initialize new logic for starting the app
- Change privacy of submodule in project and upgrade to 1.0.0-pre1
- Add new navigation checker, smoother and 3 controllers
