# Архитектура проекта

Проект ARA API построен на модульной архитектуре, что обеспечивает гибкость и масштабируемость. Основные компоненты взаимодействуют через четко определенные интерфейсы, преоимущественно с использованием gRPC для межпроцессного взаимодействия

## Ключевые компоненты

1. **Core (Ядро)** (`ara_api/_core`):

   * **Manager (`manager.py`)**: Центральный управляющий компонент, координирующий работу всех сервисов.

   * **Processors (`processors/`)**: Процессы из `multiproccessing`, отвечающие за запуск `services`(MSP, Navigation, Vision).

     * `msp_processor.py`: Запуск процесса под **msp_service**.

     * `nav_processor.py`: Запуск процесса под **nav_service**.

     * `vision_processor.py`: Запуск процесса под **vision_service**.

   * **Services (`services/`)**: Реализация конкретных сервисов, предоставляющих функциональность API.

     * **MSP (`msp/`)**: Сервис для взаимодействия с полетным контроллером по протоколу MSP.

       * `msp_service.py`: Реализация gRPC сервера для MSP.

       * `controller/msp_controller.py`: Логика управления и отправки команд MSP.

     * **Navigation (`nav/`)**: Сервис для управления навигацией дрона.

       * `nav_service.py`: Реализация gRPC сервера для навигации.

       * **planner**: Компоненты для планирования маршрутов (глобальный и локальный планировщики).
         * **algorithms**: Алгоритмы, используемые для построения маршрутов
           * `graph_based`: Алгоритмы, в основе которых лежат графы
           * `sampling_based`: Алгоритмы, в основе которых лежат методы теории вероятности
           * `simple`: Простые алгоритмы построения пути
         * `global_planner`: Основной модуль, осуществляющий построение траектории
       * **smoother**:
         * `simple_smoother`: Простой алгоритм сглаживания траектории
       * **checker**:
         * `simple_goal_checker`:
       * **controller**:
       * **obstacle**:

     * **Vision (`vision/`)**: Сервис для работы с системой компьютерного зрения.

       * `vision_service.py`: Реализация gRPC сервера для задач зрения.

       * `controller/vision_controller.py`: Логика обработки изображений и других визуальных данных.

     * **Analyzer (`analyzer/`)**: Инструмент для анализа данных и графического отображения (например, для лабораторных работ).

       * `app.py`: Основное приложение анализатора.

       * `pages/`: Различные страницы интерфейса анализатора.

2. **Utils (Утилиты)** (`ara_api/_utils`):

   * **Communication (`communication/`)**: Модули для организации связи.

     * `grpc_sync.py`: Синхронный клиент для gRPC.

     * `websocket_sync.py`: Синхронный клиент для WebSocket.

     * `gRPC/`: Сгенерированные файлы protobuf для gRPC (клиентские и серверные части, определения сообщений).

     * `protobuf/`: Файлы `.proto`, описывающие структуру сообщений и сервисов gRPC.

   * **Data (`data/`)**: Классы данных, используемые в проекте (например, для IMU, GPS, изображений).

     * `msp_data.py`: Структуры данных для MSP.

     * `nav_data.py`: Структуры данных для навигации (векторы, пути, состояния).

     * `vision_data.py`: Структуры данных для компьютерного зрения (изображения, маркеры).

   * `config.py`: Конфигурационные параметры проекта (например, частоты опроса датчиков).

   * `logger.py`: Система логирования.

   * `exception.py`: Пользовательские исключения.

   * `debug.py`: Инструменты для отладки.

## Диаграмма компонентов

```mermaid
---
config:
  theme: base
  themeVariables:
    primaryColor: "#ffffff"
    primaryTextColor: "#2e3338"
    primaryBorderColor: "#bfbfbf"
    lineColor: "#6b7280"
    sectionBkgColor: "#f9fafb"
    altSectionBkgColor: "#f3f4f6"
    gridColor: "#e5e7eb"
    cScale0: "#dc2626"  # MSP - яркий красный
    cScale1: "#059669"  # Navigation - изумрудный
    cScale2: "#2563eb"  # Vision - синий
    cScale3: "#16a34a"  # Analyzer - зелёный
    cScale4: "#d97706"  # Utils - оранжевый
    cScale5: "#9333ea"  # Core/Manager - фиолетовый
    cScale6: "#ea580c"  # Processors - тёмно-оранжевый
---
graph TD
 subgraph ARA_API [ARA API]
  subgraph Core ["_core"]
   Manager:::managerStyle
   subgraph Processors
    MSPProcessor:::processorStyle
    NavProcessor:::processorStyle
    VisionProcessor:::processorStyle
   end
   subgraph Services
    subgraph msp
     subgraph msp_service_controller ["controller"]
      msp_commands:::mspStyle
      msp_controller:::mspStyle
     end
     msp_service:::mspStyle
    end
    subgraph nav
     subgraph checker
      simple_goal_checker:::navStyle
     end
     subgraph nav_controller
      subgraph mppi
       mppi_ctrl["controller"]:::navStyle
       mppi_cost_function["cost_function"]:::navStyle
       mppi_dynamic_model["dynamic_model"]:::navStyle
      end
      dynamic_window_approach["DWA (NC)"]:::navStyle
      graceful["graceful (NC)"]:::navStyle
     end
     subgraph obstacle
      obstacle_detector:::navStyle
     end
     subgraph planner
      subgraph algorithms
       subgraph graph_based
        a_star_planner["A* (NC)"]:::navStyle
       end
       subgraph sampling_based
        rrt_star_planner["RRT* (NC)"]:::navStyle
       end
       subgraph simple
        carrot_planner:::navStyle
       end
      end
      global_planner:::navStyle
     end
     subgraph smoother
      simple_smoother:::navStyle
     end
     nav_service:::navStyle
    end
    subgraph vision
     subgraph vsn_path_controller ["controller"]
      vision_controller:::visionStyle
     end
     vision_service:::visionStyle
    end
    subgraph analyzer
     subgraph pages
      accel_pages:::analyzerStyle
      analog_pages:::analyzerStyle
      freq_pages:::analyzerStyle
      gyro_pages:::analyzerStyle
      motor_pages:::analyzerStyle
     end
     subgraph alzr_path_controller ["controller"]
      offline_controller:::analyzerStyle
      online_controller:::analyzerStyle
     end
     app:::analyzerStyle
    end
   end
  end
  subgraph Utils ["_utils"]
   subgraph communication
    gRPC:::utilsStyle
    protobuf:::utilsStyle
    grpc_sync:::utilsStyle
    websocket_sync:::utilsStyle
   end
   subgraph data
    msp_data:::utilsStyle
    nav_data:::utilsStyle
    vision_data:::utilsStyle
   end
   config:::utilsStyle
   debug:::utilsStyle
   exception:::utilsStyle
   interfaces:::utilsStyle
   logger:::utilsStyle
   transmitter:::utilsStyle
  end
 end

 classDef mspStyle fill:#dc2626,stroke:#b91c1c,stroke-width:2px,color:#ffffff
 classDef navStyle fill:#059669,stroke:#047857,stroke-width:2px,color:#ffffff
 classDef visionStyle fill:#2563eb,stroke:#1d4ed8,stroke-width:2px,color:#ffffff
 classDef analyzerStyle fill:#16a34a,stroke:#15803d,stroke-width:2px,color:#ffffff
 classDef utilsStyle fill:#d97706,stroke:#b45309,stroke-width:2px,color:#ffffff
 classDef managerStyle fill:#9333ea,stroke:#7c3aed,stroke-width:3px,color:#ffffff
 classDef processorStyle fill:#ea580c,stroke:#c2410c,stroke-width:2px,color:#ffffff

 %% MSP Package взаимодействия
 msp_commands --> msp_controller
 msp_controller --> msp_service 
 msp_service --> MSPProcessor
 transmitter --> msp_controller
 msp_data --> msp_service

 %% Vision Service взаимодействия
 vision_controller --> vision_service
 vision_service --> VisionProcessor
 vision_data --> vision_service
 
 %% Navigation Service взаимодействия
 simple_smoother --> global_planner
 carrot_planner --> global_planner
 a_star_planner --> global_planner
 rrt_star_planner --> global_planner
 global_planner --> nav_service
 simple_goal_checker --> nav_service
 mppi_cost_function --> mppi_ctrl
 mppi_dynamic_model --> mppi_ctrl
 mppi_ctrl --> nav_service
 dynamic_window_approach --> nav_service
 graceful --> nav_service
 obstacle_detector --> nav_service
 nav_service --> NavProcessor
 nav_data --> nav_service

 %% Analyzer взаимодействия
 accel_pages --> offline_controller
 analog_pages --> offline_controller
 gyro_pages --> offline_controller
 motor_pages --> offline_controller
 freq_pages --> offline_controller
 accel_pages --> online_controller
 analog_pages --> online_controller
 gyro_pages --> online_controller
 motor_pages --> online_controller 
 freq_pages --> online_controller
 online_controller --> app
 offline_controller --> app
 
 %% gRPC Communication
 grpc_sync --> nav_service
 grpc_sync --> msp_service
 grpc_sync --> vision_service
 nav_data --> grpc_sync
 msp_data --> grpc_sync
 vision_data --> grpc_sync
 gRPC --> grpc_sync
 protobuf --> gRPC
 websocket_sync --> grpc_sync

 %% Core Manager взаимодействия
 MSPProcessor --> Manager
 NavProcessor --> Manager
 VisionProcessor --> Manager

 %% Utils взаимодействия
 config --> Manager
 config --> msp_service
 config --> nav_service
 config --> vision_service
 logger --> Manager
 logger --> MSPProcessor
 logger --> NavProcessor
 logger --> VisionProcessor
 exception --> Manager
 exception --> msp_service
 exception --> nav_service
 exception --> vision_service
 interfaces --> Manager
 interfaces --> MSPProcessor
 interfaces --> NavProcessor
 interfaces --> VisionProcessor

 %% Data Flow
 msp_data --> msp_commands
 nav_data --> simple_goal_checker
 nav_data --> global_planner
 nav_data --> obstacle_detector
 vision_data --> vision_controller

 %% Debug взаимодействия
 debug --> Manager
 debug --> msp_controller
 debug --> nav_service
 debug --> vision_service
```

## Потоки данных

![alt text](image.png)

## Конфигурация

##

## Конфигурация

Гибкость и адаптируемость ARA API обеспечивается через систему конфигурации.

* **Централизованный файл конфигурации**: Основные параметры проекта задаются в файле `ara_api/_utils/config.py`. Это включает в себя:
  * Сетевые адреса и порты для gRPC сервисов.
  * Параметры подключения к аппаратному обеспечению (например, COM-порты, скорости передачи данных для MSP).
  * Частоты опроса датчиков и обновления данных.
  * Таймауты для различных операций.
  * Настройки логирования (уровень, формат вывода).
* **Структура конфигурации**: Конфигурационные параметры могут быть сгруппированы по модулям или функциональным блокам для удобства управления.
* **Возможность переопределения**: Рекомендуется предусмотреть механизм переопределения стандартных конфигурационных значений через переменные окружения или внешние конфигурационные файлы (например, `.env`, `config.yaml`). Это упрощает настройку приложения для различных сред развертывания (разработка, тестирование, продуктив) без изменения исходного кода. (Примечание: текущая реализация в `config.py` должна быть проверена на наличие такой возможности или дополнена ею).
* **Динамическая конфигурация**: Для некоторых параметров может быть полезна возможность изменения конфигурации "на лету" без перезапуска приложения, однако это требует дополнительной реализации механизмов управления конфигурацией.
