
# ARA API

---

![badge](https://img.shields.io/badge/Language-Python-green) ![badge](https://img.shields.io/badge/ARA_API-Software-blue) ![badge](https://img.shields.io/badge/Version-v1.0.0-red)

**Applied Robotics Avia API** — это современный API для управления линейкой дронов и самолетов компании **Applied Robotics Avia**, а также для работы с симулятором **AgroTechSim**.


--- 
## 📖 Описание 

Данный проект предлагает единый интерфейс для управления, анализа и автоматизации полетов. **ara-api** сочетает простоту использования, высокую производительность и поддержку множества языков программирования. 

### Основные особенности: 
1. Экранирование работы от конечного пользователя. 
2. Интегрированная документация, загружаемая вместе с API. 
3. Высокая скорость работы благодаря использованию HTTP/2 и gRPC. 
4. Простота запуска и настройки. 
5. Поддержка анализаторов для выполнения лабораторных работ. 
6. Предохранительные меры для безопасности автономных полетов. 

--- 
## 🌟 Возможности 

- **Мульти-языковая поддержка**: Автономное управление доступно на следующих языках: C#/.NET, C++, Dart, Go, Java, Kotlin, Node.js, Objective-C, PHP, Python, Ruby.  
- **Протокол gRPC**: используется как внутри приложения, так и для внешнего взаимодействия. 
- **Данные с полетного контроллера**: чтение одометрии, ориентации, IMU, оптического потока и дальномера.
- **Встроенный анализатор**: запись и анализ логов, а также два режима запуска анализатора - online и offline.
- **Библиотека работы с камерой**: анализ изображения и получение готовых значений(QR-code, Aruco, Blob)

--- 
## 🚀 Установка проекта 
```
foo@bar: pip3 install ara-api
```
## 📚 Использование
### Терминал

1) Запуск ядра API:
```bash
foo@bar:~$ ara-api-core 
```
2) Запуск анализатора: 
```bash
foo@bar:~$ ara-api-analyzer
```
3) Запуск пакета для работы с камерой:
```bash
foo@bar:~$ ara-api-vision 
```

***⚠️Важно!!! Перед началом использования удостоверьтесь, что ваш дрон обновлен до самой актуальной версии***

---
## Вызов документации по использованию команд:
1) Запуск ядра API:
```bash
foo@bar:~$ ara-api-core --help
```
2) Запуск анализатора: 
```bash
foo@bar:~$ ara-api-analyzer --help
```
3) Запуск пакета для работы с камерой:
```bash
foo@bar:~$ ara-api-vision --help
```

---
## 🧩Функции библиотеки ```ara_core```
---
### `takeoff(altitude)` 
Вызывает сервис взлёта. 
- **Параметры:** 
	- `altitude` (float): Высота, на которую нужно подняться. 
- **Возвращает:** 
	- `str`: Статус операции взлёта. 
--- 
### `land()` 
Вызывает сервис посадки. 
- **Возвращает:** 
	- `str`: Статус операции посадки. 
--- 
### `move_by_point(x, y)` 
Вызывает сервис перемещения. 
- **Параметры:**
	- `x` (float): Координата X точки, в которую нужно переместиться. 
	- `y` (float): Координата Y точки, в которую нужно переместиться. 
- **Возвращает:** 
	- `str`: Статус операции перемещения. 
--- 
### `change_altitude(altitude)` 
Вызывает сервис изменения высоты. 
- **Параметры:**
	- `altitude` (float): значение высоты в метрах, на которую нужно переместиться. 
- **Возвращает:** 
	- `str`: Статус операции перемещения. 
--- 
### `set_velocity(vx, vy)` 
Вызывает сервис задания скорости. 
- **Параметры:**
	- `vx` (float): Скорость дрона по X. 
	- `vy` (float): Скорость дрона по Y. 
- **Возвращает:** 
	- `str`: Статус операции перемещения. 
--- 
### `reset_velocity_state()` 
Вызывает сервис перемещения
- **Возвращает:** 
	- `str`: Статус операции перемещения. 
--- 
### `get_imu_data()` 
Получает данные IMU (инерциального измерительного устройства) от сервиса драйвера. 
- **Возвращает:** 
	- `dict`: Словарь с данными гироскопа и акселерометра. 
--- 
### `get_attitude_data()` 
Получает данные ориентации от сервиса драйвера. 
- **Возвращает:** 
	- `dict`: Словарь с данными об углах ориентации. 
--- 
### `get_odometry_data()` 
Получает данные одометрии от сервиса драйвера. 
- **Возвращает:** 
	- `dict`: Словарь с данными о положении и скорости. 
--- 
### `get_optical_flow_data()`
Получает данные оптического потока от сервиса драйвера. 
- **Возвращает:** 
	- `dict`: Словарь с данными об оптическом потоке.
