"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesPatch = exports.PatchType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Values for `kubectl patch` --type argument
 */
var PatchType;
(function (PatchType) {
    /**
     * JSON Patch, RFC 6902
     */
    PatchType["JSON"] = "json";
    /**
     * JSON Merge patch
     */
    PatchType["MERGE"] = "merge";
    /**
     * Strategic merge patch
     */
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 */
class KubernetesPatch extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_KubernetesPatchProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KubernetesPatch);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: props.resourceNamespace ?? 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PatchType: props.patchType ?? PatchType.STRATEGIC,
            },
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
_a = JSII_RTTI_SYMBOL_1;
KubernetesPatch[_a] = { fqn: "@aws-cdk/aws-eks.KubernetesPatch", version: "1.177.0" };
//# sourceMappingURL=data:application/json;base64,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