/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.terrainanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.terrainanalyst.HydrologyAnalystNative;
import com.supermap.analyst.terrainanalyst.InternalDatasetGrid;
import com.supermap.analyst.terrainanalyst.InternalDatasetVector;
import com.supermap.analyst.terrainanalyst.InternalDatasets;
import com.supermap.analyst.terrainanalyst.InternalGeometry;
import com.supermap.analyst.terrainanalyst.InternalHandle;
import com.supermap.analyst.terrainanalyst.InternalResource;
import com.supermap.analyst.terrainanalyst.InternalToolkitTerrainAnalyst;
import com.supermap.analyst.terrainanalyst.QuadMeshParameter;
import com.supermap.analyst.terrainanalyst.StreamOrderType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class HydrologyAnalyst {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private HydrologyAnalyst() {
    }

    public static GeoRegion[] buildQuadMesh(QuadMeshParameter quadMeshParameter) {
        HydrologyAnalyst.checkQuadMeshParameter(quadMeshParameter);
        long l = 0L;
        l = InternalHandle.getHandle((com.supermap.data.InternalHandle)quadMeshParameter.getQuadMeshRegion());
        long[] lArray = HydrologyAnalystNative.jni_BuildQuadMeshRegions(l, quadMeshParameter.getRowCount(), quadMeshParameter.getColCount(), quadMeshParameter.getLeftBottomPoint().getX(), quadMeshParameter.getLeftBottomPoint().getY(), quadMeshParameter.getRightBottomPoint().getX(), quadMeshParameter.getRightBottomPoint().getY(), quadMeshParameter.getRightTopPoint().getX(), quadMeshParameter.getRightTopPoint().getY(), quadMeshParameter.getLeftTopPoint().getX(), quadMeshParameter.getLeftTopPoint().getY());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)quadMeshParameter);
        GeoRegion[] geoRegionArray = null;
        if (lArray == null) {
            geoRegionArray = new GeoRegion[]{};
        } else {
            int n = lArray.length;
            geoRegionArray = new GeoRegion[n];
            for (int i = 0; i < n; ++i) {
                geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
            }
        }
        return geoRegionArray;
    }

    public static DatasetVector buildQuadMesh(QuadMeshParameter quadMeshParameter, Datasource targetDatasource, String resultGridName) {
        HydrologyAnalyst.checkQuadMeshParameter(quadMeshParameter);
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        l = InternalHandle.getHandle((com.supermap.data.InternalHandle)quadMeshParameter.getQuadMeshRegion());
        long l2 = 0L;
        l2 = HydrologyAnalystNative.jni_BuildQuadMeshDataset(l, quadMeshParameter.getRowCount(), quadMeshParameter.getColCount(), quadMeshParameter.getLeftBottomPoint().getX(), quadMeshParameter.getLeftBottomPoint().getY(), quadMeshParameter.getRightBottomPoint().getX(), quadMeshParameter.getRightBottomPoint().getY(), quadMeshParameter.getRightTopPoint().getX(), quadMeshParameter.getRightTopPoint().getY(), quadMeshParameter.getLeftTopPoint().getX(), quadMeshParameter.getLeftTopPoint().getY(), quadMeshParameter.getRowField(), quadMeshParameter.getColField(), InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource), resultGridName);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)quadMeshParameter);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    private static void checkQuadMeshParameter(QuadMeshParameter quadMeshParameter) {
        if (quadMeshParameter == null) {
            String string = InternalResource.loadString("quadMeshParameter", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getQuadMeshRegion() == null) {
            String string = InternalResource.loadString("quadMeshRegion", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRowCount() < 2) {
            String string = InternalResource.loadString("rowCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getColCount() < 2) {
            String string = InternalResource.loadString("colCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getLeftBottomPoint().isEmpty()) {
            String string = InternalResource.loadString("leftBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRightBottomPoint().isEmpty()) {
            String string = InternalResource.loadString("rightBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRightTopPoint().isEmpty()) {
            String string = InternalResource.loadString("rightTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getLeftTopPoint().isEmpty()) {
            String string = InternalResource.loadString("leftTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public static DatasetGrid fillSink(DatasetGrid surfaceGrid, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == surfaceGrid) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = surfaceGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = HydrologyAnalystNative.jni_FillSink(l2, l, resultGridName, 0L);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid fillSink(DatasetGrid surfaceGrid, Datasource targetDatasource, String resultGridName, DatasetVector realSinkVector) {
        long l;
        if (null == surfaceGrid) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = surfaceGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (realSinkVector != null) {
            if (realSinkVector.getType() != DatasetType.POINT && realSinkVector.getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("realSinkVector", "UnSupportedDatasetType", "terrainanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)realSinkVector);
        }
        long l4 = HydrologyAnalystNative.jni_FillSink(l2, l, resultGridName, l3);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid flowDirection(DatasetGrid surfaceGrid, boolean forceFlowAtEdge, Datasource targetDatasource, String resultGridName, String dropGridName) {
        long l;
        long l2;
        if (null == surfaceGrid) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = surfaceGrid.getDatasource();
        }
        if (0L == (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(dropGridName)) {
            String string = InternalResource.loadString("dropGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = HydrologyAnalystNative.jni_FlowDirection(l3, true, forceFlowAtEdge, l2, dropGridName, resultGridName);
        long l4 = lArray[0];
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        if ((l = lArray[1]) != 0L) {
            DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(l, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid;
    }

    public static DatasetGrid flowDirection(DatasetGrid surfaceGrid, boolean forceFlowAtEdge, Datasource targetDatasource, String resultGridName) {
        long l;
        long l2;
        if (null == surfaceGrid) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = surfaceGrid.getDatasource();
        }
        if (0L == (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = HydrologyAnalystNative.jni_FlowDirection(l3, false, forceFlowAtEdge, l2, null, resultGridName);
        long l4 = lArray[0];
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        if ((l = lArray[1]) != 0L) {
            DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(l, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid;
    }

    public static DatasetGrid flowAccumulation(DatasetGrid directionGrid, DatasetGrid weightGrid, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (null != weightGrid) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)weightGrid);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_FlowAccumulation(l2, l3, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid flowLength(DatasetGrid directionGrid, DatasetGrid weightGrid, boolean upStream, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (null != weightGrid) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)weightGrid);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_FlowLength(l2, l3, upStream, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid basin(DatasetGrid directionGrid, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = HydrologyAnalystNative.jni_Basin(l2, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid pourPoints(DatasetGrid directionGrid, DatasetGrid accumulationGrid, int areaLimit, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == accumulationGrid) {
            String string = InternalResource.loadString("accumulationGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)accumulationGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("accumulationGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_SnapPourPoints(l2, l3, areaLimit, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid snapPourPoint(Dataset pourPointDataset, DatasetGrid accumulationGrid, double snapDistance, String pourPointField, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == pourPointDataset) {
            String string = InternalResource.loadString("pourPointDataset", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)pourPointDataset);
        if (0L == l2) {
            String string = InternalResource.loadString("pourPointDataset", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == accumulationGrid) {
            String string = InternalResource.loadString("accumulationGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)accumulationGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("accumulationGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = accumulationGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_AdjustPourPoint(l2, l3, snapDistance, pourPointField, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid watershed(DatasetGrid directionGrid, Point2Ds pourPoints, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = pourPoints.getCount();
        if (n <= 0) {
            String string = InternalResource.loadString("pourPoints", "PointsCount <= 0", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pourPoints.getItem(i).getX();
            dArray2[i] = pourPoints.getItem(i).getY();
        }
        long l3 = HydrologyAnalystNative.jni_WatershedPoint2Ds(l2, dArray, dArray2, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid watershed(DatasetGrid directionGrid, DatasetGrid pourPointsGrid, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == pourPointsGrid) {
            String string = InternalResource.loadString("pourPointsGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)pourPointsGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("pourPointsGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_WatershedDatasetGrid(l2, l3, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetVector streamToLine(DatasetGrid streamGrid, DatasetGrid directionGrid, Datasource targetDatasource, String resultDatasetName, StreamOrderType orderType) {
        long l;
        if (null == streamGrid) {
            String string = InternalResource.loadString("streamGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)streamGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("streamGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultDatasetName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_StreamToLine(l2, l3, l, resultDatasetName, orderType.value());
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetGrid streamLink(DatasetGrid streamGrid, DatasetGrid directionGrid, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == streamGrid) {
            String string = InternalResource.loadString("streamGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)streamGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("streamGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_StreamLink(l2, l3, l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid streamOrder(DatasetGrid streamGrid, DatasetGrid directionGrid, StreamOrderType orderType, Datasource targetDatasource, String resultGridName) {
        long l;
        if (null == streamGrid) {
            String string = InternalResource.loadString("streamGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)streamGrid);
        if (0L == l2) {
            String string = InternalResource.loadString("streamGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == directionGrid) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        if (0L == l3) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasource) {
            targetDatasource = directionGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(resultGridName)) {
            String string = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = HydrologyAnalystNative.jni_StreamOrder(l2, l3, orderType.value(), l, resultGridName);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "HydrologyAnalyst";
        boolean bl = InternalToolkitTerrainAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        HydrologyAnalyst.fireStepped(steppedEvent);
        InternalToolkitTerrainAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitTerrainAnalyst.managerProducts(InternalToolkitTerrainAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitTerrainAnalyst.verifyLicense(arrayList);
    }
}

