/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.mapping.Layer;
import com.supermap.ui.InternalHandle;
import com.supermap.ui.InternalMappingResource;
import com.supermap.ui.VectorizationSettingNative;
import java.awt.Color;

public class VectorizationSetting
extends InternalHandleDisposable {
    private Layer m_layer;

    public VectorizationSetting() {
        long l = VectorizationSettingNative.jni_New();
        this.setHandle(l, true);
        this.m_layer = null;
    }

    public VectorizationSetting(VectorizationSetting setting) {
        if (setting == null) {
            String string = InternalMappingResource.loadString("setting", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (setting.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("setting", "Global_InvalidConstructorArgument", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = VectorizationSettingNative.jni_Clone(setting.getHandle());
        this.setHandle(l, true);
        this.m_layer = setting.m_layer;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)setting));
    }

    VectorizationSetting(long handle) {
        this.setHandle(handle, false);
    }

    public Layer getRasterLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("getRasterLayer()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_layer;
    }

    public void setRasterLayer(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("setRasterLayer(Layer layer)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle(layer) == 0L) {
            String string = InternalMappingResource.loadString("Layer layer", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = layer.getDataset();
        DatasetType datasetType = dataset.getType();
        if (!(datasetType.equals((Object)DatasetType.IMAGE) || datasetType.equals((Object)DatasetType.GRID) || datasetType.equals((Object)DatasetType.WCS) || datasetType.equals((Object)DatasetType.WMS))) {
            String string = InternalMappingResource.loadString("layer", "VectorlizationSetting_UnsupportLayer", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_layer = layer;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        VectorizationSettingNative.jni_SetRasterLayer(this.getHandle(), l);
    }

    public double getFilter() {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("getFilter()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return VectorizationSettingNative.jni_GetFilter(this.getHandle());
    }

    public void setFilter(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("setFilter(double value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalMappingResource.loadString("value", "VectorlizationSetting_FilterShouldBePositive", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        VectorizationSettingNative.jni_SetFilter(this.getHandle(), value);
    }

    public int getSmoothness() {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("getSmoothness()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return VectorizationSettingNative.jni_GetSmoothness(this.getHandle());
    }

    public void setSmoothness(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("setSmoothness(int value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalMappingResource.loadString("value", "VectorlizationSetting_SmoothnessShouldBePositive", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        VectorizationSettingNative.jni_SetSmoothness(this.getHandle(), value);
    }

    public int getColorTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("getColorTolerance()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return VectorizationSettingNative.jni_GetColorTolerance(this.getHandle());
    }

    public void setColorTolerance(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("setColorTolerance(int value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            value = 0;
        }
        if (value > 255) {
            value = 255;
        }
        VectorizationSettingNative.jni_SetColorTolerance(this.getHandle(), value);
    }

    public Color getBackgroundColor() {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("getBackgroundColor()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorizationSettingNative.jni_GetBackgroundColor(this.getHandle());
        return new Color(n);
    }

    public void setBackgroundColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("setBackgroundColor(Color value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        VectorizationSettingNative.jni_SetBackgroundColor(this.getHandle(), value.getRGB());
    }

    public boolean getAutoPan() {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("getAutoPan()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return VectorizationSettingNative.jni_GetAutoPan(this.getHandle());
    }

    public void setAutoPan(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalMappingResource.loadString("setAutoPan(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        VectorizationSettingNative.jni_SetAutoPan(this.getHandle(), value);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{AutoPan=");
        stringBuffer.append(this.getAutoPan());
        stringBuffer.append(",BackgroundColor=");
        stringBuffer.append(this.getBackgroundColor());
        stringBuffer.append(",ColorTolerance=");
        stringBuffer.append(this.getColorTolerance());
        stringBuffer.append(",Filter=");
        stringBuffer.append(this.getFilter());
        stringBuffer.append(",RasterLayer=");
        stringBuffer.append(this.getRasterLayer().getName());
        stringBuffer.append(",Smoothness=");
        stringBuffer.append(this.getSmoothness());
        stringBuffer.append("};");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalMappingResource.loadString("dispose()", "Handle_UndisposableObject", "ui_mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            VectorizationSettingNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
        this.setHandle(0L);
        this.m_layer = null;
    }

    protected void changeHandle(long handle) {
        if (handle == 0L) {
            String string = InternalMappingResource.loadString("handle", "Global_InvalidConstructorArgument", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            VectorizationSettingNative.jni_Delete(this.getHandle());
        }
        this.setHandle(handle, false);
    }
}

