/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Enum;
import com.supermap.ui.EditHandleType;
import com.supermap.ui.InternalEnum;
import com.supermap.ui.InternalMappingResource;
import com.supermap.ui.MapControl;
import com.supermap.ui.MapControlNative;

public class EditHandleOptions {
    private int m_state = 65535;
    private MapControl m_mapControl = null;
    private boolean isOwnerMapControl = false;

    public EditHandleOptions() {
    }

    EditHandleOptions(MapControl mapcontrol) {
        this.m_mapControl = mapcontrol;
        this.isOwnerMapControl = true;
    }

    public boolean get(EditHandleType type) {
        int n = InternalEnum.getUGCValue(type);
        if (!this.isOwnerMapControl) {
            int n2 = this.m_state & n;
            return n2 != 0;
        }
        if (this.m_mapControl == null) {
            String string = InternalMappingResource.loadString("get(EditHandleType type)", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = MapControl.getHandle(this.m_mapControl);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("get(EditHandleType type)", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetEditHandleType(l, n);
    }

    public void set(EditHandleType type, boolean value) {
        int n = InternalEnum.getUGCValue(type);
        if (!this.isOwnerMapControl) {
            this.m_state = value ? (this.m_state |= n) : (this.m_state &= ~n);
        } else {
            if (this.m_mapControl == null) {
                String string = InternalMappingResource.loadString("set(EditHandleType type, boolean value)", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = MapControl.getHandle(this.m_mapControl);
            if (l == 0L) {
                String string = InternalMappingResource.loadString("set(EditHandleType type, boolean value)", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            MapControlNative.jni_SetEditHandleType(l, n, value);
        }
    }

    public void enableAll() {
        if (!this.isOwnerMapControl) {
            this.setState(65535);
        } else {
            if (this.m_mapControl == null) {
                String string = InternalMappingResource.loadString("enableAll", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = MapControl.getHandle(this.m_mapControl);
            if (l == 0L) {
                String string = InternalMappingResource.loadString("enableAll", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            MapControlNative.jni_EnableAllEditHandleType(l);
        }
    }

    public void disableAll() {
        if (!this.isOwnerMapControl) {
            this.setState(0);
        } else {
            if (this.m_mapControl == null) {
                String string = InternalMappingResource.loadString("disableAll", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = MapControl.getHandle(this.m_mapControl);
            if (l == 0L) {
                String string = InternalMappingResource.loadString("disableAll", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            MapControlNative.jni_DisableAllEditHandleType(l);
        }
    }

    void setState(int value) {
        this.m_state = value;
    }

    public String toString() {
        if (this.isOwnerMapControl) {
            if (this.m_mapControl == null) {
                String string = InternalMappingResource.loadString("get(EditHandleType type)", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = MapControl.getHandle(this.m_mapControl);
            if (l == 0L) {
                String string = InternalMappingResource.loadString("get(EditHandleType type)", "Global_OwnerHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        Enum[] enumArray = Enum.getEnums(EditHandleType.class);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{EnableHandes={");
        for (int i = 0; i < enumArray.length; ++i) {
            EditHandleType editHandleType = (EditHandleType)enumArray[i];
            if (!this.get(editHandleType)) continue;
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(editHandleType.name());
        }
        stringBuffer.append("}}");
        return stringBuffer.toString();
    }
}

