/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.DynamicLayer;
import com.supermap.mapping.DynamicLayersNative;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Map;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class DynamicLayers
extends InternalHandle {
    private ArrayList<DynamicLayer> m_DynamicLayers;
    private Map m_map;
    ReentrantLock m_lock;

    DynamicLayers(long handle, Map map) {
        this.setHandle(handle);
        this.m_map = map;
        this.m_lock = this.m_map.m_lock;
        this.m_DynamicLayers = new ArrayList();
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return DynamicLayersNative.jni_GetCount(this.getHandle());
    }

    public int add(DynamicLayer dynamicLayer, Boolean addToHead) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dynamicLayer == null) {
            String string = InternalResource.loadString("dynamicLayer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dynamicLayer);
        if (l == 0L) {
            String string = InternalResource.loadString("dynamicLayer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        if (this.indexOf(dynamicLayer) > -1) {
            return n;
        }
        boolean bl = DynamicLayersNative.jni_Add(this.getHandle(), l, addToHead);
        if (bl) {
            InternalHandleDisposable.setIsDisposable(dynamicLayer, false);
            if (addToHead.booleanValue()) {
                this.m_DynamicLayers.add(0, dynamicLayer);
                n = 0;
            } else {
                this.m_DynamicLayers.add(dynamicLayer);
                n = this.getCount() - 1;
            }
        }
        return n;
    }

    public boolean insert(int index, DynamicLayer dynamicLayer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (dynamicLayer == null) {
            String string = InternalResource.loadString("dynamicLayer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dynamicLayer);
        if (l == 0L) {
            String string = InternalResource.loadString("dynamicLayer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(dynamicLayer) > -1) {
            return false;
        }
        boolean bl = DynamicLayersNative.jni_Insert(this.getHandle(), index, l);
        if (bl) {
            InternalHandleDisposable.setIsDisposable(dynamicLayer, false);
            this.m_DynamicLayers.add(index, dynamicLayer);
        }
        return bl;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        DynamicLayer dynamicLayer = this.get(index);
        dynamicLayer.clearHandle();
        DynamicLayersNative.jni_Remove(this.getHandle(), index);
        this.m_DynamicLayers.remove(index);
        return true;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        DynamicLayersNative.jni_RemoveAll(this.getHandle());
        if (this.m_DynamicLayers != null) {
            for (DynamicLayer dynamicLayer : this.m_DynamicLayers) {
                if (dynamicLayer == null) continue;
                dynamicLayer.clearHandle();
            }
            this.m_DynamicLayers.clear();
        }
    }

    protected void cleanHandle() {
        if (this.m_DynamicLayers != null) {
            for (DynamicLayer dynamicLayer : this.m_DynamicLayers) {
                if (dynamicLayer == null) continue;
                dynamicLayer.clearHandle();
            }
            this.m_DynamicLayers.clear();
        }
        this.setHandle(0L);
    }

    public DynamicLayer get(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_DynamicLayers.get(index);
    }

    public int indexOf(DynamicLayer dynamicLayer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dynamicLayer == null) {
            String string = InternalResource.loadString("dynamicLayer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dynamicLayer);
        if (l == 0L) {
            String string = InternalResource.loadString("dynamicLayer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_DynamicLayers.indexOf((Object)dynamicLayer);
    }

    protected static DynamicLayers createInstance(long handle, Map map) {
        return new DynamicLayers(handle, map);
    }
}

