/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalGeometry;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.ServiceAreaResultNative;
import com.supermap.analyst.networkanalyst.TransportationAnalystResult;
import com.supermap.data.GeoRegion;

public class ServiceAreaResult
extends TransportationAnalystResult {
    private GeoRegion[] m_serviceRegions = null;
    private int[] m_serviceRouteCounts = null;

    ServiceAreaResult(long handle) {
        super(handle);
    }

    public GeoRegion[] getServiceRegions() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getServiceRegions()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_serviceRegions == null && (n = ServiceAreaResultNative.jni_GetServiceRegionCount(this.getHandle())) > 0) {
            long[] lArray = new long[n];
            ServiceAreaResultNative.jni_GetServiceRegionHandles(this.getHandle(), lArray);
            this.m_serviceRegions = new GeoRegion[n];
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == 0L) continue;
                this.m_serviceRegions[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_serviceRegions[i], false);
            }
        }
        return this.m_serviceRegions;
    }

    public int[] getServiceRouteCounts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getServiceRouteCounts()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_serviceRouteCounts == null) {
            this.m_serviceRouteCounts = ServiceAreaResultNative.jni_GetServiceRouteCounts(this.getHandle());
        }
        return this.m_serviceRouteCounts;
    }
}

